/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ITKTEMPLATES_IMPORTIMAGECONTAINER_H
#define ITKTEMPLATES_IMPORTIMAGECONTAINER_H

#include <ItkTemplatesAPI.h>
#include <itkImportImageContainer.h>
#include <itkCovariantVector.h>
#include <itkOffset.h>

extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, bool>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, char>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, double>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, float>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, int>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::CovariantVector<double, 2u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::CovariantVector<double, 3u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::CovariantVector<float, 2u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::CovariantVector<float, 3u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::FixedArray<float, 2u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::FixedArray<float, 3u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Offset<2u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Offset<3u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Vector<double, 1u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Vector<double, 2u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Vector<double, 3u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Vector<float, 1u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Vector<float, 2u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, itk::Vector<float, 3u>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, long>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, long long>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, short>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, signed char>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, std::complex<double>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, std::complex<float>>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, unsigned char>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, unsigned int>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, unsigned long>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, unsigned long long>;
extern template class ITKTEMPLATES_API itk::ImportImageContainer<itk::SizeValueType, unsigned short>;

#endif // ITKTEMPLATES_IMPORTIMAGECONTAINER_H