export declare class Rune<K> {
    readonly ir: K;
    barrier: boolean;
    constructor(ir: K, barrier?: boolean);
    prev: Rune<K>;
    next: Rune<K>;
    digraph: null | Digraph<K>;
    prevSameDigraph: null | Rune<K>;
    nextSameDigraph: null | Rune<K>;
}
export interface KeyProvider<K> {
    getIrKey(k: K): string;
    isBarrier(k: K): boolean;
}
export interface RuleBuilder<K, RN, RI> {
    createNonTerminalRule(symbol: K, parts: K[]): RN;
    createInputRule(parts: K[]): RI;
}
export interface NonTerminalBuilder<K> {
    createNonTerminal(a: K, b: K): K;
}
export declare class Input<K> {
    constructor(nop: K);
    sentinel: Rune<K>;
    private makeLink;
    append(rune: Rune<K>): void;
    remove(rune: Rune<K>): void;
}
declare class DigraphSentinel {
    next: DigraphSentinel;
    prev: DigraphSentinel;
}
declare class Digraph<K> extends DigraphSentinel {
    readonly key: string;
    firstOccurrence: Rune<K>;
    count: number;
    constructor(key: string, firstOccurrence: Rune<K>);
    next: DigraphSentinel;
    prev: DigraphSentinel;
    static getKey<K>(kp: KeyProvider<K>, a: Rune<K>, b: Rune<K>): string;
    removeFromBucket(): void;
    insertToBucket(head: DigraphSentinel): void;
}
export declare class Session<K> {
    private keyProvider;
    constructor(keyProvider: KeyProvider<K>);
    buckets: (null | DigraphSentinel | Digraph<K>)[];
    digraphMap: Map<string, Digraph<K>>;
    append(input: Input<K>, char: K): void;
    appendString(input: Input<K>, str: Iterable<K>): void;
    private appendRuneToInput;
    protected addDigraph(rFirst: Rune<K>, rSecond: Rune<K>): Digraph<K> | null;
    removeDigraphLink(rune: Rune<K>): void;
    private updateDigBucket;
    collectBuckets(): void;
    getEntry(count: number): null | Digraph<K>;
    stringOf(input: Input<K>): string;
    doSubstitute(dig: Digraph<K>, nonTerminal: K): void;
    doCompress<RN, RI>(ntSrc: NonTerminalBuilder<K>, rb?: RuleBuilder<K, RN, RI>): Generator<RN, void, unknown>;
    inputToRule<RN, RI>(input: Input<K>, rb: RuleBuilder<K, RN, RI>): RI;
}
export {};
//# sourceMappingURL=pairing.d.ts.map