//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhealthcareapis

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FhirDestinationsClient contains the methods for the FhirDestinations group.
// Don't use this type directly, use NewFhirDestinationsClient() instead.
type FhirDestinationsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFhirDestinationsClient creates a new instance of FhirDestinationsClient with the specified values.
//   - subscriptionID - The subscription identifier.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFhirDestinationsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FhirDestinationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FhirDestinationsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListByIotConnectorPager - Lists all FHIR destinations for the given IoT Connector
//
// Generated from API version 2021-11-01
//   - resourceGroupName - The name of the resource group that contains the service instance.
//   - workspaceName - The name of workspace resource.
//   - iotConnectorName - The name of IoT Connector resource.
//   - options - FhirDestinationsClientListByIotConnectorOptions contains the optional parameters for the FhirDestinationsClient.NewListByIotConnectorPager
//     method.
func (client *FhirDestinationsClient) NewListByIotConnectorPager(resourceGroupName string, workspaceName string, iotConnectorName string, options *FhirDestinationsClientListByIotConnectorOptions) *runtime.Pager[FhirDestinationsClientListByIotConnectorResponse] {
	return runtime.NewPager(runtime.PagingHandler[FhirDestinationsClientListByIotConnectorResponse]{
		More: func(page FhirDestinationsClientListByIotConnectorResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FhirDestinationsClientListByIotConnectorResponse) (FhirDestinationsClientListByIotConnectorResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FhirDestinationsClient.NewListByIotConnectorPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByIotConnectorCreateRequest(ctx, resourceGroupName, workspaceName, iotConnectorName, options)
			}, nil)
			if err != nil {
				return FhirDestinationsClientListByIotConnectorResponse{}, err
			}
			return client.listByIotConnectorHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByIotConnectorCreateRequest creates the ListByIotConnector request.
func (client *FhirDestinationsClient) listByIotConnectorCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, iotConnectorName string, options *FhirDestinationsClientListByIotConnectorOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/iotconnectors/{iotConnectorName}/fhirdestinations"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if iotConnectorName == "" {
		return nil, errors.New("parameter iotConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{iotConnectorName}", url.PathEscape(iotConnectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByIotConnectorHandleResponse handles the ListByIotConnector response.
func (client *FhirDestinationsClient) listByIotConnectorHandleResponse(resp *http.Response) (FhirDestinationsClientListByIotConnectorResponse, error) {
	result := FhirDestinationsClientListByIotConnectorResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IotFhirDestinationCollection); err != nil {
		return FhirDestinationsClientListByIotConnectorResponse{}, err
	}
	return result, nil
}
