//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcontainerservice

import "time"

// AddonStatusProfile - Defines the addon status profile.
type AddonStatusProfile struct {
	// Error message while deploying the addon
	ErrorMessage *string

	// Name of the addon
	Name *string

	// Observed phase of the addon on the target cluster. Possible values include: 'pending', 'provisioning', 'provisioning {HelmChartInstalled}',
	// 'provisioning {MSICertificateDownloaded}', 'provisioned',
	// 'deleting', 'failed', 'upgrading'
	Phase *AddonPhase

	// Indicates whether the addon is ready
	Ready *bool
}

// AgentPool - The agentPool resource definition
type AgentPool struct {
	// Extended Location definition
	ExtendedLocation *ExtendedLocation

	// The resource location
	Location   *string
	Properties *AgentPoolProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource Name
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource Type
	Type *string
}

// AgentPoolListResult - A list of agent pool resources.
type AgentPoolListResult struct {
	NextLink *string
	Value    []*AgentPool
}

// AgentPoolPatch - The agentPool resource patch definition
type AgentPoolPatch struct {
	// Resource tags
	Tags map[string]*string
}

type AgentPoolProperties struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32

	// The version of node image
	NodeImageVersion *string

	// Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType is Linux. The default is Windows2019 when
	// OSType is Windows.
	OSSKU *OSSKU

	// The particular KubernetesVersion's Image's OS Type (Linux, Windows)
	OSType *OsType

	// Defines the observed state of the agent pool
	Status *AgentPoolProvisioningStatusStatus

	// VmSize - The size of the agent pool VMs.
	VMSize *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ResourceProvisioningState
}

// AgentPoolProvisioningStatusOperationStatus - Contains Provisioning errors
type AgentPoolProvisioningStatusOperationStatus struct {
	Error       *AgentPoolProvisioningStatusOperationStatusError
	OperationID *string
	Status      *string
}

type AgentPoolProvisioningStatusOperationStatusError struct {
	Code    *string
	Message *string
}

// AgentPoolProvisioningStatusStatus - Defines the observed state of the agent pool
type AgentPoolProvisioningStatusStatus struct {
	// ErrorMessage - Error messages during creation of agent pool
	ErrorMessage *string

	// Contains Provisioning errors
	OperationStatus *AgentPoolProvisioningStatusOperationStatus
	ReadyReplicas   []*AgentPoolUpdateProfile
}

// AgentPoolUpdateProfile - AgentPool update configuration
type AgentPoolUpdateProfile struct {
	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32

	// VmSize - The size of the agent pool VMs.
	VMSize *string
}

// CloudProviderProfile - The underlying cloud infra provider properties.
type CloudProviderProfile struct {
	// InfraNetworkProfile - List of infra network profiles for the provisioned cluster
	InfraNetworkProfile *CloudProviderProfileInfraNetworkProfile
}

// CloudProviderProfileInfraNetworkProfile - InfraNetworkProfile - List of infra network profiles for the provisioned cluster
type CloudProviderProfileInfraNetworkProfile struct {
	// Array of references to azure resource corresponding to the Network object e.g.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}
	VnetSubnetIDs []*string
}

// ControlPlaneEndpointProfileControlPlaneEndpoint - API server endpoint for the control plane
type ControlPlaneEndpointProfileControlPlaneEndpoint struct {
	// Host IP address for API server
	HostIP *string

	// Port for the API server
	Port *int32
}

// ControlPlaneProfile - The control plane properties for the provisioned cluster.
type ControlPlaneProfile struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string

	// API server endpoint for the control plane
	ControlPlaneEndpoint *ControlPlaneEndpointProfileControlPlaneEndpoint

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32

	// Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfileProperties

	// Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string

	// The version of node image
	NodeImageVersion *string

	// Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType is Linux. The default is Windows2019 when
	// OSType is Windows.
	OSSKU *OSSKU

	// The particular KubernetesVersion's Image's OS Type (Linux, Windows)
	OSType *OsType

	// VmSize - The size of the agent pool VMs.
	VMSize *string
}

// CredentialResult - The credential result response.
type CredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte
}

// ExtendedLocation - Extended Location definition
type ExtendedLocation struct {
	// The extended location name.
	Name *string

	// The extended location type.
	Type *ExtendedLocationTypes
}

// HybridIdentityMetadata - Defines the hybridIdentityMetadata.
type HybridIdentityMetadata struct {
	// REQUIRED; Resource properties.
	Properties *HybridIdentityMetadataProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// HybridIdentityMetadataList - List of hybridIdentityMetadata.
type HybridIdentityMetadataList struct {
	// REQUIRED; Array of hybridIdentityMetadata
	Value []*HybridIdentityMetadata

	// Url to follow for getting next page of hybridIdentityMetadata.
	NextLink *string
}

// HybridIdentityMetadataProperties - Defines the resource properties.
type HybridIdentityMetadataProperties struct {
	// Onboarding public key for provisioning the Managed identity for the HybridAKS cluster.
	PublicKey *string

	// Unique id of the parent provisioned cluster resource.
	ResourceUID *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ResourceProvisioningState
}

// KubernetesPatchVersions - Kubernetes Patch Version profile
type KubernetesPatchVersions struct {
	// Whether the kubernetes version variant (Linux, Windows, Windows2022) is ready or not
	Readiness []*KubernetesVersionReadiness

	// Possible upgrade path for given patch version
	Upgrades []*string
}

// KubernetesVersionCapabilities - Capabilities on this kubernetes version
type KubernetesVersionCapabilities struct {
	SupportPlan []*string
}

// KubernetesVersionProfile - The supported kubernetes versions.
type KubernetesVersionProfile struct {
	// Extended Location definition
	ExtendedLocation *ExtendedLocation

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY
	Properties *KubernetesVersionProfileProperties

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// KubernetesVersionProfileList - A list of kubernetes version resources.
type KubernetesVersionProfileList struct {
	NextLink *string
	Value    []*KubernetesVersionProfile
}

type KubernetesVersionProfileProperties struct {
	// List of supported Kubernetes versions
	Values []*KubernetesVersionProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ResourceProvisioningState
}

// KubernetesVersionProperties - Kubernetes version profile for given major.minor release
type KubernetesVersionProperties struct {
	// READ-ONLY; Capabilities on this kubernetes version
	Capabilities *KubernetesVersionCapabilities

	// READ-ONLY; Whether this version is in preview mode.
	IsPreview *bool

	// READ-ONLY; Patch versions of a Kubernetes release
	PatchVersions map[string]*KubernetesPatchVersions

	// READ-ONLY; major.minor version of Kubernetes release
	Version *string
}

// KubernetesVersionReadiness - Whether a particular kubernetes version's variant (CBLMariner, Windows, Windows2022) is ready
// or not
type KubernetesVersionReadiness struct {
	// Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType is Linux. The default is Windows2019 when
	// OSType is Windows.
	OSSKU *OSSKU

	// READ-ONLY; If image is not ready, the error message for version not being ready
	ErrorMessage *string

	// READ-ONLY; The particular KubernetesVersion's Image's OS Type (Linux, Windows)
	OSType *OsType

	// READ-ONLY; Whether or not the given image is ready
	Ready *bool
}

// LinuxProfileProperties - LinuxProfile - Profile for Linux VMs in the container service cluster.
type LinuxProfileProperties struct {
	// SSH - SSH configuration for Linux-based VMs running on Azure.
	SSH *LinuxProfilePropertiesSSH
}

// LinuxProfilePropertiesSSH - SSH - SSH configuration for Linux-based VMs running on Azure.
type LinuxProfilePropertiesSSH struct {
	// PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
	PublicKeys []*LinuxProfilePropertiesSSHPublicKeysItem
}

type LinuxProfilePropertiesSSHPublicKeysItem struct {
	// KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with
	// or without headers.
	KeyData *string
}

// ListCredentialResponse - The list kubeconfig result response.
type ListCredentialResponse struct {
	Error      *ListCredentialResponseError
	Properties *ListCredentialResponseProperties

	// READ-ONLY; Operation Id
	ID *string

	// READ-ONLY; Operation Name
	Name *string

	// READ-ONLY; ARM Resource Id of the provisioned cluster instance
	ResourceID *string

	// READ-ONLY; Provisioning state of the resource
	Status *ResourceProvisioningState
}

type ListCredentialResponseError struct {
	Code    *string
	Message *string
}

type ListCredentialResponseProperties struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*CredentialResult
}

// NamedAgentPoolProfile - Agent pool profile along with a name parameter
type NamedAgentPoolProfile struct {
	// AvailabilityZones - The list of Availability zones to use for nodes. Datacenter racks modelled as zones
	AvailabilityZones []*string

	// Count - Number of agents to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default
	// value is 1.
	Count *int32

	// Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string

	// The version of node image
	NodeImageVersion *string

	// Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType is Linux. The default is Windows2019 when
	// OSType is Windows.
	OSSKU *OSSKU

	// The particular KubernetesVersion's Image's OS Type (Linux, Windows)
	OSType *OsType

	// VmSize - The size of the agent pool VMs.
	VMSize *string
}

// NetworkProfile - Profile of network configuration.
type NetworkProfile struct {
	// LoadBalancerProfile - Profile of the cluster load balancer.
	LoadBalancerProfile *NetworkProfileLoadBalancerProfile

	// NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'calico', 'flannel'. Default
	// is 'calico'
	NetworkPolicy *NetworkPolicy

	// PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string
}

// NetworkProfileLoadBalancerProfile - LoadBalancerProfile - Profile of the cluster load balancer.
type NetworkProfileLoadBalancerProfile struct {
	// Count - Number of load balancer VMs. The default value is 0.
	Count *int32
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// ProvisionedClusterLicenseProfile - The license profile of the provisioned cluster.
type ProvisionedClusterLicenseProfile struct {
	// Indicates whether Azure Hybrid Benefit is opted in
	AzureHybridBenefit *AzureHybridBenefit
}

// ProvisionedClusterPoolUpgradeProfile - The list of available upgrade versions.
type ProvisionedClusterPoolUpgradeProfile struct {
	// List of orchestrator types and versions available for upgrade.
	Upgrades []*ProvisionedClusterPoolUpgradeProfileProperties

	// READ-ONLY; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string

	// READ-ONLY; The Agent Pool name.
	Name *string

	// READ-ONLY; The particular KubernetesVersion's Image's OS Type (Linux, Windows)
	OSType *OsType
}

// ProvisionedClusterPoolUpgradeProfileProperties - The upgrade properties.
type ProvisionedClusterPoolUpgradeProfileProperties struct {
	// READ-ONLY; Whether the Kubernetes version is currently in preview.
	IsPreview *bool

	// READ-ONLY; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string
}

// ProvisionedClusterProperties - All properties of the provisioned cluster
type ProvisionedClusterProperties struct {
	// The agent pools of the cluster.
	AgentPoolProfiles []*NamedAgentPoolProfile

	// The underlying cloud infra provider properties.
	CloudProviderProfile *CloudProviderProfile

	// ControlPlane - ControlPlane Configuration
	ControlPlane *ControlPlaneProfile

	// KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string

	// The license profile of the provisioned cluster.
	LicenseProfile *ProvisionedClusterLicenseProfile

	// LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
	LinuxProfile *LinuxProfileProperties

	// NetworkProfile - Profile of network configuration.
	NetworkProfile *NetworkProfile

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ResourceProvisioningState

	// READ-ONLY; HybridAKSClusterStatus defines the observed state of HybridAKSCluster
	Status *ProvisionedClusterPropertiesStatus
}

// ProvisionedClusterPropertiesStatus - HybridAKSClusterStatus defines the observed state of HybridAKSCluster
type ProvisionedClusterPropertiesStatus struct {
	// Status of the control plane components
	ControlPlaneStatus []*AddonStatusProfile

	// ErrorMessage - Error messages during creation of cluster
	ErrorMessage *string

	// Contains Provisioning errors
	OperationStatus *ProvisionedClusterPropertiesStatusOperationStatus
}

// ProvisionedClusterPropertiesStatusOperationStatus - Contains Provisioning errors
type ProvisionedClusterPropertiesStatusOperationStatus struct {
	Error       *ProvisionedClusterPropertiesStatusOperationStatusError
	OperationID *string
	Status      *string
}

type ProvisionedClusterPropertiesStatusOperationStatusError struct {
	Code    *string
	Message *string
}

// ProvisionedClusterUpgradeProfile - The list of available upgrades for compute pools.
type ProvisionedClusterUpgradeProfile struct {
	// REQUIRED; The properties of the upgrade profile.
	Properties *ProvisionedClusterUpgradeProfileProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProvisionedClusterUpgradeProfileProperties - Control plane and agent pool upgrade profiles.
type ProvisionedClusterUpgradeProfileProperties struct {
	// REQUIRED; The list of available upgrade versions for agent pools.
	AgentPoolProfiles []*ProvisionedClusterPoolUpgradeProfile

	// REQUIRED; The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ProvisionedClusterPoolUpgradeProfile

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ResourceProvisioningState
}

// ProvisionedClusters - The provisionedClusterInstances resource definition.
type ProvisionedClusters struct {
	// Extended Location definition
	ExtendedLocation *ExtendedLocation

	// All properties of the provisioned cluster
	Properties *ProvisionedClusterProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProvisionedClustersListResult - A list of provisioned clusters resources.
type ProvisionedClustersListResult struct {
	NextLink *string
	Value    []*ProvisionedClusters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// VMSKUCapabilities - describes the vm sku capabilities object
type VMSKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature
	Name *string

	// READ-ONLY; An invariant if the feature is measured by quantity
	Value *string
}

// VMSKUProfile - The list of supported VM SKUs.
type VMSKUProfile struct {
	// Extended Location definition
	ExtendedLocation *ExtendedLocation

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY
	Properties *VMSKUProfileProperties

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VMSKUProfileList - A list of VM SKU resources.
type VMSKUProfileList struct {
	NextLink *string
	Value    []*VMSKUProfile
}

type VMSKUProfileProperties struct {
	// Array of HybridAKS Support VM Skus
	Values []*VMSKUProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *ResourceProvisioningState
}

// VMSKUProperties - The profile for supported VM skus
type VMSKUProperties struct {
	// READ-ONLY; A name value pair to describe the specific vm's capability
	Capabilities []*VMSKUCapabilities

	// READ-ONLY; The name of the VM Family
	Name *string

	// READ-ONLY; The resource type of the vm
	ResourceType *string

	// READ-ONLY; The size of the VM Family
	Size *string

	// READ-ONLY; The tier of the VM Family
	Tier *string
}

// VirtualNetwork - The virtualNetworks resource definition.
type VirtualNetwork struct {
	// REQUIRED; The geo-location where the resource lives
	Location         *string
	ExtendedLocation *VirtualNetworkExtendedLocation

	// HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
	Properties *VirtualNetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type VirtualNetworkExtendedLocation struct {
	// The extended location name.
	Name *string

	// The extended location type.
	Type *string
}

// VirtualNetworkProperties - HybridAKSNetworkSpec defines the desired state of HybridAKSNetwork
type VirtualNetworkProperties struct {
	// Address of the DNS servers associated with the network
	DNSServers []*string

	// Address of the DHCP servers associated with the network
	DhcpServers []*string

	// Address of the Gateway associated with the network
	Gateway *string

	// IP Address Prefix of the network
	IPAddressPrefix  *string
	InfraVnetProfile *VirtualNetworkPropertiesInfraVnetProfile

	// Virtual IP Pool for Kubernetes
	VipPool []*VirtualNetworkPropertiesVipPoolItem

	// VLAN Id used by the network
	VlanID *int32

	// IP Pool for Virtual Machines
	VmipPool []*VirtualNetworkPropertiesVmipPoolItem

	// READ-ONLY
	ProvisioningState *ProvisioningState

	// READ-ONLY; HybridAKSNetworkStatus defines the observed state of HybridAKSNetwork
	Status *VirtualNetworkPropertiesStatus
}

type VirtualNetworkPropertiesInfraVnetProfile struct {
	// Infra network profile for HCI platform
	Hci *VirtualNetworkPropertiesInfraVnetProfileHci

	// Infra network profile for VMware platform
	Vmware *VirtualNetworkPropertiesInfraVnetProfileVmware
}

// VirtualNetworkPropertiesInfraVnetProfileHci - Infra network profile for HCI platform
type VirtualNetworkPropertiesInfraVnetProfileHci struct {
	// Resource group in MOC(Microsoft On-premises Cloud)
	MocGroup *string

	// Location in MOC(Microsoft On-premises Cloud)
	MocLocation *string

	// Virtual Network name in MOC(Microsoft On-premises Cloud)
	MocVnetName *string
}

// VirtualNetworkPropertiesInfraVnetProfileVmware - Infra network profile for VMware platform
type VirtualNetworkPropertiesInfraVnetProfileVmware struct {
	// Name of the network segment in VSphere
	SegmentName *string
}

// VirtualNetworkPropertiesStatus - HybridAKSNetworkStatus defines the observed state of HybridAKSNetwork
type VirtualNetworkPropertiesStatus struct {
	// Contains Provisioning errors
	OperationStatus *VirtualNetworkPropertiesStatusOperationStatus
}

// VirtualNetworkPropertiesStatusOperationStatus - Contains Provisioning errors
type VirtualNetworkPropertiesStatusOperationStatus struct {
	Error       *VirtualNetworkPropertiesStatusOperationStatusError
	OperationID *string

	// Phase represents the current phase of the virtual network provisioning. E.g. Pending, Running, Terminating, Failed etc.
	Phase  *string
	Status *string
}

type VirtualNetworkPropertiesStatusOperationStatusError struct {
	Code    *string
	Message *string
}

type VirtualNetworkPropertiesVipPoolItem struct {
	// Ending IP address for the IP Pool
	EndIP *string

	// Starting IP address for the IP Pool
	StartIP *string
}

type VirtualNetworkPropertiesVmipPoolItem struct {
	// Ending IP address for the IP Pool
	EndIP *string

	// Starting IP address for the IP Pool
	StartIP *string
}

type VirtualNetworksListResult struct {
	NextLink *string
	Value    []*VirtualNetwork
}

// VirtualNetworksPatch - The virtualNetworks resource patch definition.
type VirtualNetworksPatch struct {
	// Resource tags
	Tags map[string]*string
}
