//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogic

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIDeploymentParameterMetadata.
func (a APIDeploymentParameterMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isRequired", a.IsRequired)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "visibility", a.Visibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIDeploymentParameterMetadata.
func (a *APIDeploymentParameterMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "isRequired":
			err = unpopulate(val, "IsRequired", &a.IsRequired)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "visibility":
			err = unpopulate(val, "Visibility", &a.Visibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIDeploymentParameterMetadataSet.
func (a APIDeploymentParameterMetadataSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "packageContentLink", a.PackageContentLink)
	populate(objectMap, "redisCacheConnectionString", a.RedisCacheConnectionString)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIDeploymentParameterMetadataSet.
func (a *APIDeploymentParameterMetadataSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "packageContentLink":
			err = unpopulate(val, "PackageContentLink", &a.PackageContentLink)
			delete(rawMsg, key)
		case "redisCacheConnectionString":
			err = unpopulate(val, "RedisCacheConnectionString", &a.RedisCacheConnectionString)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperation.
func (a APIOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperation.
func (a *APIOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationAnnotation.
func (a APIOperationAnnotation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "family", a.Family)
	populate(objectMap, "revision", a.Revision)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationAnnotation.
func (a *APIOperationAnnotation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "family":
			err = unpopulate(val, "Family", &a.Family)
			delete(rawMsg, key)
		case "revision":
			err = unpopulate(val, "Revision", &a.Revision)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationListResult.
func (a APIOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationListResult.
func (a *APIOperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationPropertiesDefinition.
func (a APIOperationPropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", a.API)
	populate(objectMap, "annotation", a.Annotation)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "inputsDefinition", a.InputsDefinition)
	populate(objectMap, "isNotification", a.IsNotification)
	populate(objectMap, "isWebhook", a.IsWebhook)
	populate(objectMap, "pageable", a.Pageable)
	populate(objectMap, "responsesDefinition", a.ResponsesDefinition)
	populate(objectMap, "summary", a.Summary)
	populate(objectMap, "trigger", a.Trigger)
	populate(objectMap, "triggerHint", a.TriggerHint)
	populate(objectMap, "visibility", a.Visibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationPropertiesDefinition.
func (a *APIOperationPropertiesDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &a.API)
			delete(rawMsg, key)
		case "annotation":
			err = unpopulate(val, "Annotation", &a.Annotation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "inputsDefinition":
			err = unpopulate(val, "InputsDefinition", &a.InputsDefinition)
			delete(rawMsg, key)
		case "isNotification":
			err = unpopulate(val, "IsNotification", &a.IsNotification)
			delete(rawMsg, key)
		case "isWebhook":
			err = unpopulate(val, "IsWebhook", &a.IsWebhook)
			delete(rawMsg, key)
		case "pageable":
			err = unpopulate(val, "Pageable", &a.Pageable)
			delete(rawMsg, key)
		case "responsesDefinition":
			err = unpopulate(val, "ResponsesDefinition", &a.ResponsesDefinition)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &a.Summary)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &a.Trigger)
			delete(rawMsg, key)
		case "triggerHint":
			err = unpopulate(val, "TriggerHint", &a.TriggerHint)
			delete(rawMsg, key)
		case "visibility":
			err = unpopulate(val, "Visibility", &a.Visibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIReference.
func (a APIReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "brandColor", a.BrandColor)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "iconUri", a.IconURI)
	populate(objectMap, "integrationServiceEnvironment", a.IntegrationServiceEnvironment)
	populate(objectMap, "name", a.Name)
	populateAny(objectMap, "swagger", a.Swagger)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIReference.
func (a *APIReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "brandColor":
			err = unpopulate(val, "BrandColor", &a.BrandColor)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "iconUri":
			err = unpopulate(val, "IconURI", &a.IconURI)
			delete(rawMsg, key)
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &a.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "swagger":
			err = unpopulate(val, "Swagger", &a.Swagger)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceBackendService.
func (a APIResourceBackendService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIResourceBackendService.
func (a *APIResourceBackendService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceDefinitions.
func (a APIResourceDefinitions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "modifiedSwaggerUrl", a.ModifiedSwaggerURL)
	populate(objectMap, "originalSwaggerUrl", a.OriginalSwaggerURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIResourceDefinitions.
func (a *APIResourceDefinitions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "modifiedSwaggerUrl":
			err = unpopulate(val, "ModifiedSwaggerURL", &a.ModifiedSwaggerURL)
			delete(rawMsg, key)
		case "originalSwaggerUrl":
			err = unpopulate(val, "OriginalSwaggerURL", &a.OriginalSwaggerURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceGeneralInformation.
func (a APIResourceGeneralInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "iconUrl", a.IconURL)
	populate(objectMap, "releaseTag", a.ReleaseTag)
	populate(objectMap, "termsOfUseUrl", a.TermsOfUseURL)
	populate(objectMap, "tier", a.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIResourceGeneralInformation.
func (a *APIResourceGeneralInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "iconUrl":
			err = unpopulate(val, "IconURL", &a.IconURL)
			delete(rawMsg, key)
		case "releaseTag":
			err = unpopulate(val, "ReleaseTag", &a.ReleaseTag)
			delete(rawMsg, key)
		case "termsOfUseUrl":
			err = unpopulate(val, "TermsOfUseURL", &a.TermsOfUseURL)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &a.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceMetadata.
func (a APIResourceMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ApiType", a.APIType)
	populate(objectMap, "brandColor", a.BrandColor)
	populate(objectMap, "connectionType", a.ConnectionType)
	populate(objectMap, "deploymentParameters", a.DeploymentParameters)
	populate(objectMap, "hideKey", a.HideKey)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "wsdlImportMethod", a.WsdlImportMethod)
	populate(objectMap, "wsdlService", a.WsdlService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIResourceMetadata.
func (a *APIResourceMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ApiType":
			err = unpopulate(val, "APIType", &a.APIType)
			delete(rawMsg, key)
		case "brandColor":
			err = unpopulate(val, "BrandColor", &a.BrandColor)
			delete(rawMsg, key)
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &a.ConnectionType)
			delete(rawMsg, key)
		case "deploymentParameters":
			err = unpopulate(val, "DeploymentParameters", &a.DeploymentParameters)
			delete(rawMsg, key)
		case "hideKey":
			err = unpopulate(val, "HideKey", &a.HideKey)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "wsdlImportMethod":
			err = unpopulate(val, "WsdlImportMethod", &a.WsdlImportMethod)
			delete(rawMsg, key)
		case "wsdlService":
			err = unpopulate(val, "WsdlService", &a.WsdlService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIResourcePolicies.
func (a APIResourcePolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", a.Content)
	populate(objectMap, "contentLink", a.ContentLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIResourcePolicies.
func (a *APIResourcePolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &a.ContentLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceProperties.
func (a APIResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiDefinitionUrl", a.APIDefinitionURL)
	populate(objectMap, "apiDefinitions", a.APIDefinitions)
	populate(objectMap, "backendService", a.BackendService)
	populate(objectMap, "capabilities", a.Capabilities)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "connectionParameters", a.ConnectionParameters)
	populate(objectMap, "generalInformation", a.GeneralInformation)
	populate(objectMap, "integrationServiceEnvironment", a.IntegrationServiceEnvironment)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "policies", a.Policies)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "runtimeUrls", a.RuntimeUrls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIResourceProperties.
func (a *APIResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiDefinitionUrl":
			err = unpopulate(val, "APIDefinitionURL", &a.APIDefinitionURL)
			delete(rawMsg, key)
		case "apiDefinitions":
			err = unpopulate(val, "APIDefinitions", &a.APIDefinitions)
			delete(rawMsg, key)
		case "backendService":
			err = unpopulate(val, "BackendService", &a.BackendService)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &a.Capabilities)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "connectionParameters":
			err = unpopulate(val, "ConnectionParameters", &a.ConnectionParameters)
			delete(rawMsg, key)
		case "generalInformation":
			err = unpopulate(val, "GeneralInformation", &a.GeneralInformation)
			delete(rawMsg, key)
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &a.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &a.Policies)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "runtimeUrls":
			err = unpopulate(val, "RuntimeUrls", &a.RuntimeUrls)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2AcknowledgementConnectionSettings.
func (a AS2AcknowledgementConnectionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ignoreCertificateNameMismatch", a.IgnoreCertificateNameMismatch)
	populate(objectMap, "keepHttpConnectionAlive", a.KeepHTTPConnectionAlive)
	populate(objectMap, "supportHttpStatusCodeContinue", a.SupportHTTPStatusCodeContinue)
	populate(objectMap, "unfoldHttpHeaders", a.UnfoldHTTPHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2AcknowledgementConnectionSettings.
func (a *AS2AcknowledgementConnectionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ignoreCertificateNameMismatch":
			err = unpopulate(val, "IgnoreCertificateNameMismatch", &a.IgnoreCertificateNameMismatch)
			delete(rawMsg, key)
		case "keepHttpConnectionAlive":
			err = unpopulate(val, "KeepHTTPConnectionAlive", &a.KeepHTTPConnectionAlive)
			delete(rawMsg, key)
		case "supportHttpStatusCodeContinue":
			err = unpopulate(val, "SupportHTTPStatusCodeContinue", &a.SupportHTTPStatusCodeContinue)
			delete(rawMsg, key)
		case "unfoldHttpHeaders":
			err = unpopulate(val, "UnfoldHTTPHeaders", &a.UnfoldHTTPHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2AgreementContent.
func (a AS2AgreementContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "receiveAgreement", a.ReceiveAgreement)
	populate(objectMap, "sendAgreement", a.SendAgreement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2AgreementContent.
func (a *AS2AgreementContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "receiveAgreement":
			err = unpopulate(val, "ReceiveAgreement", &a.ReceiveAgreement)
			delete(rawMsg, key)
		case "sendAgreement":
			err = unpopulate(val, "SendAgreement", &a.SendAgreement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2EnvelopeSettings.
func (a AS2EnvelopeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autogenerateFileName", a.AutogenerateFileName)
	populate(objectMap, "fileNameTemplate", a.FileNameTemplate)
	populate(objectMap, "messageContentType", a.MessageContentType)
	populate(objectMap, "suspendMessageOnFileNameGenerationError", a.SuspendMessageOnFileNameGenerationError)
	populate(objectMap, "transmitFileNameInMimeHeader", a.TransmitFileNameInMimeHeader)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2EnvelopeSettings.
func (a *AS2EnvelopeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autogenerateFileName":
			err = unpopulate(val, "AutogenerateFileName", &a.AutogenerateFileName)
			delete(rawMsg, key)
		case "fileNameTemplate":
			err = unpopulate(val, "FileNameTemplate", &a.FileNameTemplate)
			delete(rawMsg, key)
		case "messageContentType":
			err = unpopulate(val, "MessageContentType", &a.MessageContentType)
			delete(rawMsg, key)
		case "suspendMessageOnFileNameGenerationError":
			err = unpopulate(val, "SuspendMessageOnFileNameGenerationError", &a.SuspendMessageOnFileNameGenerationError)
			delete(rawMsg, key)
		case "transmitFileNameInMimeHeader":
			err = unpopulate(val, "TransmitFileNameInMimeHeader", &a.TransmitFileNameInMimeHeader)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2ErrorSettings.
func (a AS2ErrorSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resendIfMDNNotReceived", a.ResendIfMDNNotReceived)
	populate(objectMap, "suspendDuplicateMessage", a.SuspendDuplicateMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2ErrorSettings.
func (a *AS2ErrorSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resendIfMDNNotReceived":
			err = unpopulate(val, "ResendIfMDNNotReceived", &a.ResendIfMDNNotReceived)
			delete(rawMsg, key)
		case "suspendDuplicateMessage":
			err = unpopulate(val, "SuspendDuplicateMessage", &a.SuspendDuplicateMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2MdnSettings.
func (a AS2MdnSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dispositionNotificationTo", a.DispositionNotificationTo)
	populate(objectMap, "mdnText", a.MdnText)
	populate(objectMap, "micHashingAlgorithm", a.MicHashingAlgorithm)
	populate(objectMap, "needMDN", a.NeedMDN)
	populate(objectMap, "receiptDeliveryUrl", a.ReceiptDeliveryURL)
	populate(objectMap, "sendInboundMDNToMessageBox", a.SendInboundMDNToMessageBox)
	populate(objectMap, "sendMDNAsynchronously", a.SendMDNAsynchronously)
	populate(objectMap, "signMDN", a.SignMDN)
	populate(objectMap, "signOutboundMDNIfOptional", a.SignOutboundMDNIfOptional)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2MdnSettings.
func (a *AS2MdnSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dispositionNotificationTo":
			err = unpopulate(val, "DispositionNotificationTo", &a.DispositionNotificationTo)
			delete(rawMsg, key)
		case "mdnText":
			err = unpopulate(val, "MdnText", &a.MdnText)
			delete(rawMsg, key)
		case "micHashingAlgorithm":
			err = unpopulate(val, "MicHashingAlgorithm", &a.MicHashingAlgorithm)
			delete(rawMsg, key)
		case "needMDN":
			err = unpopulate(val, "NeedMDN", &a.NeedMDN)
			delete(rawMsg, key)
		case "receiptDeliveryUrl":
			err = unpopulate(val, "ReceiptDeliveryURL", &a.ReceiptDeliveryURL)
			delete(rawMsg, key)
		case "sendInboundMDNToMessageBox":
			err = unpopulate(val, "SendInboundMDNToMessageBox", &a.SendInboundMDNToMessageBox)
			delete(rawMsg, key)
		case "sendMDNAsynchronously":
			err = unpopulate(val, "SendMDNAsynchronously", &a.SendMDNAsynchronously)
			delete(rawMsg, key)
		case "signMDN":
			err = unpopulate(val, "SignMDN", &a.SignMDN)
			delete(rawMsg, key)
		case "signOutboundMDNIfOptional":
			err = unpopulate(val, "SignOutboundMDNIfOptional", &a.SignOutboundMDNIfOptional)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2MessageConnectionSettings.
func (a AS2MessageConnectionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ignoreCertificateNameMismatch", a.IgnoreCertificateNameMismatch)
	populate(objectMap, "keepHttpConnectionAlive", a.KeepHTTPConnectionAlive)
	populate(objectMap, "supportHttpStatusCodeContinue", a.SupportHTTPStatusCodeContinue)
	populate(objectMap, "unfoldHttpHeaders", a.UnfoldHTTPHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2MessageConnectionSettings.
func (a *AS2MessageConnectionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ignoreCertificateNameMismatch":
			err = unpopulate(val, "IgnoreCertificateNameMismatch", &a.IgnoreCertificateNameMismatch)
			delete(rawMsg, key)
		case "keepHttpConnectionAlive":
			err = unpopulate(val, "KeepHTTPConnectionAlive", &a.KeepHTTPConnectionAlive)
			delete(rawMsg, key)
		case "supportHttpStatusCodeContinue":
			err = unpopulate(val, "SupportHTTPStatusCodeContinue", &a.SupportHTTPStatusCodeContinue)
			delete(rawMsg, key)
		case "unfoldHttpHeaders":
			err = unpopulate(val, "UnfoldHTTPHeaders", &a.UnfoldHTTPHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2OneWayAgreement.
func (a AS2OneWayAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protocolSettings", a.ProtocolSettings)
	populate(objectMap, "receiverBusinessIdentity", a.ReceiverBusinessIdentity)
	populate(objectMap, "senderBusinessIdentity", a.SenderBusinessIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2OneWayAgreement.
func (a *AS2OneWayAgreement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protocolSettings":
			err = unpopulate(val, "ProtocolSettings", &a.ProtocolSettings)
			delete(rawMsg, key)
		case "receiverBusinessIdentity":
			err = unpopulate(val, "ReceiverBusinessIdentity", &a.ReceiverBusinessIdentity)
			delete(rawMsg, key)
		case "senderBusinessIdentity":
			err = unpopulate(val, "SenderBusinessIdentity", &a.SenderBusinessIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2ProtocolSettings.
func (a AS2ProtocolSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acknowledgementConnectionSettings", a.AcknowledgementConnectionSettings)
	populate(objectMap, "envelopeSettings", a.EnvelopeSettings)
	populate(objectMap, "errorSettings", a.ErrorSettings)
	populate(objectMap, "mdnSettings", a.MdnSettings)
	populate(objectMap, "messageConnectionSettings", a.MessageConnectionSettings)
	populate(objectMap, "securitySettings", a.SecuritySettings)
	populate(objectMap, "validationSettings", a.ValidationSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2ProtocolSettings.
func (a *AS2ProtocolSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acknowledgementConnectionSettings":
			err = unpopulate(val, "AcknowledgementConnectionSettings", &a.AcknowledgementConnectionSettings)
			delete(rawMsg, key)
		case "envelopeSettings":
			err = unpopulate(val, "EnvelopeSettings", &a.EnvelopeSettings)
			delete(rawMsg, key)
		case "errorSettings":
			err = unpopulate(val, "ErrorSettings", &a.ErrorSettings)
			delete(rawMsg, key)
		case "mdnSettings":
			err = unpopulate(val, "MdnSettings", &a.MdnSettings)
			delete(rawMsg, key)
		case "messageConnectionSettings":
			err = unpopulate(val, "MessageConnectionSettings", &a.MessageConnectionSettings)
			delete(rawMsg, key)
		case "securitySettings":
			err = unpopulate(val, "SecuritySettings", &a.SecuritySettings)
			delete(rawMsg, key)
		case "validationSettings":
			err = unpopulate(val, "ValidationSettings", &a.ValidationSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2SecuritySettings.
func (a AS2SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableNRRForInboundDecodedMessages", a.EnableNRRForInboundDecodedMessages)
	populate(objectMap, "enableNRRForInboundEncodedMessages", a.EnableNRRForInboundEncodedMessages)
	populate(objectMap, "enableNRRForInboundMDN", a.EnableNRRForInboundMDN)
	populate(objectMap, "enableNRRForOutboundDecodedMessages", a.EnableNRRForOutboundDecodedMessages)
	populate(objectMap, "enableNRRForOutboundEncodedMessages", a.EnableNRRForOutboundEncodedMessages)
	populate(objectMap, "enableNRRForOutboundMDN", a.EnableNRRForOutboundMDN)
	populate(objectMap, "encryptionCertificateName", a.EncryptionCertificateName)
	populate(objectMap, "overrideGroupSigningCertificate", a.OverrideGroupSigningCertificate)
	populate(objectMap, "sha2AlgorithmFormat", a.SHA2AlgorithmFormat)
	populate(objectMap, "signingCertificateName", a.SigningCertificateName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2SecuritySettings.
func (a *AS2SecuritySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableNRRForInboundDecodedMessages":
			err = unpopulate(val, "EnableNRRForInboundDecodedMessages", &a.EnableNRRForInboundDecodedMessages)
			delete(rawMsg, key)
		case "enableNRRForInboundEncodedMessages":
			err = unpopulate(val, "EnableNRRForInboundEncodedMessages", &a.EnableNRRForInboundEncodedMessages)
			delete(rawMsg, key)
		case "enableNRRForInboundMDN":
			err = unpopulate(val, "EnableNRRForInboundMDN", &a.EnableNRRForInboundMDN)
			delete(rawMsg, key)
		case "enableNRRForOutboundDecodedMessages":
			err = unpopulate(val, "EnableNRRForOutboundDecodedMessages", &a.EnableNRRForOutboundDecodedMessages)
			delete(rawMsg, key)
		case "enableNRRForOutboundEncodedMessages":
			err = unpopulate(val, "EnableNRRForOutboundEncodedMessages", &a.EnableNRRForOutboundEncodedMessages)
			delete(rawMsg, key)
		case "enableNRRForOutboundMDN":
			err = unpopulate(val, "EnableNRRForOutboundMDN", &a.EnableNRRForOutboundMDN)
			delete(rawMsg, key)
		case "encryptionCertificateName":
			err = unpopulate(val, "EncryptionCertificateName", &a.EncryptionCertificateName)
			delete(rawMsg, key)
		case "overrideGroupSigningCertificate":
			err = unpopulate(val, "OverrideGroupSigningCertificate", &a.OverrideGroupSigningCertificate)
			delete(rawMsg, key)
		case "sha2AlgorithmFormat":
			err = unpopulate(val, "SHA2AlgorithmFormat", &a.SHA2AlgorithmFormat)
			delete(rawMsg, key)
		case "signingCertificateName":
			err = unpopulate(val, "SigningCertificateName", &a.SigningCertificateName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AS2ValidationSettings.
func (a AS2ValidationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "checkCertificateRevocationListOnReceive", a.CheckCertificateRevocationListOnReceive)
	populate(objectMap, "checkCertificateRevocationListOnSend", a.CheckCertificateRevocationListOnSend)
	populate(objectMap, "checkDuplicateMessage", a.CheckDuplicateMessage)
	populate(objectMap, "compressMessage", a.CompressMessage)
	populate(objectMap, "encryptMessage", a.EncryptMessage)
	populate(objectMap, "encryptionAlgorithm", a.EncryptionAlgorithm)
	populate(objectMap, "interchangeDuplicatesValidityDays", a.InterchangeDuplicatesValidityDays)
	populate(objectMap, "overrideMessageProperties", a.OverrideMessageProperties)
	populate(objectMap, "signMessage", a.SignMessage)
	populate(objectMap, "signingAlgorithm", a.SigningAlgorithm)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AS2ValidationSettings.
func (a *AS2ValidationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "checkCertificateRevocationListOnReceive":
			err = unpopulate(val, "CheckCertificateRevocationListOnReceive", &a.CheckCertificateRevocationListOnReceive)
			delete(rawMsg, key)
		case "checkCertificateRevocationListOnSend":
			err = unpopulate(val, "CheckCertificateRevocationListOnSend", &a.CheckCertificateRevocationListOnSend)
			delete(rawMsg, key)
		case "checkDuplicateMessage":
			err = unpopulate(val, "CheckDuplicateMessage", &a.CheckDuplicateMessage)
			delete(rawMsg, key)
		case "compressMessage":
			err = unpopulate(val, "CompressMessage", &a.CompressMessage)
			delete(rawMsg, key)
		case "encryptMessage":
			err = unpopulate(val, "EncryptMessage", &a.EncryptMessage)
			delete(rawMsg, key)
		case "encryptionAlgorithm":
			err = unpopulate(val, "EncryptionAlgorithm", &a.EncryptionAlgorithm)
			delete(rawMsg, key)
		case "interchangeDuplicatesValidityDays":
			err = unpopulate(val, "InterchangeDuplicatesValidityDays", &a.InterchangeDuplicatesValidityDays)
			delete(rawMsg, key)
		case "overrideMessageProperties":
			err = unpopulate(val, "OverrideMessageProperties", &a.OverrideMessageProperties)
			delete(rawMsg, key)
		case "signMessage":
			err = unpopulate(val, "SignMessage", &a.SignMessage)
			delete(rawMsg, key)
		case "signingAlgorithm":
			err = unpopulate(val, "SigningAlgorithm", &a.SigningAlgorithm)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgreementContent.
func (a AgreementContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aS2", a.AS2)
	populate(objectMap, "edifact", a.Edifact)
	populate(objectMap, "x12", a.X12)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgreementContent.
func (a *AgreementContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aS2":
			err = unpopulate(val, "AS2", &a.AS2)
			delete(rawMsg, key)
		case "edifact":
			err = unpopulate(val, "Edifact", &a.Edifact)
			delete(rawMsg, key)
		case "x12":
			err = unpopulate(val, "X12", &a.X12)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactContentPropertiesDefinition.
func (a ArtifactContentPropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", a.ChangedTime)
	populateAny(objectMap, "content", a.Content)
	populate(objectMap, "contentLink", a.ContentLink)
	populate(objectMap, "contentType", a.ContentType)
	populateDateTimeRFC3339(objectMap, "createdTime", a.CreatedTime)
	populateAny(objectMap, "metadata", a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactContentPropertiesDefinition.
func (a *ArtifactContentPropertiesDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &a.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &a.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &a.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &a.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactProperties.
func (a ArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", a.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", a.CreatedTime)
	populateAny(objectMap, "metadata", a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactProperties.
func (a *ArtifactProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &a.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &a.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssemblyCollection.
func (a AssemblyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssemblyCollection.
func (a *AssemblyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssemblyDefinition.
func (a AssemblyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssemblyDefinition.
func (a *AssemblyDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssemblyProperties.
func (a AssemblyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assemblyCulture", a.AssemblyCulture)
	populate(objectMap, "assemblyName", a.AssemblyName)
	populate(objectMap, "assemblyPublicKeyToken", a.AssemblyPublicKeyToken)
	populate(objectMap, "assemblyVersion", a.AssemblyVersion)
	populateDateTimeRFC3339(objectMap, "changedTime", a.ChangedTime)
	populateAny(objectMap, "content", a.Content)
	populate(objectMap, "contentLink", a.ContentLink)
	populate(objectMap, "contentType", a.ContentType)
	populateDateTimeRFC3339(objectMap, "createdTime", a.CreatedTime)
	populateAny(objectMap, "metadata", a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssemblyProperties.
func (a *AssemblyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assemblyCulture":
			err = unpopulate(val, "AssemblyCulture", &a.AssemblyCulture)
			delete(rawMsg, key)
		case "assemblyName":
			err = unpopulate(val, "AssemblyName", &a.AssemblyName)
			delete(rawMsg, key)
		case "assemblyPublicKeyToken":
			err = unpopulate(val, "AssemblyPublicKeyToken", &a.AssemblyPublicKeyToken)
			delete(rawMsg, key)
		case "assemblyVersion":
			err = unpopulate(val, "AssemblyVersion", &a.AssemblyVersion)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &a.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &a.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &a.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &a.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceErrorInfo.
func (a AzureResourceErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceErrorInfo.
func (a *AzureResourceErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type B2BPartnerContent.
func (b B2BPartnerContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "businessIdentities", b.BusinessIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type B2BPartnerContent.
func (b *B2BPartnerContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "businessIdentities":
			err = unpopulate(val, "BusinessIdentities", &b.BusinessIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchConfiguration.
func (b BatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchConfiguration.
func (b *BatchConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchConfigurationCollection.
func (b BatchConfigurationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchConfigurationCollection.
func (b *BatchConfigurationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchConfigurationProperties.
func (b BatchConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "batchGroupName", b.BatchGroupName)
	populateDateTimeRFC3339(objectMap, "changedTime", b.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", b.CreatedTime)
	populateAny(objectMap, "metadata", b.Metadata)
	populate(objectMap, "releaseCriteria", b.ReleaseCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchConfigurationProperties.
func (b *BatchConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "batchGroupName":
			err = unpopulate(val, "BatchGroupName", &b.BatchGroupName)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &b.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &b.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &b.Metadata)
			delete(rawMsg, key)
		case "releaseCriteria":
			err = unpopulate(val, "ReleaseCriteria", &b.ReleaseCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchReleaseCriteria.
func (b BatchReleaseCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "batchSize", b.BatchSize)
	populate(objectMap, "messageCount", b.MessageCount)
	populate(objectMap, "recurrence", b.Recurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchReleaseCriteria.
func (b *BatchReleaseCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "batchSize":
			err = unpopulate(val, "BatchSize", &b.BatchSize)
			delete(rawMsg, key)
		case "messageCount":
			err = unpopulate(val, "MessageCount", &b.MessageCount)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &b.Recurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BusinessIdentity.
func (b BusinessIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "qualifier", b.Qualifier)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BusinessIdentity.
func (b *BusinessIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "qualifier":
			err = unpopulate(val, "Qualifier", &b.Qualifier)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CallbackURL.
func (c CallbackURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CallbackURL.
func (c *CallbackURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentHash.
func (c ContentHash) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "algorithm", c.Algorithm)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentHash.
func (c *ContentHash) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "algorithm":
			err = unpopulate(val, "Algorithm", &c.Algorithm)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentLink.
func (c ContentLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentHash", c.ContentHash)
	populate(objectMap, "contentSize", c.ContentSize)
	populate(objectMap, "contentVersion", c.ContentVersion)
	populateAny(objectMap, "metadata", c.Metadata)
	populate(objectMap, "uri", c.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentLink.
func (c *ContentLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentHash":
			err = unpopulate(val, "ContentHash", &c.ContentHash)
			delete(rawMsg, key)
		case "contentSize":
			err = unpopulate(val, "ContentSize", &c.ContentSize)
			delete(rawMsg, key)
		case "contentVersion":
			err = unpopulate(val, "ContentVersion", &c.ContentVersion)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &c.Metadata)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &c.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Correlation.
func (c Correlation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientTrackingId", c.ClientTrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Correlation.
func (c *Correlation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientTrackingId":
			err = unpopulate(val, "ClientTrackingID", &c.ClientTrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactAcknowledgementSettings.
func (e EdifactAcknowledgementSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acknowledgementControlNumberLowerBound", e.AcknowledgementControlNumberLowerBound)
	populate(objectMap, "acknowledgementControlNumberPrefix", e.AcknowledgementControlNumberPrefix)
	populate(objectMap, "acknowledgementControlNumberSuffix", e.AcknowledgementControlNumberSuffix)
	populate(objectMap, "acknowledgementControlNumberUpperBound", e.AcknowledgementControlNumberUpperBound)
	populate(objectMap, "batchFunctionalAcknowledgements", e.BatchFunctionalAcknowledgements)
	populate(objectMap, "batchTechnicalAcknowledgements", e.BatchTechnicalAcknowledgements)
	populate(objectMap, "needFunctionalAcknowledgement", e.NeedFunctionalAcknowledgement)
	populate(objectMap, "needLoopForValidMessages", e.NeedLoopForValidMessages)
	populate(objectMap, "needTechnicalAcknowledgement", e.NeedTechnicalAcknowledgement)
	populate(objectMap, "rolloverAcknowledgementControlNumber", e.RolloverAcknowledgementControlNumber)
	populate(objectMap, "sendSynchronousAcknowledgement", e.SendSynchronousAcknowledgement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactAcknowledgementSettings.
func (e *EdifactAcknowledgementSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acknowledgementControlNumberLowerBound":
			err = unpopulate(val, "AcknowledgementControlNumberLowerBound", &e.AcknowledgementControlNumberLowerBound)
			delete(rawMsg, key)
		case "acknowledgementControlNumberPrefix":
			err = unpopulate(val, "AcknowledgementControlNumberPrefix", &e.AcknowledgementControlNumberPrefix)
			delete(rawMsg, key)
		case "acknowledgementControlNumberSuffix":
			err = unpopulate(val, "AcknowledgementControlNumberSuffix", &e.AcknowledgementControlNumberSuffix)
			delete(rawMsg, key)
		case "acknowledgementControlNumberUpperBound":
			err = unpopulate(val, "AcknowledgementControlNumberUpperBound", &e.AcknowledgementControlNumberUpperBound)
			delete(rawMsg, key)
		case "batchFunctionalAcknowledgements":
			err = unpopulate(val, "BatchFunctionalAcknowledgements", &e.BatchFunctionalAcknowledgements)
			delete(rawMsg, key)
		case "batchTechnicalAcknowledgements":
			err = unpopulate(val, "BatchTechnicalAcknowledgements", &e.BatchTechnicalAcknowledgements)
			delete(rawMsg, key)
		case "needFunctionalAcknowledgement":
			err = unpopulate(val, "NeedFunctionalAcknowledgement", &e.NeedFunctionalAcknowledgement)
			delete(rawMsg, key)
		case "needLoopForValidMessages":
			err = unpopulate(val, "NeedLoopForValidMessages", &e.NeedLoopForValidMessages)
			delete(rawMsg, key)
		case "needTechnicalAcknowledgement":
			err = unpopulate(val, "NeedTechnicalAcknowledgement", &e.NeedTechnicalAcknowledgement)
			delete(rawMsg, key)
		case "rolloverAcknowledgementControlNumber":
			err = unpopulate(val, "RolloverAcknowledgementControlNumber", &e.RolloverAcknowledgementControlNumber)
			delete(rawMsg, key)
		case "sendSynchronousAcknowledgement":
			err = unpopulate(val, "SendSynchronousAcknowledgement", &e.SendSynchronousAcknowledgement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactAgreementContent.
func (e EdifactAgreementContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "receiveAgreement", e.ReceiveAgreement)
	populate(objectMap, "sendAgreement", e.SendAgreement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactAgreementContent.
func (e *EdifactAgreementContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "receiveAgreement":
			err = unpopulate(val, "ReceiveAgreement", &e.ReceiveAgreement)
			delete(rawMsg, key)
		case "sendAgreement":
			err = unpopulate(val, "SendAgreement", &e.SendAgreement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactDelimiterOverride.
func (e EdifactDelimiterOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentSeparator", e.ComponentSeparator)
	populate(objectMap, "dataElementSeparator", e.DataElementSeparator)
	populate(objectMap, "decimalPointIndicator", e.DecimalPointIndicator)
	populate(objectMap, "messageAssociationAssignedCode", e.MessageAssociationAssignedCode)
	populate(objectMap, "messageId", e.MessageID)
	populate(objectMap, "messageRelease", e.MessageRelease)
	populate(objectMap, "messageVersion", e.MessageVersion)
	populate(objectMap, "releaseIndicator", e.ReleaseIndicator)
	populate(objectMap, "repetitionSeparator", e.RepetitionSeparator)
	populate(objectMap, "segmentTerminator", e.SegmentTerminator)
	populate(objectMap, "segmentTerminatorSuffix", e.SegmentTerminatorSuffix)
	populate(objectMap, "targetNamespace", e.TargetNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactDelimiterOverride.
func (e *EdifactDelimiterOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentSeparator":
			err = unpopulate(val, "ComponentSeparator", &e.ComponentSeparator)
			delete(rawMsg, key)
		case "dataElementSeparator":
			err = unpopulate(val, "DataElementSeparator", &e.DataElementSeparator)
			delete(rawMsg, key)
		case "decimalPointIndicator":
			err = unpopulate(val, "DecimalPointIndicator", &e.DecimalPointIndicator)
			delete(rawMsg, key)
		case "messageAssociationAssignedCode":
			err = unpopulate(val, "MessageAssociationAssignedCode", &e.MessageAssociationAssignedCode)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &e.MessageID)
			delete(rawMsg, key)
		case "messageRelease":
			err = unpopulate(val, "MessageRelease", &e.MessageRelease)
			delete(rawMsg, key)
		case "messageVersion":
			err = unpopulate(val, "MessageVersion", &e.MessageVersion)
			delete(rawMsg, key)
		case "releaseIndicator":
			err = unpopulate(val, "ReleaseIndicator", &e.ReleaseIndicator)
			delete(rawMsg, key)
		case "repetitionSeparator":
			err = unpopulate(val, "RepetitionSeparator", &e.RepetitionSeparator)
			delete(rawMsg, key)
		case "segmentTerminator":
			err = unpopulate(val, "SegmentTerminator", &e.SegmentTerminator)
			delete(rawMsg, key)
		case "segmentTerminatorSuffix":
			err = unpopulate(val, "SegmentTerminatorSuffix", &e.SegmentTerminatorSuffix)
			delete(rawMsg, key)
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &e.TargetNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactEnvelopeOverride.
func (e EdifactEnvelopeOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationPassword", e.ApplicationPassword)
	populate(objectMap, "associationAssignedCode", e.AssociationAssignedCode)
	populate(objectMap, "controllingAgencyCode", e.ControllingAgencyCode)
	populate(objectMap, "functionalGroupId", e.FunctionalGroupID)
	populate(objectMap, "groupHeaderMessageRelease", e.GroupHeaderMessageRelease)
	populate(objectMap, "groupHeaderMessageVersion", e.GroupHeaderMessageVersion)
	populate(objectMap, "messageAssociationAssignedCode", e.MessageAssociationAssignedCode)
	populate(objectMap, "messageId", e.MessageID)
	populate(objectMap, "messageRelease", e.MessageRelease)
	populate(objectMap, "messageVersion", e.MessageVersion)
	populate(objectMap, "receiverApplicationId", e.ReceiverApplicationID)
	populate(objectMap, "receiverApplicationQualifier", e.ReceiverApplicationQualifier)
	populate(objectMap, "senderApplicationId", e.SenderApplicationID)
	populate(objectMap, "senderApplicationQualifier", e.SenderApplicationQualifier)
	populate(objectMap, "targetNamespace", e.TargetNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactEnvelopeOverride.
func (e *EdifactEnvelopeOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationPassword":
			err = unpopulate(val, "ApplicationPassword", &e.ApplicationPassword)
			delete(rawMsg, key)
		case "associationAssignedCode":
			err = unpopulate(val, "AssociationAssignedCode", &e.AssociationAssignedCode)
			delete(rawMsg, key)
		case "controllingAgencyCode":
			err = unpopulate(val, "ControllingAgencyCode", &e.ControllingAgencyCode)
			delete(rawMsg, key)
		case "functionalGroupId":
			err = unpopulate(val, "FunctionalGroupID", &e.FunctionalGroupID)
			delete(rawMsg, key)
		case "groupHeaderMessageRelease":
			err = unpopulate(val, "GroupHeaderMessageRelease", &e.GroupHeaderMessageRelease)
			delete(rawMsg, key)
		case "groupHeaderMessageVersion":
			err = unpopulate(val, "GroupHeaderMessageVersion", &e.GroupHeaderMessageVersion)
			delete(rawMsg, key)
		case "messageAssociationAssignedCode":
			err = unpopulate(val, "MessageAssociationAssignedCode", &e.MessageAssociationAssignedCode)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &e.MessageID)
			delete(rawMsg, key)
		case "messageRelease":
			err = unpopulate(val, "MessageRelease", &e.MessageRelease)
			delete(rawMsg, key)
		case "messageVersion":
			err = unpopulate(val, "MessageVersion", &e.MessageVersion)
			delete(rawMsg, key)
		case "receiverApplicationId":
			err = unpopulate(val, "ReceiverApplicationID", &e.ReceiverApplicationID)
			delete(rawMsg, key)
		case "receiverApplicationQualifier":
			err = unpopulate(val, "ReceiverApplicationQualifier", &e.ReceiverApplicationQualifier)
			delete(rawMsg, key)
		case "senderApplicationId":
			err = unpopulate(val, "SenderApplicationID", &e.SenderApplicationID)
			delete(rawMsg, key)
		case "senderApplicationQualifier":
			err = unpopulate(val, "SenderApplicationQualifier", &e.SenderApplicationQualifier)
			delete(rawMsg, key)
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &e.TargetNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactEnvelopeSettings.
func (e EdifactEnvelopeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationReferenceId", e.ApplicationReferenceID)
	populate(objectMap, "applyDelimiterStringAdvice", e.ApplyDelimiterStringAdvice)
	populate(objectMap, "communicationAgreementId", e.CommunicationAgreementID)
	populate(objectMap, "createGroupingSegments", e.CreateGroupingSegments)
	populate(objectMap, "enableDefaultGroupHeaders", e.EnableDefaultGroupHeaders)
	populate(objectMap, "functionalGroupId", e.FunctionalGroupID)
	populate(objectMap, "groupApplicationPassword", e.GroupApplicationPassword)
	populate(objectMap, "groupApplicationReceiverId", e.GroupApplicationReceiverID)
	populate(objectMap, "groupApplicationReceiverQualifier", e.GroupApplicationReceiverQualifier)
	populate(objectMap, "groupApplicationSenderId", e.GroupApplicationSenderID)
	populate(objectMap, "groupApplicationSenderQualifier", e.GroupApplicationSenderQualifier)
	populate(objectMap, "groupAssociationAssignedCode", e.GroupAssociationAssignedCode)
	populate(objectMap, "groupControlNumberLowerBound", e.GroupControlNumberLowerBound)
	populate(objectMap, "groupControlNumberPrefix", e.GroupControlNumberPrefix)
	populate(objectMap, "groupControlNumberSuffix", e.GroupControlNumberSuffix)
	populate(objectMap, "groupControlNumberUpperBound", e.GroupControlNumberUpperBound)
	populate(objectMap, "groupControllingAgencyCode", e.GroupControllingAgencyCode)
	populate(objectMap, "groupMessageRelease", e.GroupMessageRelease)
	populate(objectMap, "groupMessageVersion", e.GroupMessageVersion)
	populate(objectMap, "interchangeControlNumberLowerBound", e.InterchangeControlNumberLowerBound)
	populate(objectMap, "interchangeControlNumberPrefix", e.InterchangeControlNumberPrefix)
	populate(objectMap, "interchangeControlNumberSuffix", e.InterchangeControlNumberSuffix)
	populate(objectMap, "interchangeControlNumberUpperBound", e.InterchangeControlNumberUpperBound)
	populate(objectMap, "isTestInterchange", e.IsTestInterchange)
	populate(objectMap, "overwriteExistingTransactionSetControlNumber", e.OverwriteExistingTransactionSetControlNumber)
	populate(objectMap, "processingPriorityCode", e.ProcessingPriorityCode)
	populate(objectMap, "receiverInternalIdentification", e.ReceiverInternalIdentification)
	populate(objectMap, "receiverInternalSubIdentification", e.ReceiverInternalSubIdentification)
	populate(objectMap, "receiverReverseRoutingAddress", e.ReceiverReverseRoutingAddress)
	populate(objectMap, "recipientReferencePasswordQualifier", e.RecipientReferencePasswordQualifier)
	populate(objectMap, "recipientReferencePasswordValue", e.RecipientReferencePasswordValue)
	populate(objectMap, "rolloverGroupControlNumber", e.RolloverGroupControlNumber)
	populate(objectMap, "rolloverInterchangeControlNumber", e.RolloverInterchangeControlNumber)
	populate(objectMap, "rolloverTransactionSetControlNumber", e.RolloverTransactionSetControlNumber)
	populate(objectMap, "senderInternalIdentification", e.SenderInternalIdentification)
	populate(objectMap, "senderInternalSubIdentification", e.SenderInternalSubIdentification)
	populate(objectMap, "senderReverseRoutingAddress", e.SenderReverseRoutingAddress)
	populate(objectMap, "transactionSetControlNumberLowerBound", e.TransactionSetControlNumberLowerBound)
	populate(objectMap, "transactionSetControlNumberPrefix", e.TransactionSetControlNumberPrefix)
	populate(objectMap, "transactionSetControlNumberSuffix", e.TransactionSetControlNumberSuffix)
	populate(objectMap, "transactionSetControlNumberUpperBound", e.TransactionSetControlNumberUpperBound)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactEnvelopeSettings.
func (e *EdifactEnvelopeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationReferenceId":
			err = unpopulate(val, "ApplicationReferenceID", &e.ApplicationReferenceID)
			delete(rawMsg, key)
		case "applyDelimiterStringAdvice":
			err = unpopulate(val, "ApplyDelimiterStringAdvice", &e.ApplyDelimiterStringAdvice)
			delete(rawMsg, key)
		case "communicationAgreementId":
			err = unpopulate(val, "CommunicationAgreementID", &e.CommunicationAgreementID)
			delete(rawMsg, key)
		case "createGroupingSegments":
			err = unpopulate(val, "CreateGroupingSegments", &e.CreateGroupingSegments)
			delete(rawMsg, key)
		case "enableDefaultGroupHeaders":
			err = unpopulate(val, "EnableDefaultGroupHeaders", &e.EnableDefaultGroupHeaders)
			delete(rawMsg, key)
		case "functionalGroupId":
			err = unpopulate(val, "FunctionalGroupID", &e.FunctionalGroupID)
			delete(rawMsg, key)
		case "groupApplicationPassword":
			err = unpopulate(val, "GroupApplicationPassword", &e.GroupApplicationPassword)
			delete(rawMsg, key)
		case "groupApplicationReceiverId":
			err = unpopulate(val, "GroupApplicationReceiverID", &e.GroupApplicationReceiverID)
			delete(rawMsg, key)
		case "groupApplicationReceiverQualifier":
			err = unpopulate(val, "GroupApplicationReceiverQualifier", &e.GroupApplicationReceiverQualifier)
			delete(rawMsg, key)
		case "groupApplicationSenderId":
			err = unpopulate(val, "GroupApplicationSenderID", &e.GroupApplicationSenderID)
			delete(rawMsg, key)
		case "groupApplicationSenderQualifier":
			err = unpopulate(val, "GroupApplicationSenderQualifier", &e.GroupApplicationSenderQualifier)
			delete(rawMsg, key)
		case "groupAssociationAssignedCode":
			err = unpopulate(val, "GroupAssociationAssignedCode", &e.GroupAssociationAssignedCode)
			delete(rawMsg, key)
		case "groupControlNumberLowerBound":
			err = unpopulate(val, "GroupControlNumberLowerBound", &e.GroupControlNumberLowerBound)
			delete(rawMsg, key)
		case "groupControlNumberPrefix":
			err = unpopulate(val, "GroupControlNumberPrefix", &e.GroupControlNumberPrefix)
			delete(rawMsg, key)
		case "groupControlNumberSuffix":
			err = unpopulate(val, "GroupControlNumberSuffix", &e.GroupControlNumberSuffix)
			delete(rawMsg, key)
		case "groupControlNumberUpperBound":
			err = unpopulate(val, "GroupControlNumberUpperBound", &e.GroupControlNumberUpperBound)
			delete(rawMsg, key)
		case "groupControllingAgencyCode":
			err = unpopulate(val, "GroupControllingAgencyCode", &e.GroupControllingAgencyCode)
			delete(rawMsg, key)
		case "groupMessageRelease":
			err = unpopulate(val, "GroupMessageRelease", &e.GroupMessageRelease)
			delete(rawMsg, key)
		case "groupMessageVersion":
			err = unpopulate(val, "GroupMessageVersion", &e.GroupMessageVersion)
			delete(rawMsg, key)
		case "interchangeControlNumberLowerBound":
			err = unpopulate(val, "InterchangeControlNumberLowerBound", &e.InterchangeControlNumberLowerBound)
			delete(rawMsg, key)
		case "interchangeControlNumberPrefix":
			err = unpopulate(val, "InterchangeControlNumberPrefix", &e.InterchangeControlNumberPrefix)
			delete(rawMsg, key)
		case "interchangeControlNumberSuffix":
			err = unpopulate(val, "InterchangeControlNumberSuffix", &e.InterchangeControlNumberSuffix)
			delete(rawMsg, key)
		case "interchangeControlNumberUpperBound":
			err = unpopulate(val, "InterchangeControlNumberUpperBound", &e.InterchangeControlNumberUpperBound)
			delete(rawMsg, key)
		case "isTestInterchange":
			err = unpopulate(val, "IsTestInterchange", &e.IsTestInterchange)
			delete(rawMsg, key)
		case "overwriteExistingTransactionSetControlNumber":
			err = unpopulate(val, "OverwriteExistingTransactionSetControlNumber", &e.OverwriteExistingTransactionSetControlNumber)
			delete(rawMsg, key)
		case "processingPriorityCode":
			err = unpopulate(val, "ProcessingPriorityCode", &e.ProcessingPriorityCode)
			delete(rawMsg, key)
		case "receiverInternalIdentification":
			err = unpopulate(val, "ReceiverInternalIdentification", &e.ReceiverInternalIdentification)
			delete(rawMsg, key)
		case "receiverInternalSubIdentification":
			err = unpopulate(val, "ReceiverInternalSubIdentification", &e.ReceiverInternalSubIdentification)
			delete(rawMsg, key)
		case "receiverReverseRoutingAddress":
			err = unpopulate(val, "ReceiverReverseRoutingAddress", &e.ReceiverReverseRoutingAddress)
			delete(rawMsg, key)
		case "recipientReferencePasswordQualifier":
			err = unpopulate(val, "RecipientReferencePasswordQualifier", &e.RecipientReferencePasswordQualifier)
			delete(rawMsg, key)
		case "recipientReferencePasswordValue":
			err = unpopulate(val, "RecipientReferencePasswordValue", &e.RecipientReferencePasswordValue)
			delete(rawMsg, key)
		case "rolloverGroupControlNumber":
			err = unpopulate(val, "RolloverGroupControlNumber", &e.RolloverGroupControlNumber)
			delete(rawMsg, key)
		case "rolloverInterchangeControlNumber":
			err = unpopulate(val, "RolloverInterchangeControlNumber", &e.RolloverInterchangeControlNumber)
			delete(rawMsg, key)
		case "rolloverTransactionSetControlNumber":
			err = unpopulate(val, "RolloverTransactionSetControlNumber", &e.RolloverTransactionSetControlNumber)
			delete(rawMsg, key)
		case "senderInternalIdentification":
			err = unpopulate(val, "SenderInternalIdentification", &e.SenderInternalIdentification)
			delete(rawMsg, key)
		case "senderInternalSubIdentification":
			err = unpopulate(val, "SenderInternalSubIdentification", &e.SenderInternalSubIdentification)
			delete(rawMsg, key)
		case "senderReverseRoutingAddress":
			err = unpopulate(val, "SenderReverseRoutingAddress", &e.SenderReverseRoutingAddress)
			delete(rawMsg, key)
		case "transactionSetControlNumberLowerBound":
			err = unpopulate(val, "TransactionSetControlNumberLowerBound", &e.TransactionSetControlNumberLowerBound)
			delete(rawMsg, key)
		case "transactionSetControlNumberPrefix":
			err = unpopulate(val, "TransactionSetControlNumberPrefix", &e.TransactionSetControlNumberPrefix)
			delete(rawMsg, key)
		case "transactionSetControlNumberSuffix":
			err = unpopulate(val, "TransactionSetControlNumberSuffix", &e.TransactionSetControlNumberSuffix)
			delete(rawMsg, key)
		case "transactionSetControlNumberUpperBound":
			err = unpopulate(val, "TransactionSetControlNumberUpperBound", &e.TransactionSetControlNumberUpperBound)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactFramingSettings.
func (e EdifactFramingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "characterEncoding", e.CharacterEncoding)
	populate(objectMap, "characterSet", e.CharacterSet)
	populate(objectMap, "componentSeparator", e.ComponentSeparator)
	populate(objectMap, "dataElementSeparator", e.DataElementSeparator)
	populate(objectMap, "decimalPointIndicator", e.DecimalPointIndicator)
	populate(objectMap, "protocolVersion", e.ProtocolVersion)
	populate(objectMap, "releaseIndicator", e.ReleaseIndicator)
	populate(objectMap, "repetitionSeparator", e.RepetitionSeparator)
	populate(objectMap, "segmentTerminator", e.SegmentTerminator)
	populate(objectMap, "segmentTerminatorSuffix", e.SegmentTerminatorSuffix)
	populate(objectMap, "serviceCodeListDirectoryVersion", e.ServiceCodeListDirectoryVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactFramingSettings.
func (e *EdifactFramingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "characterEncoding":
			err = unpopulate(val, "CharacterEncoding", &e.CharacterEncoding)
			delete(rawMsg, key)
		case "characterSet":
			err = unpopulate(val, "CharacterSet", &e.CharacterSet)
			delete(rawMsg, key)
		case "componentSeparator":
			err = unpopulate(val, "ComponentSeparator", &e.ComponentSeparator)
			delete(rawMsg, key)
		case "dataElementSeparator":
			err = unpopulate(val, "DataElementSeparator", &e.DataElementSeparator)
			delete(rawMsg, key)
		case "decimalPointIndicator":
			err = unpopulate(val, "DecimalPointIndicator", &e.DecimalPointIndicator)
			delete(rawMsg, key)
		case "protocolVersion":
			err = unpopulate(val, "ProtocolVersion", &e.ProtocolVersion)
			delete(rawMsg, key)
		case "releaseIndicator":
			err = unpopulate(val, "ReleaseIndicator", &e.ReleaseIndicator)
			delete(rawMsg, key)
		case "repetitionSeparator":
			err = unpopulate(val, "RepetitionSeparator", &e.RepetitionSeparator)
			delete(rawMsg, key)
		case "segmentTerminator":
			err = unpopulate(val, "SegmentTerminator", &e.SegmentTerminator)
			delete(rawMsg, key)
		case "segmentTerminatorSuffix":
			err = unpopulate(val, "SegmentTerminatorSuffix", &e.SegmentTerminatorSuffix)
			delete(rawMsg, key)
		case "serviceCodeListDirectoryVersion":
			err = unpopulate(val, "ServiceCodeListDirectoryVersion", &e.ServiceCodeListDirectoryVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactMessageFilter.
func (e EdifactMessageFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messageFilterType", e.MessageFilterType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactMessageFilter.
func (e *EdifactMessageFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messageFilterType":
			err = unpopulate(val, "MessageFilterType", &e.MessageFilterType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactMessageIdentifier.
func (e EdifactMessageIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messageId", e.MessageID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactMessageIdentifier.
func (e *EdifactMessageIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messageId":
			err = unpopulate(val, "MessageID", &e.MessageID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactOneWayAgreement.
func (e EdifactOneWayAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protocolSettings", e.ProtocolSettings)
	populate(objectMap, "receiverBusinessIdentity", e.ReceiverBusinessIdentity)
	populate(objectMap, "senderBusinessIdentity", e.SenderBusinessIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactOneWayAgreement.
func (e *EdifactOneWayAgreement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protocolSettings":
			err = unpopulate(val, "ProtocolSettings", &e.ProtocolSettings)
			delete(rawMsg, key)
		case "receiverBusinessIdentity":
			err = unpopulate(val, "ReceiverBusinessIdentity", &e.ReceiverBusinessIdentity)
			delete(rawMsg, key)
		case "senderBusinessIdentity":
			err = unpopulate(val, "SenderBusinessIdentity", &e.SenderBusinessIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactProcessingSettings.
func (e EdifactProcessingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createEmptyXmlTagsForTrailingSeparators", e.CreateEmptyXMLTagsForTrailingSeparators)
	populate(objectMap, "maskSecurityInfo", e.MaskSecurityInfo)
	populate(objectMap, "preserveInterchange", e.PreserveInterchange)
	populate(objectMap, "suspendInterchangeOnError", e.SuspendInterchangeOnError)
	populate(objectMap, "useDotAsDecimalSeparator", e.UseDotAsDecimalSeparator)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactProcessingSettings.
func (e *EdifactProcessingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createEmptyXmlTagsForTrailingSeparators":
			err = unpopulate(val, "CreateEmptyXMLTagsForTrailingSeparators", &e.CreateEmptyXMLTagsForTrailingSeparators)
			delete(rawMsg, key)
		case "maskSecurityInfo":
			err = unpopulate(val, "MaskSecurityInfo", &e.MaskSecurityInfo)
			delete(rawMsg, key)
		case "preserveInterchange":
			err = unpopulate(val, "PreserveInterchange", &e.PreserveInterchange)
			delete(rawMsg, key)
		case "suspendInterchangeOnError":
			err = unpopulate(val, "SuspendInterchangeOnError", &e.SuspendInterchangeOnError)
			delete(rawMsg, key)
		case "useDotAsDecimalSeparator":
			err = unpopulate(val, "UseDotAsDecimalSeparator", &e.UseDotAsDecimalSeparator)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactProtocolSettings.
func (e EdifactProtocolSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acknowledgementSettings", e.AcknowledgementSettings)
	populate(objectMap, "edifactDelimiterOverrides", e.EdifactDelimiterOverrides)
	populate(objectMap, "envelopeOverrides", e.EnvelopeOverrides)
	populate(objectMap, "envelopeSettings", e.EnvelopeSettings)
	populate(objectMap, "framingSettings", e.FramingSettings)
	populate(objectMap, "messageFilter", e.MessageFilter)
	populate(objectMap, "messageFilterList", e.MessageFilterList)
	populate(objectMap, "processingSettings", e.ProcessingSettings)
	populate(objectMap, "schemaReferences", e.SchemaReferences)
	populate(objectMap, "validationOverrides", e.ValidationOverrides)
	populate(objectMap, "validationSettings", e.ValidationSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactProtocolSettings.
func (e *EdifactProtocolSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acknowledgementSettings":
			err = unpopulate(val, "AcknowledgementSettings", &e.AcknowledgementSettings)
			delete(rawMsg, key)
		case "edifactDelimiterOverrides":
			err = unpopulate(val, "EdifactDelimiterOverrides", &e.EdifactDelimiterOverrides)
			delete(rawMsg, key)
		case "envelopeOverrides":
			err = unpopulate(val, "EnvelopeOverrides", &e.EnvelopeOverrides)
			delete(rawMsg, key)
		case "envelopeSettings":
			err = unpopulate(val, "EnvelopeSettings", &e.EnvelopeSettings)
			delete(rawMsg, key)
		case "framingSettings":
			err = unpopulate(val, "FramingSettings", &e.FramingSettings)
			delete(rawMsg, key)
		case "messageFilter":
			err = unpopulate(val, "MessageFilter", &e.MessageFilter)
			delete(rawMsg, key)
		case "messageFilterList":
			err = unpopulate(val, "MessageFilterList", &e.MessageFilterList)
			delete(rawMsg, key)
		case "processingSettings":
			err = unpopulate(val, "ProcessingSettings", &e.ProcessingSettings)
			delete(rawMsg, key)
		case "schemaReferences":
			err = unpopulate(val, "SchemaReferences", &e.SchemaReferences)
			delete(rawMsg, key)
		case "validationOverrides":
			err = unpopulate(val, "ValidationOverrides", &e.ValidationOverrides)
			delete(rawMsg, key)
		case "validationSettings":
			err = unpopulate(val, "ValidationSettings", &e.ValidationSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactSchemaReference.
func (e EdifactSchemaReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associationAssignedCode", e.AssociationAssignedCode)
	populate(objectMap, "messageId", e.MessageID)
	populate(objectMap, "messageRelease", e.MessageRelease)
	populate(objectMap, "messageVersion", e.MessageVersion)
	populate(objectMap, "schemaName", e.SchemaName)
	populate(objectMap, "senderApplicationId", e.SenderApplicationID)
	populate(objectMap, "senderApplicationQualifier", e.SenderApplicationQualifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactSchemaReference.
func (e *EdifactSchemaReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associationAssignedCode":
			err = unpopulate(val, "AssociationAssignedCode", &e.AssociationAssignedCode)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &e.MessageID)
			delete(rawMsg, key)
		case "messageRelease":
			err = unpopulate(val, "MessageRelease", &e.MessageRelease)
			delete(rawMsg, key)
		case "messageVersion":
			err = unpopulate(val, "MessageVersion", &e.MessageVersion)
			delete(rawMsg, key)
		case "schemaName":
			err = unpopulate(val, "SchemaName", &e.SchemaName)
			delete(rawMsg, key)
		case "senderApplicationId":
			err = unpopulate(val, "SenderApplicationID", &e.SenderApplicationID)
			delete(rawMsg, key)
		case "senderApplicationQualifier":
			err = unpopulate(val, "SenderApplicationQualifier", &e.SenderApplicationQualifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactValidationOverride.
func (e EdifactValidationOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowLeadingAndTrailingSpacesAndZeroes", e.AllowLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "enforceCharacterSet", e.EnforceCharacterSet)
	populate(objectMap, "messageId", e.MessageID)
	populate(objectMap, "trailingSeparatorPolicy", e.TrailingSeparatorPolicy)
	populate(objectMap, "trimLeadingAndTrailingSpacesAndZeroes", e.TrimLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "validateEDITypes", e.ValidateEDITypes)
	populate(objectMap, "validateXSDTypes", e.ValidateXSDTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactValidationOverride.
func (e *EdifactValidationOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "AllowLeadingAndTrailingSpacesAndZeroes", &e.AllowLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "enforceCharacterSet":
			err = unpopulate(val, "EnforceCharacterSet", &e.EnforceCharacterSet)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &e.MessageID)
			delete(rawMsg, key)
		case "trailingSeparatorPolicy":
			err = unpopulate(val, "TrailingSeparatorPolicy", &e.TrailingSeparatorPolicy)
			delete(rawMsg, key)
		case "trimLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "TrimLeadingAndTrailingSpacesAndZeroes", &e.TrimLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "validateEDITypes":
			err = unpopulate(val, "ValidateEDITypes", &e.ValidateEDITypes)
			delete(rawMsg, key)
		case "validateXSDTypes":
			err = unpopulate(val, "ValidateXSDTypes", &e.ValidateXSDTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactValidationSettings.
func (e EdifactValidationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowLeadingAndTrailingSpacesAndZeroes", e.AllowLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "checkDuplicateGroupControlNumber", e.CheckDuplicateGroupControlNumber)
	populate(objectMap, "checkDuplicateInterchangeControlNumber", e.CheckDuplicateInterchangeControlNumber)
	populate(objectMap, "checkDuplicateTransactionSetControlNumber", e.CheckDuplicateTransactionSetControlNumber)
	populate(objectMap, "interchangeControlNumberValidityDays", e.InterchangeControlNumberValidityDays)
	populate(objectMap, "trailingSeparatorPolicy", e.TrailingSeparatorPolicy)
	populate(objectMap, "trimLeadingAndTrailingSpacesAndZeroes", e.TrimLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "validateCharacterSet", e.ValidateCharacterSet)
	populate(objectMap, "validateEDITypes", e.ValidateEDITypes)
	populate(objectMap, "validateXSDTypes", e.ValidateXSDTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdifactValidationSettings.
func (e *EdifactValidationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "AllowLeadingAndTrailingSpacesAndZeroes", &e.AllowLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "checkDuplicateGroupControlNumber":
			err = unpopulate(val, "CheckDuplicateGroupControlNumber", &e.CheckDuplicateGroupControlNumber)
			delete(rawMsg, key)
		case "checkDuplicateInterchangeControlNumber":
			err = unpopulate(val, "CheckDuplicateInterchangeControlNumber", &e.CheckDuplicateInterchangeControlNumber)
			delete(rawMsg, key)
		case "checkDuplicateTransactionSetControlNumber":
			err = unpopulate(val, "CheckDuplicateTransactionSetControlNumber", &e.CheckDuplicateTransactionSetControlNumber)
			delete(rawMsg, key)
		case "interchangeControlNumberValidityDays":
			err = unpopulate(val, "InterchangeControlNumberValidityDays", &e.InterchangeControlNumberValidityDays)
			delete(rawMsg, key)
		case "trailingSeparatorPolicy":
			err = unpopulate(val, "TrailingSeparatorPolicy", &e.TrailingSeparatorPolicy)
			delete(rawMsg, key)
		case "trimLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "TrimLeadingAndTrailingSpacesAndZeroes", &e.TrimLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "validateCharacterSet":
			err = unpopulate(val, "ValidateCharacterSet", &e.ValidateCharacterSet)
			delete(rawMsg, key)
		case "validateEDITypes":
			err = unpopulate(val, "ValidateEDITypes", &e.ValidateEDITypes)
			delete(rawMsg, key)
		case "validateXSDTypes":
			err = unpopulate(val, "ValidateXSDTypes", &e.ValidateXSDTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorInfo.
func (e ErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorInfo.
func (e *ErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorProperties.
func (e ErrorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorProperties.
func (e *ErrorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Expression.
func (e Expression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "subexpressions", e.Subexpressions)
	populate(objectMap, "text", e.Text)
	populateAny(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Expression.
func (e *Expression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "subexpressions":
			err = unpopulate(val, "Subexpressions", &e.Subexpressions)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &e.Text)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressionRoot.
func (e ExpressionRoot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "path", e.Path)
	populate(objectMap, "subexpressions", e.Subexpressions)
	populate(objectMap, "text", e.Text)
	populateAny(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressionRoot.
func (e *ExpressionRoot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &e.Path)
			delete(rawMsg, key)
		case "subexpressions":
			err = unpopulate(val, "Subexpressions", &e.Subexpressions)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &e.Text)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressionTraces.
func (e ExpressionTraces) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inputs", e.Inputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressionTraces.
func (e *ExpressionTraces) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			err = unpopulate(val, "Inputs", &e.Inputs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedErrorInfo.
func (e ExtendedErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populateAny(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedErrorInfo.
func (e *ExtendedErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowAccessControlConfiguration.
func (f FlowAccessControlConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", f.Actions)
	populate(objectMap, "contents", f.Contents)
	populate(objectMap, "triggers", f.Triggers)
	populate(objectMap, "workflowManagement", f.WorkflowManagement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowAccessControlConfiguration.
func (f *FlowAccessControlConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &f.Actions)
			delete(rawMsg, key)
		case "contents":
			err = unpopulate(val, "Contents", &f.Contents)
			delete(rawMsg, key)
		case "triggers":
			err = unpopulate(val, "Triggers", &f.Triggers)
			delete(rawMsg, key)
		case "workflowManagement":
			err = unpopulate(val, "WorkflowManagement", &f.WorkflowManagement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowAccessControlConfigurationPolicy.
func (f FlowAccessControlConfigurationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedCallerIpAddresses", f.AllowedCallerIPAddresses)
	populate(objectMap, "openAuthenticationPolicies", f.OpenAuthenticationPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowAccessControlConfigurationPolicy.
func (f *FlowAccessControlConfigurationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedCallerIpAddresses":
			err = unpopulate(val, "AllowedCallerIPAddresses", &f.AllowedCallerIPAddresses)
			delete(rawMsg, key)
		case "openAuthenticationPolicies":
			err = unpopulate(val, "OpenAuthenticationPolicies", &f.OpenAuthenticationPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowEndpoints.
func (f FlowEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessEndpointIpAddresses", f.AccessEndpointIPAddresses)
	populate(objectMap, "outgoingIpAddresses", f.OutgoingIPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowEndpoints.
func (f *FlowEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessEndpointIpAddresses":
			err = unpopulate(val, "AccessEndpointIPAddresses", &f.AccessEndpointIPAddresses)
			delete(rawMsg, key)
		case "outgoingIpAddresses":
			err = unpopulate(val, "OutgoingIPAddresses", &f.OutgoingIPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowEndpointsConfiguration.
func (f FlowEndpointsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connector", f.Connector)
	populate(objectMap, "workflow", f.Workflow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowEndpointsConfiguration.
func (f *FlowEndpointsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connector":
			err = unpopulate(val, "Connector", &f.Connector)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &f.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateUpgradedDefinitionParameters.
func (g GenerateUpgradedDefinitionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetSchemaVersion", g.TargetSchemaVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateUpgradedDefinitionParameters.
func (g *GenerateUpgradedDefinitionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetSchemaVersion":
			err = unpopulate(val, "TargetSchemaVersion", &g.TargetSchemaVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetCallbackURLParameters.
func (g GetCallbackURLParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyType", g.KeyType)
	populateDateTimeRFC3339(objectMap, "notAfter", g.NotAfter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetCallbackURLParameters.
func (g *GetCallbackURLParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyType":
			err = unpopulate(val, "KeyType", &g.KeyType)
			delete(rawMsg, key)
		case "notAfter":
			err = unpopulateDateTimeRFC3339(val, "NotAfter", &g.NotAfter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddress.
func (i IPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", i.Address)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddress.
func (i *IPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &i.Address)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressRange.
func (i IPAddressRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressRange", i.AddressRange)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressRange.
func (i *IPAddressRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressRange":
			err = unpopulate(val, "AddressRange", &i.AddressRange)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccount.
func (i IntegrationAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccount.
func (i *IntegrationAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &i.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountAgreement.
func (i IntegrationAccountAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountAgreement.
func (i *IntegrationAccountAgreement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountAgreementFilter.
func (i IntegrationAccountAgreementFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agreementType", i.AgreementType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountAgreementFilter.
func (i *IntegrationAccountAgreementFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agreementType":
			err = unpopulate(val, "AgreementType", &i.AgreementType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountAgreementListResult.
func (i IntegrationAccountAgreementListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountAgreementListResult.
func (i *IntegrationAccountAgreementListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountAgreementProperties.
func (i IntegrationAccountAgreementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agreementType", i.AgreementType)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populateDateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "guestIdentity", i.GuestIdentity)
	populate(objectMap, "guestPartner", i.GuestPartner)
	populate(objectMap, "hostIdentity", i.HostIdentity)
	populate(objectMap, "hostPartner", i.HostPartner)
	populateAny(objectMap, "metadata", i.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountAgreementProperties.
func (i *IntegrationAccountAgreementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agreementType":
			err = unpopulate(val, "AgreementType", &i.AgreementType)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "guestIdentity":
			err = unpopulate(val, "GuestIdentity", &i.GuestIdentity)
			delete(rawMsg, key)
		case "guestPartner":
			err = unpopulate(val, "GuestPartner", &i.GuestPartner)
			delete(rawMsg, key)
		case "hostIdentity":
			err = unpopulate(val, "HostIdentity", &i.HostIdentity)
			delete(rawMsg, key)
		case "hostPartner":
			err = unpopulate(val, "HostPartner", &i.HostPartner)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountCertificate.
func (i IntegrationAccountCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountCertificate.
func (i *IntegrationAccountCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountCertificateListResult.
func (i IntegrationAccountCertificateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountCertificateListResult.
func (i *IntegrationAccountCertificateListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountCertificateProperties.
func (i IntegrationAccountCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "key", i.Key)
	populateAny(objectMap, "metadata", i.Metadata)
	populate(objectMap, "publicCertificate", i.PublicCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountCertificateProperties.
func (i *IntegrationAccountCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &i.Key)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "publicCertificate":
			err = unpopulate(val, "PublicCertificate", &i.PublicCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountListResult.
func (i IntegrationAccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountListResult.
func (i *IntegrationAccountListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMap.
func (i IntegrationAccountMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountMap.
func (i *IntegrationAccountMap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMapFilter.
func (i IntegrationAccountMapFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mapType", i.MapType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountMapFilter.
func (i *IntegrationAccountMapFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mapType":
			err = unpopulate(val, "MapType", &i.MapType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMapListResult.
func (i IntegrationAccountMapListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountMapListResult.
func (i *IntegrationAccountMapListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMapProperties.
func (i IntegrationAccountMapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populate(objectMap, "contentLink", i.ContentLink)
	populate(objectMap, "contentType", i.ContentType)
	populateDateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "mapType", i.MapType)
	populateAny(objectMap, "metadata", i.Metadata)
	populate(objectMap, "parametersSchema", i.ParametersSchema)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountMapProperties.
func (i *IntegrationAccountMapProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &i.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &i.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "mapType":
			err = unpopulate(val, "MapType", &i.MapType)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "parametersSchema":
			err = unpopulate(val, "ParametersSchema", &i.ParametersSchema)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMapPropertiesParametersSchema.
func (i IntegrationAccountMapPropertiesParametersSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ref", i.Ref)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountMapPropertiesParametersSchema.
func (i *IntegrationAccountMapPropertiesParametersSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ref":
			err = unpopulate(val, "Ref", &i.Ref)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountPartner.
func (i IntegrationAccountPartner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountPartner.
func (i *IntegrationAccountPartner) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountPartnerFilter.
func (i IntegrationAccountPartnerFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "partnerType", i.PartnerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountPartnerFilter.
func (i *IntegrationAccountPartnerFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partnerType":
			err = unpopulate(val, "PartnerType", &i.PartnerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountPartnerListResult.
func (i IntegrationAccountPartnerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountPartnerListResult.
func (i *IntegrationAccountPartnerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountPartnerProperties.
func (i IntegrationAccountPartnerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populateDateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populateAny(objectMap, "metadata", i.Metadata)
	populate(objectMap, "partnerType", i.PartnerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountPartnerProperties.
func (i *IntegrationAccountPartnerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "partnerType":
			err = unpopulate(val, "PartnerType", &i.PartnerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountProperties.
func (i IntegrationAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "integrationServiceEnvironment", i.IntegrationServiceEnvironment)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountProperties.
func (i *IntegrationAccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &i.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSKU.
func (i IntegrationAccountSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSKU.
func (i *IntegrationAccountSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSchema.
func (i IntegrationAccountSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSchema.
func (i *IntegrationAccountSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSchemaFilter.
func (i IntegrationAccountSchemaFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "schemaType", i.SchemaType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSchemaFilter.
func (i *IntegrationAccountSchemaFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schemaType":
			err = unpopulate(val, "SchemaType", &i.SchemaType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSchemaListResult.
func (i IntegrationAccountSchemaListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSchemaListResult.
func (i *IntegrationAccountSchemaListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSchemaProperties.
func (i IntegrationAccountSchemaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populate(objectMap, "contentLink", i.ContentLink)
	populate(objectMap, "contentType", i.ContentType)
	populateDateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "documentName", i.DocumentName)
	populate(objectMap, "fileName", i.FileName)
	populateAny(objectMap, "metadata", i.Metadata)
	populate(objectMap, "schemaType", i.SchemaType)
	populate(objectMap, "targetNamespace", i.TargetNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSchemaProperties.
func (i *IntegrationAccountSchemaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &i.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &i.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "documentName":
			err = unpopulate(val, "DocumentName", &i.DocumentName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &i.FileName)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "schemaType":
			err = unpopulate(val, "SchemaType", &i.SchemaType)
			delete(rawMsg, key)
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &i.TargetNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSession.
func (i IntegrationAccountSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSession.
func (i *IntegrationAccountSession) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSessionFilter.
func (i IntegrationAccountSessionFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSessionFilter.
func (i *IntegrationAccountSessionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSessionListResult.
func (i IntegrationAccountSessionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSessionListResult.
func (i *IntegrationAccountSessionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSessionProperties.
func (i IntegrationAccountSessionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populateAny(objectMap, "content", i.Content)
	populateDateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSessionProperties.
func (i *IntegrationAccountSessionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmenEncryptionConfiguration.
func (i IntegrationServiceEnvironmenEncryptionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionKeyReference", i.EncryptionKeyReference)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmenEncryptionConfiguration.
func (i *IntegrationServiceEnvironmenEncryptionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionKeyReference":
			err = unpopulate(val, "EncryptionKeyReference", &i.EncryptionKeyReference)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmenEncryptionKeyReference.
func (i IntegrationServiceEnvironmenEncryptionKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", i.KeyName)
	populate(objectMap, "keyVault", i.KeyVault)
	populate(objectMap, "keyVersion", i.KeyVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmenEncryptionKeyReference.
func (i *IntegrationServiceEnvironmenEncryptionKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &i.KeyVault)
			delete(rawMsg, key)
		case "keyVersion":
			err = unpopulate(val, "KeyVersion", &i.KeyVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironment.
func (i IntegrationServiceEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "identity", i.Identity)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironment.
func (i *IntegrationServiceEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &i.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &i.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentAccessEndpoint.
func (i IntegrationServiceEnvironmentAccessEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentAccessEndpoint.
func (i *IntegrationServiceEnvironmentAccessEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentListResult.
func (i IntegrationServiceEnvironmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentListResult.
func (i *IntegrationServiceEnvironmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentManagedAPI.
func (i IntegrationServiceEnvironmentManagedAPI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentManagedAPI.
func (i *IntegrationServiceEnvironmentManagedAPI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentManagedAPIDeploymentParameters.
func (i IntegrationServiceEnvironmentManagedAPIDeploymentParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentLinkDefinition", i.ContentLinkDefinition)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentManagedAPIDeploymentParameters.
func (i *IntegrationServiceEnvironmentManagedAPIDeploymentParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentLinkDefinition":
			err = unpopulate(val, "ContentLinkDefinition", &i.ContentLinkDefinition)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentManagedAPIListResult.
func (i IntegrationServiceEnvironmentManagedAPIListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentManagedAPIListResult.
func (i *IntegrationServiceEnvironmentManagedAPIListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentManagedAPIProperties.
func (i IntegrationServiceEnvironmentManagedAPIProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiDefinitionUrl", i.APIDefinitionURL)
	populate(objectMap, "apiDefinitions", i.APIDefinitions)
	populate(objectMap, "backendService", i.BackendService)
	populate(objectMap, "capabilities", i.Capabilities)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "connectionParameters", i.ConnectionParameters)
	populate(objectMap, "deploymentParameters", i.DeploymentParameters)
	populate(objectMap, "generalInformation", i.GeneralInformation)
	populate(objectMap, "integrationServiceEnvironment", i.IntegrationServiceEnvironment)
	populate(objectMap, "metadata", i.Metadata)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "policies", i.Policies)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "runtimeUrls", i.RuntimeUrls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentManagedAPIProperties.
func (i *IntegrationServiceEnvironmentManagedAPIProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiDefinitionUrl":
			err = unpopulate(val, "APIDefinitionURL", &i.APIDefinitionURL)
			delete(rawMsg, key)
		case "apiDefinitions":
			err = unpopulate(val, "APIDefinitions", &i.APIDefinitions)
			delete(rawMsg, key)
		case "backendService":
			err = unpopulate(val, "BackendService", &i.BackendService)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &i.Capabilities)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "connectionParameters":
			err = unpopulate(val, "ConnectionParameters", &i.ConnectionParameters)
			delete(rawMsg, key)
		case "deploymentParameters":
			err = unpopulate(val, "DeploymentParameters", &i.DeploymentParameters)
			delete(rawMsg, key)
		case "generalInformation":
			err = unpopulate(val, "GeneralInformation", &i.GeneralInformation)
			delete(rawMsg, key)
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &i.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "policies":
			err = unpopulate(val, "Policies", &i.Policies)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "runtimeUrls":
			err = unpopulate(val, "RuntimeUrls", &i.RuntimeUrls)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentNetworkDependency.
func (i IntegrationServiceEnvironmentNetworkDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "displayName", i.DisplayName)
	populate(objectMap, "endpoints", i.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentNetworkDependency.
func (i *IntegrationServiceEnvironmentNetworkDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &i.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentNetworkDependencyHealth.
func (i IntegrationServiceEnvironmentNetworkDependencyHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", i.Error)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentNetworkDependencyHealth.
func (i *IntegrationServiceEnvironmentNetworkDependencyHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &i.Error)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentNetworkEndpoint.
func (i IntegrationServiceEnvironmentNetworkEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessibility", i.Accessibility)
	populate(objectMap, "domainName", i.DomainName)
	populate(objectMap, "ports", i.Ports)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentNetworkEndpoint.
func (i *IntegrationServiceEnvironmentNetworkEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessibility":
			err = unpopulate(val, "Accessibility", &i.Accessibility)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &i.DomainName)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &i.Ports)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentProperties.
func (i IntegrationServiceEnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionConfiguration", i.EncryptionConfiguration)
	populate(objectMap, "endpointsConfiguration", i.EndpointsConfiguration)
	populate(objectMap, "integrationServiceEnvironmentId", i.IntegrationServiceEnvironmentID)
	populate(objectMap, "networkConfiguration", i.NetworkConfiguration)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentProperties.
func (i *IntegrationServiceEnvironmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionConfiguration":
			err = unpopulate(val, "EncryptionConfiguration", &i.EncryptionConfiguration)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &i.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationServiceEnvironmentId":
			err = unpopulate(val, "IntegrationServiceEnvironmentID", &i.IntegrationServiceEnvironmentID)
			delete(rawMsg, key)
		case "networkConfiguration":
			err = unpopulate(val, "NetworkConfiguration", &i.NetworkConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentSKU.
func (i IntegrationServiceEnvironmentSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", i.Capacity)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentSKU.
func (i *IntegrationServiceEnvironmentSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &i.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentSKUCapacity.
func (i IntegrationServiceEnvironmentSKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", i.Default)
	populate(objectMap, "maximum", i.Maximum)
	populate(objectMap, "minimum", i.Minimum)
	populate(objectMap, "scaleType", i.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentSKUCapacity.
func (i *IntegrationServiceEnvironmentSKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &i.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &i.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &i.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &i.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentSKUDefinition.
func (i IntegrationServiceEnvironmentSKUDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", i.Capacity)
	populate(objectMap, "resourceType", i.ResourceType)
	populate(objectMap, "sku", i.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentSKUDefinition.
func (i *IntegrationServiceEnvironmentSKUDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &i.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &i.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &i.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentSKUDefinitionSKU.
func (i IntegrationServiceEnvironmentSKUDefinitionSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "tier", i.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentSKUDefinitionSKU.
func (i *IntegrationServiceEnvironmentSKUDefinitionSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &i.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentSKUList.
func (i IntegrationServiceEnvironmentSKUList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentSKUList.
func (i *IntegrationServiceEnvironmentSKUList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentSubnetNetworkHealth.
func (i IntegrationServiceEnvironmentSubnetNetworkHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkDependencyHealthState", i.NetworkDependencyHealthState)
	populate(objectMap, "outboundNetworkDependencies", i.OutboundNetworkDependencies)
	populate(objectMap, "outboundNetworkHealth", i.OutboundNetworkHealth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationServiceEnvironmentSubnetNetworkHealth.
func (i *IntegrationServiceEnvironmentSubnetNetworkHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkDependencyHealthState":
			err = unpopulate(val, "NetworkDependencyHealthState", &i.NetworkDependencyHealthState)
			delete(rawMsg, key)
		case "outboundNetworkDependencies":
			err = unpopulate(val, "OutboundNetworkDependencies", &i.OutboundNetworkDependencies)
			delete(rawMsg, key)
		case "outboundNetworkHealth":
			err = unpopulate(val, "OutboundNetworkHealth", &i.OutboundNetworkHealth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSchema.
func (j JSONSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", j.Content)
	populate(objectMap, "title", j.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSchema.
func (j *JSONSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &j.Content)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &j.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKey.
func (k KeyVaultKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", k.Attributes)
	populate(objectMap, "kid", k.Kid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKey.
func (k *KeyVaultKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &k.Attributes)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, "Kid", &k.Kid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyAttributes.
func (k KeyVaultKeyAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "created", k.Created)
	populate(objectMap, "enabled", k.Enabled)
	populate(objectMap, "updated", k.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyAttributes.
func (k *KeyVaultKeyAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulate(val, "Created", &k.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &k.Enabled)
			delete(rawMsg, key)
		case "updated":
			err = unpopulate(val, "Updated", &k.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyCollection.
func (k KeyVaultKeyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", k.SkipToken)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyCollection.
func (k *KeyVaultKeyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &k.SkipToken)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyReference.
func (k KeyVaultKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", k.KeyName)
	populate(objectMap, "keyVault", k.KeyVault)
	populate(objectMap, "keyVersion", k.KeyVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyReference.
func (k *KeyVaultKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &k.KeyName)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &k.KeyVault)
			delete(rawMsg, key)
		case "keyVersion":
			err = unpopulate(val, "KeyVersion", &k.KeyVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyReferenceKeyVault.
func (k KeyVaultKeyReferenceKeyVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyReferenceKeyVault.
func (k *KeyVaultKeyReferenceKeyVault) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultReference.
func (k KeyVaultReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultReference.
func (k *KeyVaultReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListKeyVaultKeysDefinition.
func (l ListKeyVaultKeysDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVault", l.KeyVault)
	populate(objectMap, "skipToken", l.SkipToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListKeyVaultKeysDefinition.
func (l *ListKeyVaultKeysDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVault":
			err = unpopulate(val, "KeyVault", &l.KeyVault)
			delete(rawMsg, key)
		case "skipToken":
			err = unpopulate(val, "SkipToken", &l.SkipToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedAPI.
func (m ManagedAPI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedAPI.
func (m *ManagedAPI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedAPIListResult.
func (m ManagedAPIListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedAPIListResult.
func (m *ManagedAPIListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkConfiguration.
func (n NetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessEndpoint", n.AccessEndpoint)
	populate(objectMap, "subnets", n.Subnets)
	populate(objectMap, "virtualNetworkAddressSpace", n.VirtualNetworkAddressSpace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkConfiguration.
func (n *NetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &n.AccessEndpoint)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &n.Subnets)
			delete(rawMsg, key)
		case "virtualNetworkAddressSpace":
			err = unpopulate(val, "VirtualNetworkAddressSpace", &n.VirtualNetworkAddressSpace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationAccessPolicies.
func (o OpenAuthenticationAccessPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policies", o.Policies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAuthenticationAccessPolicies.
func (o *OpenAuthenticationAccessPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policies":
			err = unpopulate(val, "Policies", &o.Policies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationAccessPolicy.
func (o OpenAuthenticationAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "claims", o.Claims)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAuthenticationAccessPolicy.
func (o *OpenAuthenticationAccessPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "claims":
			err = unpopulate(val, "Claims", &o.Claims)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationPolicyClaim.
func (o OpenAuthenticationPolicyClaim) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OpenAuthenticationPolicyClaim.
func (o *OpenAuthenticationPolicyClaim) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "correlation", o.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populateAny(objectMap, "error", o.Error)
	populateAny(objectMap, "inputs", o.Inputs)
	populate(objectMap, "inputsLink", o.InputsLink)
	populate(objectMap, "iterationCount", o.IterationCount)
	populateAny(objectMap, "outputs", o.Outputs)
	populate(objectMap, "outputsLink", o.OutputsLink)
	populate(objectMap, "retryHistory", o.RetryHistory)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	populateAny(objectMap, "trackedProperties", o.TrackedProperties)
	populate(objectMap, "trackingId", o.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &o.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &o.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &o.InputsLink)
			delete(rawMsg, key)
		case "iterationCount":
			err = unpopulate(val, "IterationCount", &o.IterationCount)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &o.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &o.OutputsLink)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &o.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &o.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &o.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultProperties.
func (o OperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "correlation", o.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populateAny(objectMap, "error", o.Error)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultProperties.
func (o *OperationResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &o.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartnerContent.
func (p PartnerContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "b2b", p.B2B)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartnerContent.
func (p *PartnerContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "b2b":
			err = unpopulate(val, "B2B", &p.B2B)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceSchedule.
func (r RecurrenceSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hours", r.Hours)
	populate(objectMap, "minutes", r.Minutes)
	populate(objectMap, "monthDays", r.MonthDays)
	populate(objectMap, "monthlyOccurrences", r.MonthlyOccurrences)
	populate(objectMap, "weekDays", r.WeekDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurrenceSchedule.
func (r *RecurrenceSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hours":
			err = unpopulate(val, "Hours", &r.Hours)
			delete(rawMsg, key)
		case "minutes":
			err = unpopulate(val, "Minutes", &r.Minutes)
			delete(rawMsg, key)
		case "monthDays":
			err = unpopulate(val, "MonthDays", &r.MonthDays)
			delete(rawMsg, key)
		case "monthlyOccurrences":
			err = unpopulate(val, "MonthlyOccurrences", &r.MonthlyOccurrences)
			delete(rawMsg, key)
		case "weekDays":
			err = unpopulate(val, "WeekDays", &r.WeekDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceScheduleOccurrence.
func (r RecurrenceScheduleOccurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "day", r.Day)
	populate(objectMap, "occurrence", r.Occurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurrenceScheduleOccurrence.
func (r *RecurrenceScheduleOccurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "day":
			err = unpopulate(val, "Day", &r.Day)
			delete(rawMsg, key)
		case "occurrence":
			err = unpopulate(val, "Occurrence", &r.Occurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegenerateActionParameter.
func (r RegenerateActionParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyType", r.KeyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegenerateActionParameter.
func (r *RegenerateActionParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyType":
			err = unpopulate(val, "KeyType", &r.KeyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RepetitionIndex.
func (r RepetitionIndex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "itemIndex", r.ItemIndex)
	populate(objectMap, "scopeName", r.ScopeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RepetitionIndex.
func (r *RepetitionIndex) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "itemIndex":
			err = unpopulate(val, "ItemIndex", &r.ItemIndex)
			delete(rawMsg, key)
		case "scopeName":
			err = unpopulate(val, "ScopeName", &r.ScopeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Request.
func (r Request) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "headers", r.Headers)
	populate(objectMap, "method", r.Method)
	populate(objectMap, "uri", r.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Request.
func (r *Request) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &r.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &r.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistory.
func (r RequestHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistory.
func (r *RequestHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistoryListResult.
func (r RequestHistoryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistoryListResult.
func (r *RequestHistoryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistoryProperties.
func (r RequestHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "request", r.Request)
	populate(objectMap, "response", r.Response)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistoryProperties.
func (r *RequestHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &r.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &r.Response)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReference.
func (r ResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceReference.
func (r *ResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Response.
func (r Response) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bodyLink", r.BodyLink)
	populateAny(objectMap, "headers", r.Headers)
	populate(objectMap, "statusCode", r.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Response.
func (r *Response) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bodyLink":
			err = unpopulate(val, "BodyLink", &r.BodyLink)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &r.Headers)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &r.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetryHistory.
func (r RetryHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientRequestId", r.ClientRequestID)
	populate(objectMap, "code", r.Code)
	populateDateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "serviceRequestId", r.ServiceRequestID)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetryHistory.
func (r *RetryHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &r.ClientRequestID)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "serviceRequestId":
			err = unpopulate(val, "ServiceRequestID", &r.ServiceRequestID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunActionCorrelation.
func (r RunActionCorrelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionTrackingId", r.ActionTrackingID)
	populate(objectMap, "clientKeywords", r.ClientKeywords)
	populate(objectMap, "clientTrackingId", r.ClientTrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunActionCorrelation.
func (r *RunActionCorrelation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionTrackingId":
			err = unpopulate(val, "ActionTrackingID", &r.ActionTrackingID)
			delete(rawMsg, key)
		case "clientKeywords":
			err = unpopulate(val, "ClientKeywords", &r.ClientKeywords)
			delete(rawMsg, key)
		case "clientTrackingId":
			err = unpopulate(val, "ClientTrackingID", &r.ClientTrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCorrelation.
func (r RunCorrelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientKeywords", r.ClientKeywords)
	populate(objectMap, "clientTrackingId", r.ClientTrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCorrelation.
func (r *RunCorrelation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientKeywords":
			err = unpopulate(val, "ClientKeywords", &r.ClientKeywords)
			delete(rawMsg, key)
		case "clientTrackingId":
			err = unpopulate(val, "ClientTrackingID", &r.ClientTrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "plan", s.Plan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &s.Plan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SetTriggerStateActionDefinition.
func (s SetTriggerStateActionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "source", s.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SetTriggerStateActionDefinition.
func (s *SetTriggerStateActionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicList.
func (s SwaggerCustomDynamicList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "builtInOperation", s.BuiltInOperation)
	populate(objectMap, "itemTitlePath", s.ItemTitlePath)
	populate(objectMap, "itemValuePath", s.ItemValuePath)
	populate(objectMap, "itemsPath", s.ItemsPath)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicList.
func (s *SwaggerCustomDynamicList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "builtInOperation":
			err = unpopulate(val, "BuiltInOperation", &s.BuiltInOperation)
			delete(rawMsg, key)
		case "itemTitlePath":
			err = unpopulate(val, "ItemTitlePath", &s.ItemTitlePath)
			delete(rawMsg, key)
		case "itemValuePath":
			err = unpopulate(val, "ItemValuePath", &s.ItemValuePath)
			delete(rawMsg, key)
		case "itemsPath":
			err = unpopulate(val, "ItemsPath", &s.ItemsPath)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicProperties.
func (s SwaggerCustomDynamicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "valuePath", s.ValuePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicProperties.
func (s *SwaggerCustomDynamicProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "valuePath":
			err = unpopulate(val, "ValuePath", &s.ValuePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicSchema.
func (s SwaggerCustomDynamicSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "valuePath", s.ValuePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicSchema.
func (s *SwaggerCustomDynamicSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "valuePath":
			err = unpopulate(val, "ValuePath", &s.ValuePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicTree.
func (s SwaggerCustomDynamicTree) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "browse", s.Browse)
	populate(objectMap, "open", s.Open)
	populate(objectMap, "settings", s.Settings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicTree.
func (s *SwaggerCustomDynamicTree) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "browse":
			err = unpopulate(val, "Browse", &s.Browse)
			delete(rawMsg, key)
		case "open":
			err = unpopulate(val, "Open", &s.Open)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &s.Settings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicTreeCommand.
func (s SwaggerCustomDynamicTreeCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "itemFullTitlePath", s.ItemFullTitlePath)
	populate(objectMap, "itemIsParent", s.ItemIsParent)
	populate(objectMap, "itemTitlePath", s.ItemTitlePath)
	populate(objectMap, "itemValuePath", s.ItemValuePath)
	populate(objectMap, "itemsPath", s.ItemsPath)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "selectableFilter", s.SelectableFilter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicTreeCommand.
func (s *SwaggerCustomDynamicTreeCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "itemFullTitlePath":
			err = unpopulate(val, "ItemFullTitlePath", &s.ItemFullTitlePath)
			delete(rawMsg, key)
		case "itemIsParent":
			err = unpopulate(val, "ItemIsParent", &s.ItemIsParent)
			delete(rawMsg, key)
		case "itemTitlePath":
			err = unpopulate(val, "ItemTitlePath", &s.ItemTitlePath)
			delete(rawMsg, key)
		case "itemValuePath":
			err = unpopulate(val, "ItemValuePath", &s.ItemValuePath)
			delete(rawMsg, key)
		case "itemsPath":
			err = unpopulate(val, "ItemsPath", &s.ItemsPath)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "selectableFilter":
			err = unpopulate(val, "SelectableFilter", &s.SelectableFilter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicTreeParameter.
func (s SwaggerCustomDynamicTreeParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameterReference", s.ParameterReference)
	populate(objectMap, "required", s.Required)
	populate(objectMap, "selectedItemValuePath", s.SelectedItemValuePath)
	populateAny(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicTreeParameter.
func (s *SwaggerCustomDynamicTreeParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameterReference":
			err = unpopulate(val, "ParameterReference", &s.ParameterReference)
			delete(rawMsg, key)
		case "required":
			err = unpopulate(val, "Required", &s.Required)
			delete(rawMsg, key)
		case "selectedItemValuePath":
			err = unpopulate(val, "SelectedItemValuePath", &s.SelectedItemValuePath)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicTreeSettings.
func (s SwaggerCustomDynamicTreeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "CanSelectLeafNodes", s.CanSelectLeafNodes)
	populate(objectMap, "CanSelectParentNodes", s.CanSelectParentNodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerCustomDynamicTreeSettings.
func (s *SwaggerCustomDynamicTreeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "CanSelectLeafNodes":
			err = unpopulate(val, "CanSelectLeafNodes", &s.CanSelectLeafNodes)
			delete(rawMsg, key)
		case "CanSelectParentNodes":
			err = unpopulate(val, "CanSelectParentNodes", &s.CanSelectParentNodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerExternalDocumentation.
func (s SwaggerExternalDocumentation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "extensions", s.Extensions)
	populate(objectMap, "uri", s.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerExternalDocumentation.
func (s *SwaggerExternalDocumentation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &s.Extensions)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &s.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerSchema.
func (s SwaggerSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalProperties", s.AdditionalProperties)
	populate(objectMap, "allOf", s.AllOf)
	populate(objectMap, "discriminator", s.Discriminator)
	populate(objectMap, "dynamicListNew", s.DynamicListNew)
	populate(objectMap, "dynamicSchemaNew", s.DynamicSchemaNew)
	populate(objectMap, "dynamicSchemaOld", s.DynamicSchemaOld)
	populate(objectMap, "dynamicTree", s.DynamicTree)
	populateAny(objectMap, "example", s.Example)
	populate(objectMap, "externalDocs", s.ExternalDocs)
	populate(objectMap, "items", s.Items)
	populate(objectMap, "maxProperties", s.MaxProperties)
	populate(objectMap, "minProperties", s.MinProperties)
	populate(objectMap, "notificationUrlExtension", s.NotificationURLExtension)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "readOnly", s.ReadOnly)
	populate(objectMap, "ref", s.Ref)
	populate(objectMap, "required", s.Required)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "xml", s.XML)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerSchema.
func (s *SwaggerSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalProperties":
			err = unpopulate(val, "AdditionalProperties", &s.AdditionalProperties)
			delete(rawMsg, key)
		case "allOf":
			err = unpopulate(val, "AllOf", &s.AllOf)
			delete(rawMsg, key)
		case "discriminator":
			err = unpopulate(val, "Discriminator", &s.Discriminator)
			delete(rawMsg, key)
		case "dynamicListNew":
			err = unpopulate(val, "DynamicListNew", &s.DynamicListNew)
			delete(rawMsg, key)
		case "dynamicSchemaNew":
			err = unpopulate(val, "DynamicSchemaNew", &s.DynamicSchemaNew)
			delete(rawMsg, key)
		case "dynamicSchemaOld":
			err = unpopulate(val, "DynamicSchemaOld", &s.DynamicSchemaOld)
			delete(rawMsg, key)
		case "dynamicTree":
			err = unpopulate(val, "DynamicTree", &s.DynamicTree)
			delete(rawMsg, key)
		case "example":
			err = unpopulate(val, "Example", &s.Example)
			delete(rawMsg, key)
		case "externalDocs":
			err = unpopulate(val, "ExternalDocs", &s.ExternalDocs)
			delete(rawMsg, key)
		case "items":
			err = unpopulate(val, "Items", &s.Items)
			delete(rawMsg, key)
		case "maxProperties":
			err = unpopulate(val, "MaxProperties", &s.MaxProperties)
			delete(rawMsg, key)
		case "minProperties":
			err = unpopulate(val, "MinProperties", &s.MinProperties)
			delete(rawMsg, key)
		case "notificationUrlExtension":
			err = unpopulate(val, "NotificationURLExtension", &s.NotificationURLExtension)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "readOnly":
			err = unpopulate(val, "ReadOnly", &s.ReadOnly)
			delete(rawMsg, key)
		case "ref":
			err = unpopulate(val, "Ref", &s.Ref)
			delete(rawMsg, key)
		case "required":
			err = unpopulate(val, "Required", &s.Required)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "xml":
			err = unpopulate(val, "XML", &s.XML)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerXML.
func (s SwaggerXML) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attribute", s.Attribute)
	populate(objectMap, "extensions", s.Extensions)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "prefix", s.Prefix)
	populate(objectMap, "wrapped", s.Wrapped)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerXML.
func (s *SwaggerXML) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attribute":
			err = unpopulate(val, "Attribute", &s.Attribute)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &s.Extensions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &s.Namespace)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &s.Prefix)
			delete(rawMsg, key)
		case "wrapped":
			err = unpopulate(val, "Wrapped", &s.Wrapped)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackingEvent.
func (t TrackingEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", t.Error)
	populate(objectMap, "eventLevel", t.EventLevel)
	populateDateTimeRFC3339(objectMap, "eventTime", t.EventTime)
	populateAny(objectMap, "record", t.Record)
	populate(objectMap, "recordType", t.RecordType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackingEvent.
func (t *TrackingEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &t.Error)
			delete(rawMsg, key)
		case "eventLevel":
			err = unpopulate(val, "EventLevel", &t.EventLevel)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateDateTimeRFC3339(val, "EventTime", &t.EventTime)
			delete(rawMsg, key)
		case "record":
			err = unpopulate(val, "Record", &t.Record)
			delete(rawMsg, key)
		case "recordType":
			err = unpopulate(val, "RecordType", &t.RecordType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackingEventErrorInfo.
func (t TrackingEventErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", t.Code)
	populate(objectMap, "message", t.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackingEventErrorInfo.
func (t *TrackingEventErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &t.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &t.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackingEventsDefinition.
func (t TrackingEventsDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "events", t.Events)
	populate(objectMap, "sourceType", t.SourceType)
	populate(objectMap, "trackEventsOptions", t.TrackEventsOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackingEventsDefinition.
func (t *TrackingEventsDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "events":
			err = unpopulate(val, "Events", &t.Events)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &t.SourceType)
			delete(rawMsg, key)
		case "trackEventsOptions":
			err = unpopulate(val, "TrackEventsOptions", &t.TrackEventsOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workflow.
func (w Workflow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workflow.
func (w *Workflow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowFilter.
func (w WorkflowFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", w.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowFilter.
func (w *WorkflowFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowListResult.
func (w WorkflowListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowListResult.
func (w *WorkflowListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowOutputParameter.
func (w WorkflowOutputParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", w.Description)
	populateAny(objectMap, "error", w.Error)
	populateAny(objectMap, "metadata", w.Metadata)
	populate(objectMap, "type", w.Type)
	populateAny(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowOutputParameter.
func (w *WorkflowOutputParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &w.Metadata)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowParameter.
func (w WorkflowParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", w.Description)
	populateAny(objectMap, "metadata", w.Metadata)
	populate(objectMap, "type", w.Type)
	populateAny(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowParameter.
func (w *WorkflowParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &w.Metadata)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowProperties.
func (w WorkflowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessControl", w.AccessControl)
	populate(objectMap, "accessEndpoint", w.AccessEndpoint)
	populateDateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populateAny(objectMap, "definition", w.Definition)
	populate(objectMap, "endpointsConfiguration", w.EndpointsConfiguration)
	populate(objectMap, "integrationAccount", w.IntegrationAccount)
	populate(objectMap, "integrationServiceEnvironment", w.IntegrationServiceEnvironment)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "state", w.State)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowProperties.
func (w *WorkflowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &w.AccessControl)
			delete(rawMsg, key)
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &w.AccessEndpoint)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &w.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationAccount":
			err = unpopulate(val, "IntegrationAccount", &w.IntegrationAccount)
			delete(rawMsg, key)
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &w.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowReference.
func (w WorkflowReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowReference.
func (w *WorkflowReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRun.
func (w WorkflowRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRun.
func (w *WorkflowRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunAction.
func (w WorkflowRunAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunAction.
func (w *WorkflowRunAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionFilter.
func (w WorkflowRunActionFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionFilter.
func (w *WorkflowRunActionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionListResult.
func (w WorkflowRunActionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionListResult.
func (w *WorkflowRunActionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionProperties.
func (w WorkflowRunActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "retryHistory", w.RetryHistory)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populateAny(objectMap, "trackedProperties", w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionProperties.
func (w *WorkflowRunActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &w.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionDefinition.
func (w WorkflowRunActionRepetitionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionDefinition.
func (w *WorkflowRunActionRepetitionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionDefinitionCollection.
func (w WorkflowRunActionRepetitionDefinitionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionDefinitionCollection.
func (w *WorkflowRunActionRepetitionDefinitionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionProperties.
func (w WorkflowRunActionRepetitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populateAny(objectMap, "inputs", w.Inputs)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "iterationCount", w.IterationCount)
	populateAny(objectMap, "outputs", w.Outputs)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "repetitionIndexes", w.RepetitionIndexes)
	populate(objectMap, "retryHistory", w.RetryHistory)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populateAny(objectMap, "trackedProperties", w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionProperties.
func (w *WorkflowRunActionRepetitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &w.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "iterationCount":
			err = unpopulate(val, "IterationCount", &w.IterationCount)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "repetitionIndexes":
			err = unpopulate(val, "RepetitionIndexes", &w.RepetitionIndexes)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &w.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunFilter.
func (w WorkflowRunFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunFilter.
func (w *WorkflowRunFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunListResult.
func (w WorkflowRunListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunListResult.
func (w *WorkflowRunListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunProperties.
func (w WorkflowRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populate(objectMap, "correlationId", w.CorrelationID)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populate(objectMap, "outputs", w.Outputs)
	populate(objectMap, "response", w.Response)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "trigger", w.Trigger)
	populateDateTimeRFC3339(objectMap, "waitEndTime", w.WaitEndTime)
	populate(objectMap, "workflow", w.Workflow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunProperties.
func (w *WorkflowRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &w.CorrelationID)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &w.Response)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &w.Trigger)
			delete(rawMsg, key)
		case "waitEndTime":
			err = unpopulateDateTimeRFC3339(val, "WaitEndTime", &w.WaitEndTime)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &w.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunTrigger.
func (w WorkflowRunTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populateAny(objectMap, "inputs", w.Inputs)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "name", w.Name)
	populateAny(objectMap, "outputs", w.Outputs)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populateDateTimeRFC3339(objectMap, "scheduledTime", w.ScheduledTime)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populateAny(objectMap, "trackedProperties", w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunTrigger.
func (w *WorkflowRunTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &w.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "scheduledTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledTime", &w.ScheduledTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTrigger.
func (w WorkflowTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTrigger.
func (w *WorkflowTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerCallbackURL.
func (w WorkflowTriggerCallbackURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "basePath", w.BasePath)
	populate(objectMap, "method", w.Method)
	populate(objectMap, "queries", w.Queries)
	populate(objectMap, "relativePath", w.RelativePath)
	populate(objectMap, "relativePathParameters", w.RelativePathParameters)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerCallbackURL.
func (w *WorkflowTriggerCallbackURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "basePath":
			err = unpopulate(val, "BasePath", &w.BasePath)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &w.Method)
			delete(rawMsg, key)
		case "queries":
			err = unpopulate(val, "Queries", &w.Queries)
			delete(rawMsg, key)
		case "relativePath":
			err = unpopulate(val, "RelativePath", &w.RelativePath)
			delete(rawMsg, key)
		case "relativePathParameters":
			err = unpopulate(val, "RelativePathParameters", &w.RelativePathParameters)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerFilter.
func (w WorkflowTriggerFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", w.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerFilter.
func (w *WorkflowTriggerFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistory.
func (w WorkflowTriggerHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistory.
func (w *WorkflowTriggerHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistoryFilter.
func (w WorkflowTriggerHistoryFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", w.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryFilter.
func (w *WorkflowTriggerHistoryFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistoryListResult.
func (w WorkflowTriggerHistoryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryListResult.
func (w *WorkflowTriggerHistoryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerHistoryProperties.
func (w WorkflowTriggerHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populateAny(objectMap, "error", w.Error)
	populate(objectMap, "fired", w.Fired)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "run", w.Run)
	populateDateTimeRFC3339(objectMap, "scheduledTime", w.ScheduledTime)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryProperties.
func (w *WorkflowTriggerHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "fired":
			err = unpopulate(val, "Fired", &w.Fired)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "run":
			err = unpopulate(val, "Run", &w.Run)
			delete(rawMsg, key)
		case "scheduledTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledTime", &w.ScheduledTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerListCallbackURLQueries.
func (w WorkflowTriggerListCallbackURLQueries) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api-version", w.APIVersion)
	populate(objectMap, "se", w.Se)
	populate(objectMap, "sig", w.Sig)
	populate(objectMap, "sp", w.Sp)
	populate(objectMap, "sv", w.Sv)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerListCallbackURLQueries.
func (w *WorkflowTriggerListCallbackURLQueries) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api-version":
			err = unpopulate(val, "APIVersion", &w.APIVersion)
			delete(rawMsg, key)
		case "se":
			err = unpopulate(val, "Se", &w.Se)
			delete(rawMsg, key)
		case "sig":
			err = unpopulate(val, "Sig", &w.Sig)
			delete(rawMsg, key)
		case "sp":
			err = unpopulate(val, "Sp", &w.Sp)
			delete(rawMsg, key)
		case "sv":
			err = unpopulate(val, "Sv", &w.Sv)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerListResult.
func (w WorkflowTriggerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerListResult.
func (w *WorkflowTriggerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerProperties.
func (w WorkflowTriggerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populateDateTimeRFC3339(objectMap, "lastExecutionTime", w.LastExecutionTime)
	populateDateTimeRFC3339(objectMap, "nextExecutionTime", w.NextExecutionTime)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "recurrence", w.Recurrence)
	populate(objectMap, "state", w.State)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "workflow", w.Workflow)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerProperties.
func (w *WorkflowTriggerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "LastExecutionTime", &w.LastExecutionTime)
			delete(rawMsg, key)
		case "nextExecutionTime":
			err = unpopulateDateTimeRFC3339(val, "NextExecutionTime", &w.NextExecutionTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &w.Recurrence)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &w.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerRecurrence.
func (w WorkflowTriggerRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", w.EndTime)
	populate(objectMap, "frequency", w.Frequency)
	populate(objectMap, "interval", w.Interval)
	populate(objectMap, "schedule", w.Schedule)
	populate(objectMap, "startTime", w.StartTime)
	populate(objectMap, "timeZone", w.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerRecurrence.
func (w *WorkflowTriggerRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &w.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &w.Interval)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &w.Schedule)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &w.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowTriggerReference.
func (w WorkflowTriggerReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "flowName", w.FlowName)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "triggerName", w.TriggerName)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerReference.
func (w *WorkflowTriggerReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "flowName":
			err = unpopulate(val, "FlowName", &w.FlowName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "triggerName":
			err = unpopulate(val, "TriggerName", &w.TriggerName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersion.
func (w WorkflowVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersion.
func (w *WorkflowVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersionListResult.
func (w WorkflowVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersionListResult.
func (w *WorkflowVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersionProperties.
func (w WorkflowVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessControl", w.AccessControl)
	populate(objectMap, "accessEndpoint", w.AccessEndpoint)
	populateDateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateDateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populateAny(objectMap, "definition", w.Definition)
	populate(objectMap, "endpointsConfiguration", w.EndpointsConfiguration)
	populate(objectMap, "integrationAccount", w.IntegrationAccount)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "state", w.State)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersionProperties.
func (w *WorkflowVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &w.AccessControl)
			delete(rawMsg, key)
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &w.AccessEndpoint)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateDateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &w.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationAccount":
			err = unpopulate(val, "IntegrationAccount", &w.IntegrationAccount)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WsdlService.
func (w WsdlService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EndpointQualifiedNames", w.EndpointQualifiedNames)
	populate(objectMap, "qualifiedName", w.QualifiedName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WsdlService.
func (w *WsdlService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EndpointQualifiedNames":
			err = unpopulate(val, "EndpointQualifiedNames", &w.EndpointQualifiedNames)
			delete(rawMsg, key)
		case "qualifiedName":
			err = unpopulate(val, "QualifiedName", &w.QualifiedName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12AcknowledgementSettings.
func (x X12AcknowledgementSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acknowledgementControlNumberLowerBound", x.AcknowledgementControlNumberLowerBound)
	populate(objectMap, "acknowledgementControlNumberPrefix", x.AcknowledgementControlNumberPrefix)
	populate(objectMap, "acknowledgementControlNumberSuffix", x.AcknowledgementControlNumberSuffix)
	populate(objectMap, "acknowledgementControlNumberUpperBound", x.AcknowledgementControlNumberUpperBound)
	populate(objectMap, "batchFunctionalAcknowledgements", x.BatchFunctionalAcknowledgements)
	populate(objectMap, "batchImplementationAcknowledgements", x.BatchImplementationAcknowledgements)
	populate(objectMap, "batchTechnicalAcknowledgements", x.BatchTechnicalAcknowledgements)
	populate(objectMap, "functionalAcknowledgementVersion", x.FunctionalAcknowledgementVersion)
	populate(objectMap, "implementationAcknowledgementVersion", x.ImplementationAcknowledgementVersion)
	populate(objectMap, "needFunctionalAcknowledgement", x.NeedFunctionalAcknowledgement)
	populate(objectMap, "needImplementationAcknowledgement", x.NeedImplementationAcknowledgement)
	populate(objectMap, "needLoopForValidMessages", x.NeedLoopForValidMessages)
	populate(objectMap, "needTechnicalAcknowledgement", x.NeedTechnicalAcknowledgement)
	populate(objectMap, "rolloverAcknowledgementControlNumber", x.RolloverAcknowledgementControlNumber)
	populate(objectMap, "sendSynchronousAcknowledgement", x.SendSynchronousAcknowledgement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12AcknowledgementSettings.
func (x *X12AcknowledgementSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acknowledgementControlNumberLowerBound":
			err = unpopulate(val, "AcknowledgementControlNumberLowerBound", &x.AcknowledgementControlNumberLowerBound)
			delete(rawMsg, key)
		case "acknowledgementControlNumberPrefix":
			err = unpopulate(val, "AcknowledgementControlNumberPrefix", &x.AcknowledgementControlNumberPrefix)
			delete(rawMsg, key)
		case "acknowledgementControlNumberSuffix":
			err = unpopulate(val, "AcknowledgementControlNumberSuffix", &x.AcknowledgementControlNumberSuffix)
			delete(rawMsg, key)
		case "acknowledgementControlNumberUpperBound":
			err = unpopulate(val, "AcknowledgementControlNumberUpperBound", &x.AcknowledgementControlNumberUpperBound)
			delete(rawMsg, key)
		case "batchFunctionalAcknowledgements":
			err = unpopulate(val, "BatchFunctionalAcknowledgements", &x.BatchFunctionalAcknowledgements)
			delete(rawMsg, key)
		case "batchImplementationAcknowledgements":
			err = unpopulate(val, "BatchImplementationAcknowledgements", &x.BatchImplementationAcknowledgements)
			delete(rawMsg, key)
		case "batchTechnicalAcknowledgements":
			err = unpopulate(val, "BatchTechnicalAcknowledgements", &x.BatchTechnicalAcknowledgements)
			delete(rawMsg, key)
		case "functionalAcknowledgementVersion":
			err = unpopulate(val, "FunctionalAcknowledgementVersion", &x.FunctionalAcknowledgementVersion)
			delete(rawMsg, key)
		case "implementationAcknowledgementVersion":
			err = unpopulate(val, "ImplementationAcknowledgementVersion", &x.ImplementationAcknowledgementVersion)
			delete(rawMsg, key)
		case "needFunctionalAcknowledgement":
			err = unpopulate(val, "NeedFunctionalAcknowledgement", &x.NeedFunctionalAcknowledgement)
			delete(rawMsg, key)
		case "needImplementationAcknowledgement":
			err = unpopulate(val, "NeedImplementationAcknowledgement", &x.NeedImplementationAcknowledgement)
			delete(rawMsg, key)
		case "needLoopForValidMessages":
			err = unpopulate(val, "NeedLoopForValidMessages", &x.NeedLoopForValidMessages)
			delete(rawMsg, key)
		case "needTechnicalAcknowledgement":
			err = unpopulate(val, "NeedTechnicalAcknowledgement", &x.NeedTechnicalAcknowledgement)
			delete(rawMsg, key)
		case "rolloverAcknowledgementControlNumber":
			err = unpopulate(val, "RolloverAcknowledgementControlNumber", &x.RolloverAcknowledgementControlNumber)
			delete(rawMsg, key)
		case "sendSynchronousAcknowledgement":
			err = unpopulate(val, "SendSynchronousAcknowledgement", &x.SendSynchronousAcknowledgement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12AgreementContent.
func (x X12AgreementContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "receiveAgreement", x.ReceiveAgreement)
	populate(objectMap, "sendAgreement", x.SendAgreement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12AgreementContent.
func (x *X12AgreementContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "receiveAgreement":
			err = unpopulate(val, "ReceiveAgreement", &x.ReceiveAgreement)
			delete(rawMsg, key)
		case "sendAgreement":
			err = unpopulate(val, "SendAgreement", &x.SendAgreement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12DelimiterOverrides.
func (x X12DelimiterOverrides) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentSeparator", x.ComponentSeparator)
	populate(objectMap, "dataElementSeparator", x.DataElementSeparator)
	populate(objectMap, "messageId", x.MessageID)
	populate(objectMap, "protocolVersion", x.ProtocolVersion)
	populate(objectMap, "replaceCharacter", x.ReplaceCharacter)
	populate(objectMap, "replaceSeparatorsInPayload", x.ReplaceSeparatorsInPayload)
	populate(objectMap, "segmentTerminator", x.SegmentTerminator)
	populate(objectMap, "segmentTerminatorSuffix", x.SegmentTerminatorSuffix)
	populate(objectMap, "targetNamespace", x.TargetNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12DelimiterOverrides.
func (x *X12DelimiterOverrides) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentSeparator":
			err = unpopulate(val, "ComponentSeparator", &x.ComponentSeparator)
			delete(rawMsg, key)
		case "dataElementSeparator":
			err = unpopulate(val, "DataElementSeparator", &x.DataElementSeparator)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &x.MessageID)
			delete(rawMsg, key)
		case "protocolVersion":
			err = unpopulate(val, "ProtocolVersion", &x.ProtocolVersion)
			delete(rawMsg, key)
		case "replaceCharacter":
			err = unpopulate(val, "ReplaceCharacter", &x.ReplaceCharacter)
			delete(rawMsg, key)
		case "replaceSeparatorsInPayload":
			err = unpopulate(val, "ReplaceSeparatorsInPayload", &x.ReplaceSeparatorsInPayload)
			delete(rawMsg, key)
		case "segmentTerminator":
			err = unpopulate(val, "SegmentTerminator", &x.SegmentTerminator)
			delete(rawMsg, key)
		case "segmentTerminatorSuffix":
			err = unpopulate(val, "SegmentTerminatorSuffix", &x.SegmentTerminatorSuffix)
			delete(rawMsg, key)
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &x.TargetNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12EnvelopeOverride.
func (x X12EnvelopeOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dateFormat", x.DateFormat)
	populate(objectMap, "functionalIdentifierCode", x.FunctionalIdentifierCode)
	populate(objectMap, "headerVersion", x.HeaderVersion)
	populate(objectMap, "messageId", x.MessageID)
	populate(objectMap, "protocolVersion", x.ProtocolVersion)
	populate(objectMap, "receiverApplicationId", x.ReceiverApplicationID)
	populate(objectMap, "responsibleAgencyCode", x.ResponsibleAgencyCode)
	populate(objectMap, "senderApplicationId", x.SenderApplicationID)
	populate(objectMap, "targetNamespace", x.TargetNamespace)
	populate(objectMap, "timeFormat", x.TimeFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12EnvelopeOverride.
func (x *X12EnvelopeOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &x.DateFormat)
			delete(rawMsg, key)
		case "functionalIdentifierCode":
			err = unpopulate(val, "FunctionalIdentifierCode", &x.FunctionalIdentifierCode)
			delete(rawMsg, key)
		case "headerVersion":
			err = unpopulate(val, "HeaderVersion", &x.HeaderVersion)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &x.MessageID)
			delete(rawMsg, key)
		case "protocolVersion":
			err = unpopulate(val, "ProtocolVersion", &x.ProtocolVersion)
			delete(rawMsg, key)
		case "receiverApplicationId":
			err = unpopulate(val, "ReceiverApplicationID", &x.ReceiverApplicationID)
			delete(rawMsg, key)
		case "responsibleAgencyCode":
			err = unpopulate(val, "ResponsibleAgencyCode", &x.ResponsibleAgencyCode)
			delete(rawMsg, key)
		case "senderApplicationId":
			err = unpopulate(val, "SenderApplicationID", &x.SenderApplicationID)
			delete(rawMsg, key)
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &x.TargetNamespace)
			delete(rawMsg, key)
		case "timeFormat":
			err = unpopulate(val, "TimeFormat", &x.TimeFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12EnvelopeSettings.
func (x X12EnvelopeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controlStandardsId", x.ControlStandardsID)
	populate(objectMap, "controlVersionNumber", x.ControlVersionNumber)
	populate(objectMap, "enableDefaultGroupHeaders", x.EnableDefaultGroupHeaders)
	populate(objectMap, "functionalGroupId", x.FunctionalGroupID)
	populate(objectMap, "groupControlNumberLowerBound", x.GroupControlNumberLowerBound)
	populate(objectMap, "groupControlNumberUpperBound", x.GroupControlNumberUpperBound)
	populate(objectMap, "groupHeaderAgencyCode", x.GroupHeaderAgencyCode)
	populate(objectMap, "groupHeaderDateFormat", x.GroupHeaderDateFormat)
	populate(objectMap, "groupHeaderTimeFormat", x.GroupHeaderTimeFormat)
	populate(objectMap, "groupHeaderVersion", x.GroupHeaderVersion)
	populate(objectMap, "interchangeControlNumberLowerBound", x.InterchangeControlNumberLowerBound)
	populate(objectMap, "interchangeControlNumberUpperBound", x.InterchangeControlNumberUpperBound)
	populate(objectMap, "overwriteExistingTransactionSetControlNumber", x.OverwriteExistingTransactionSetControlNumber)
	populate(objectMap, "receiverApplicationId", x.ReceiverApplicationID)
	populate(objectMap, "rolloverGroupControlNumber", x.RolloverGroupControlNumber)
	populate(objectMap, "rolloverInterchangeControlNumber", x.RolloverInterchangeControlNumber)
	populate(objectMap, "rolloverTransactionSetControlNumber", x.RolloverTransactionSetControlNumber)
	populate(objectMap, "senderApplicationId", x.SenderApplicationID)
	populate(objectMap, "transactionSetControlNumberLowerBound", x.TransactionSetControlNumberLowerBound)
	populate(objectMap, "transactionSetControlNumberPrefix", x.TransactionSetControlNumberPrefix)
	populate(objectMap, "transactionSetControlNumberSuffix", x.TransactionSetControlNumberSuffix)
	populate(objectMap, "transactionSetControlNumberUpperBound", x.TransactionSetControlNumberUpperBound)
	populate(objectMap, "usageIndicator", x.UsageIndicator)
	populate(objectMap, "useControlStandardsIdAsRepetitionCharacter", x.UseControlStandardsIDAsRepetitionCharacter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12EnvelopeSettings.
func (x *X12EnvelopeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controlStandardsId":
			err = unpopulate(val, "ControlStandardsID", &x.ControlStandardsID)
			delete(rawMsg, key)
		case "controlVersionNumber":
			err = unpopulate(val, "ControlVersionNumber", &x.ControlVersionNumber)
			delete(rawMsg, key)
		case "enableDefaultGroupHeaders":
			err = unpopulate(val, "EnableDefaultGroupHeaders", &x.EnableDefaultGroupHeaders)
			delete(rawMsg, key)
		case "functionalGroupId":
			err = unpopulate(val, "FunctionalGroupID", &x.FunctionalGroupID)
			delete(rawMsg, key)
		case "groupControlNumberLowerBound":
			err = unpopulate(val, "GroupControlNumberLowerBound", &x.GroupControlNumberLowerBound)
			delete(rawMsg, key)
		case "groupControlNumberUpperBound":
			err = unpopulate(val, "GroupControlNumberUpperBound", &x.GroupControlNumberUpperBound)
			delete(rawMsg, key)
		case "groupHeaderAgencyCode":
			err = unpopulate(val, "GroupHeaderAgencyCode", &x.GroupHeaderAgencyCode)
			delete(rawMsg, key)
		case "groupHeaderDateFormat":
			err = unpopulate(val, "GroupHeaderDateFormat", &x.GroupHeaderDateFormat)
			delete(rawMsg, key)
		case "groupHeaderTimeFormat":
			err = unpopulate(val, "GroupHeaderTimeFormat", &x.GroupHeaderTimeFormat)
			delete(rawMsg, key)
		case "groupHeaderVersion":
			err = unpopulate(val, "GroupHeaderVersion", &x.GroupHeaderVersion)
			delete(rawMsg, key)
		case "interchangeControlNumberLowerBound":
			err = unpopulate(val, "InterchangeControlNumberLowerBound", &x.InterchangeControlNumberLowerBound)
			delete(rawMsg, key)
		case "interchangeControlNumberUpperBound":
			err = unpopulate(val, "InterchangeControlNumberUpperBound", &x.InterchangeControlNumberUpperBound)
			delete(rawMsg, key)
		case "overwriteExistingTransactionSetControlNumber":
			err = unpopulate(val, "OverwriteExistingTransactionSetControlNumber", &x.OverwriteExistingTransactionSetControlNumber)
			delete(rawMsg, key)
		case "receiverApplicationId":
			err = unpopulate(val, "ReceiverApplicationID", &x.ReceiverApplicationID)
			delete(rawMsg, key)
		case "rolloverGroupControlNumber":
			err = unpopulate(val, "RolloverGroupControlNumber", &x.RolloverGroupControlNumber)
			delete(rawMsg, key)
		case "rolloverInterchangeControlNumber":
			err = unpopulate(val, "RolloverInterchangeControlNumber", &x.RolloverInterchangeControlNumber)
			delete(rawMsg, key)
		case "rolloverTransactionSetControlNumber":
			err = unpopulate(val, "RolloverTransactionSetControlNumber", &x.RolloverTransactionSetControlNumber)
			delete(rawMsg, key)
		case "senderApplicationId":
			err = unpopulate(val, "SenderApplicationID", &x.SenderApplicationID)
			delete(rawMsg, key)
		case "transactionSetControlNumberLowerBound":
			err = unpopulate(val, "TransactionSetControlNumberLowerBound", &x.TransactionSetControlNumberLowerBound)
			delete(rawMsg, key)
		case "transactionSetControlNumberPrefix":
			err = unpopulate(val, "TransactionSetControlNumberPrefix", &x.TransactionSetControlNumberPrefix)
			delete(rawMsg, key)
		case "transactionSetControlNumberSuffix":
			err = unpopulate(val, "TransactionSetControlNumberSuffix", &x.TransactionSetControlNumberSuffix)
			delete(rawMsg, key)
		case "transactionSetControlNumberUpperBound":
			err = unpopulate(val, "TransactionSetControlNumberUpperBound", &x.TransactionSetControlNumberUpperBound)
			delete(rawMsg, key)
		case "usageIndicator":
			err = unpopulate(val, "UsageIndicator", &x.UsageIndicator)
			delete(rawMsg, key)
		case "useControlStandardsIdAsRepetitionCharacter":
			err = unpopulate(val, "UseControlStandardsIDAsRepetitionCharacter", &x.UseControlStandardsIDAsRepetitionCharacter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12FramingSettings.
func (x X12FramingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "characterSet", x.CharacterSet)
	populate(objectMap, "componentSeparator", x.ComponentSeparator)
	populate(objectMap, "dataElementSeparator", x.DataElementSeparator)
	populate(objectMap, "replaceCharacter", x.ReplaceCharacter)
	populate(objectMap, "replaceSeparatorsInPayload", x.ReplaceSeparatorsInPayload)
	populate(objectMap, "segmentTerminator", x.SegmentTerminator)
	populate(objectMap, "segmentTerminatorSuffix", x.SegmentTerminatorSuffix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12FramingSettings.
func (x *X12FramingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "characterSet":
			err = unpopulate(val, "CharacterSet", &x.CharacterSet)
			delete(rawMsg, key)
		case "componentSeparator":
			err = unpopulate(val, "ComponentSeparator", &x.ComponentSeparator)
			delete(rawMsg, key)
		case "dataElementSeparator":
			err = unpopulate(val, "DataElementSeparator", &x.DataElementSeparator)
			delete(rawMsg, key)
		case "replaceCharacter":
			err = unpopulate(val, "ReplaceCharacter", &x.ReplaceCharacter)
			delete(rawMsg, key)
		case "replaceSeparatorsInPayload":
			err = unpopulate(val, "ReplaceSeparatorsInPayload", &x.ReplaceSeparatorsInPayload)
			delete(rawMsg, key)
		case "segmentTerminator":
			err = unpopulate(val, "SegmentTerminator", &x.SegmentTerminator)
			delete(rawMsg, key)
		case "segmentTerminatorSuffix":
			err = unpopulate(val, "SegmentTerminatorSuffix", &x.SegmentTerminatorSuffix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12MessageFilter.
func (x X12MessageFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messageFilterType", x.MessageFilterType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12MessageFilter.
func (x *X12MessageFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messageFilterType":
			err = unpopulate(val, "MessageFilterType", &x.MessageFilterType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12MessageIdentifier.
func (x X12MessageIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messageId", x.MessageID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12MessageIdentifier.
func (x *X12MessageIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messageId":
			err = unpopulate(val, "MessageID", &x.MessageID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12OneWayAgreement.
func (x X12OneWayAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protocolSettings", x.ProtocolSettings)
	populate(objectMap, "receiverBusinessIdentity", x.ReceiverBusinessIdentity)
	populate(objectMap, "senderBusinessIdentity", x.SenderBusinessIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12OneWayAgreement.
func (x *X12OneWayAgreement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protocolSettings":
			err = unpopulate(val, "ProtocolSettings", &x.ProtocolSettings)
			delete(rawMsg, key)
		case "receiverBusinessIdentity":
			err = unpopulate(val, "ReceiverBusinessIdentity", &x.ReceiverBusinessIdentity)
			delete(rawMsg, key)
		case "senderBusinessIdentity":
			err = unpopulate(val, "SenderBusinessIdentity", &x.SenderBusinessIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12ProcessingSettings.
func (x X12ProcessingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "convertImpliedDecimal", x.ConvertImpliedDecimal)
	populate(objectMap, "createEmptyXmlTagsForTrailingSeparators", x.CreateEmptyXMLTagsForTrailingSeparators)
	populate(objectMap, "maskSecurityInfo", x.MaskSecurityInfo)
	populate(objectMap, "preserveInterchange", x.PreserveInterchange)
	populate(objectMap, "suspendInterchangeOnError", x.SuspendInterchangeOnError)
	populate(objectMap, "useDotAsDecimalSeparator", x.UseDotAsDecimalSeparator)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12ProcessingSettings.
func (x *X12ProcessingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "convertImpliedDecimal":
			err = unpopulate(val, "ConvertImpliedDecimal", &x.ConvertImpliedDecimal)
			delete(rawMsg, key)
		case "createEmptyXmlTagsForTrailingSeparators":
			err = unpopulate(val, "CreateEmptyXMLTagsForTrailingSeparators", &x.CreateEmptyXMLTagsForTrailingSeparators)
			delete(rawMsg, key)
		case "maskSecurityInfo":
			err = unpopulate(val, "MaskSecurityInfo", &x.MaskSecurityInfo)
			delete(rawMsg, key)
		case "preserveInterchange":
			err = unpopulate(val, "PreserveInterchange", &x.PreserveInterchange)
			delete(rawMsg, key)
		case "suspendInterchangeOnError":
			err = unpopulate(val, "SuspendInterchangeOnError", &x.SuspendInterchangeOnError)
			delete(rawMsg, key)
		case "useDotAsDecimalSeparator":
			err = unpopulate(val, "UseDotAsDecimalSeparator", &x.UseDotAsDecimalSeparator)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12ProtocolSettings.
func (x X12ProtocolSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acknowledgementSettings", x.AcknowledgementSettings)
	populate(objectMap, "envelopeOverrides", x.EnvelopeOverrides)
	populate(objectMap, "envelopeSettings", x.EnvelopeSettings)
	populate(objectMap, "framingSettings", x.FramingSettings)
	populate(objectMap, "messageFilter", x.MessageFilter)
	populate(objectMap, "messageFilterList", x.MessageFilterList)
	populate(objectMap, "processingSettings", x.ProcessingSettings)
	populate(objectMap, "schemaReferences", x.SchemaReferences)
	populate(objectMap, "securitySettings", x.SecuritySettings)
	populate(objectMap, "validationOverrides", x.ValidationOverrides)
	populate(objectMap, "validationSettings", x.ValidationSettings)
	populate(objectMap, "x12DelimiterOverrides", x.X12DelimiterOverrides)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12ProtocolSettings.
func (x *X12ProtocolSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acknowledgementSettings":
			err = unpopulate(val, "AcknowledgementSettings", &x.AcknowledgementSettings)
			delete(rawMsg, key)
		case "envelopeOverrides":
			err = unpopulate(val, "EnvelopeOverrides", &x.EnvelopeOverrides)
			delete(rawMsg, key)
		case "envelopeSettings":
			err = unpopulate(val, "EnvelopeSettings", &x.EnvelopeSettings)
			delete(rawMsg, key)
		case "framingSettings":
			err = unpopulate(val, "FramingSettings", &x.FramingSettings)
			delete(rawMsg, key)
		case "messageFilter":
			err = unpopulate(val, "MessageFilter", &x.MessageFilter)
			delete(rawMsg, key)
		case "messageFilterList":
			err = unpopulate(val, "MessageFilterList", &x.MessageFilterList)
			delete(rawMsg, key)
		case "processingSettings":
			err = unpopulate(val, "ProcessingSettings", &x.ProcessingSettings)
			delete(rawMsg, key)
		case "schemaReferences":
			err = unpopulate(val, "SchemaReferences", &x.SchemaReferences)
			delete(rawMsg, key)
		case "securitySettings":
			err = unpopulate(val, "SecuritySettings", &x.SecuritySettings)
			delete(rawMsg, key)
		case "validationOverrides":
			err = unpopulate(val, "ValidationOverrides", &x.ValidationOverrides)
			delete(rawMsg, key)
		case "validationSettings":
			err = unpopulate(val, "ValidationSettings", &x.ValidationSettings)
			delete(rawMsg, key)
		case "x12DelimiterOverrides":
			err = unpopulate(val, "X12DelimiterOverrides", &x.X12DelimiterOverrides)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12SchemaReference.
func (x X12SchemaReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messageId", x.MessageID)
	populate(objectMap, "schemaName", x.SchemaName)
	populate(objectMap, "schemaVersion", x.SchemaVersion)
	populate(objectMap, "senderApplicationId", x.SenderApplicationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12SchemaReference.
func (x *X12SchemaReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messageId":
			err = unpopulate(val, "MessageID", &x.MessageID)
			delete(rawMsg, key)
		case "schemaName":
			err = unpopulate(val, "SchemaName", &x.SchemaName)
			delete(rawMsg, key)
		case "schemaVersion":
			err = unpopulate(val, "SchemaVersion", &x.SchemaVersion)
			delete(rawMsg, key)
		case "senderApplicationId":
			err = unpopulate(val, "SenderApplicationID", &x.SenderApplicationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12SecuritySettings.
func (x X12SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationQualifier", x.AuthorizationQualifier)
	populate(objectMap, "authorizationValue", x.AuthorizationValue)
	populate(objectMap, "passwordValue", x.PasswordValue)
	populate(objectMap, "securityQualifier", x.SecurityQualifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12SecuritySettings.
func (x *X12SecuritySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationQualifier":
			err = unpopulate(val, "AuthorizationQualifier", &x.AuthorizationQualifier)
			delete(rawMsg, key)
		case "authorizationValue":
			err = unpopulate(val, "AuthorizationValue", &x.AuthorizationValue)
			delete(rawMsg, key)
		case "passwordValue":
			err = unpopulate(val, "PasswordValue", &x.PasswordValue)
			delete(rawMsg, key)
		case "securityQualifier":
			err = unpopulate(val, "SecurityQualifier", &x.SecurityQualifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12ValidationOverride.
func (x X12ValidationOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowLeadingAndTrailingSpacesAndZeroes", x.AllowLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "messageId", x.MessageID)
	populate(objectMap, "trailingSeparatorPolicy", x.TrailingSeparatorPolicy)
	populate(objectMap, "trimLeadingAndTrailingSpacesAndZeroes", x.TrimLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "validateCharacterSet", x.ValidateCharacterSet)
	populate(objectMap, "validateEDITypes", x.ValidateEDITypes)
	populate(objectMap, "validateXSDTypes", x.ValidateXSDTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12ValidationOverride.
func (x *X12ValidationOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "AllowLeadingAndTrailingSpacesAndZeroes", &x.AllowLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &x.MessageID)
			delete(rawMsg, key)
		case "trailingSeparatorPolicy":
			err = unpopulate(val, "TrailingSeparatorPolicy", &x.TrailingSeparatorPolicy)
			delete(rawMsg, key)
		case "trimLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "TrimLeadingAndTrailingSpacesAndZeroes", &x.TrimLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "validateCharacterSet":
			err = unpopulate(val, "ValidateCharacterSet", &x.ValidateCharacterSet)
			delete(rawMsg, key)
		case "validateEDITypes":
			err = unpopulate(val, "ValidateEDITypes", &x.ValidateEDITypes)
			delete(rawMsg, key)
		case "validateXSDTypes":
			err = unpopulate(val, "ValidateXSDTypes", &x.ValidateXSDTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type X12ValidationSettings.
func (x X12ValidationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowLeadingAndTrailingSpacesAndZeroes", x.AllowLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "checkDuplicateGroupControlNumber", x.CheckDuplicateGroupControlNumber)
	populate(objectMap, "checkDuplicateInterchangeControlNumber", x.CheckDuplicateInterchangeControlNumber)
	populate(objectMap, "checkDuplicateTransactionSetControlNumber", x.CheckDuplicateTransactionSetControlNumber)
	populate(objectMap, "interchangeControlNumberValidityDays", x.InterchangeControlNumberValidityDays)
	populate(objectMap, "trailingSeparatorPolicy", x.TrailingSeparatorPolicy)
	populate(objectMap, "trimLeadingAndTrailingSpacesAndZeroes", x.TrimLeadingAndTrailingSpacesAndZeroes)
	populate(objectMap, "validateCharacterSet", x.ValidateCharacterSet)
	populate(objectMap, "validateEDITypes", x.ValidateEDITypes)
	populate(objectMap, "validateXSDTypes", x.ValidateXSDTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type X12ValidationSettings.
func (x *X12ValidationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", x, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "AllowLeadingAndTrailingSpacesAndZeroes", &x.AllowLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "checkDuplicateGroupControlNumber":
			err = unpopulate(val, "CheckDuplicateGroupControlNumber", &x.CheckDuplicateGroupControlNumber)
			delete(rawMsg, key)
		case "checkDuplicateInterchangeControlNumber":
			err = unpopulate(val, "CheckDuplicateInterchangeControlNumber", &x.CheckDuplicateInterchangeControlNumber)
			delete(rawMsg, key)
		case "checkDuplicateTransactionSetControlNumber":
			err = unpopulate(val, "CheckDuplicateTransactionSetControlNumber", &x.CheckDuplicateTransactionSetControlNumber)
			delete(rawMsg, key)
		case "interchangeControlNumberValidityDays":
			err = unpopulate(val, "InterchangeControlNumberValidityDays", &x.InterchangeControlNumberValidityDays)
			delete(rawMsg, key)
		case "trailingSeparatorPolicy":
			err = unpopulate(val, "TrailingSeparatorPolicy", &x.TrailingSeparatorPolicy)
			delete(rawMsg, key)
		case "trimLeadingAndTrailingSpacesAndZeroes":
			err = unpopulate(val, "TrimLeadingAndTrailingSpacesAndZeroes", &x.TrimLeadingAndTrailingSpacesAndZeroes)
			delete(rawMsg, key)
		case "validateCharacterSet":
			err = unpopulate(val, "ValidateCharacterSet", &x.ValidateCharacterSet)
			delete(rawMsg, key)
		case "validateEDITypes":
			err = unpopulate(val, "ValidateEDITypes", &x.ValidateEDITypes)
			delete(rawMsg, key)
		case "validateXSDTypes":
			err = unpopulate(val, "ValidateXSDTypes", &x.ValidateXSDTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", x, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
