/* GSequencer - Advanced GTK Sequencer
 * Copyright (C) 2005-2024 Joël Krähemann
 *
 * This file is part of GSequencer.
 *
 * GSequencer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GSequencer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GSequencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __AGS_SEQUENCER_EDITOR_H__
#define __AGS_SEQUENCER_EDITOR_H__

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

#include <ags/libags.h>
#include <ags/libags-audio.h>

#include <ags/libags-gui.h>

G_BEGIN_DECLS

#define AGS_TYPE_SEQUENCER_EDITOR                (ags_sequencer_editor_get_type())
#define AGS_SEQUENCER_EDITOR(obj)                (G_TYPE_CHECK_INSTANCE_CAST((obj), AGS_TYPE_SEQUENCER_EDITOR, AgsSequencerEditor))
#define AGS_SEQUENCER_EDITOR_CLASS(class)        (G_TYPE_CHECK_CLASS_CAST((class), AGS_TYPE_SEQUENCER_EDITOR, AgsSequencerEditorClass))
#define AGS_IS_SEQUENCER_EDITOR(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AGS_TYPE_SEQUENCER_EDITOR))
#define AGS_IS_SEQUENCER_EDITOR_CLASS(class)     (G_TYPE_CHECK_CLASS_TYPE ((class), AGS_TYPE_SEQUENCER_EDITOR))
#define AGS_SEQUENCER_EDITOR_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), AGS_TYPE_SEQUENCER_EDITOR, AgsSequencerEditorClass))

typedef struct _AgsSequencerEditor AgsSequencerEditor;
typedef struct _AgsSequencerEditorClass AgsSequencerEditorClass;

struct _AgsSequencerEditor
{
  GtkBox box;

  guint flags;
  guint connectable_flags;
  
  GObject *sequencer;
  GObject *sequencer_thread;
  
  GtkComboBoxText *backend;
  
  GtkComboBoxText *card;
  
  GtkBox *source_hbox;
  
  GtkButton *add_source;
  GtkButton *remove_source;

  GtkButton *remove;
};

struct _AgsSequencerEditorClass
{
  GtkBoxClass box;
};

GType ags_sequencer_editor_get_type(void);

void ags_sequencer_editor_add_source(AgsSequencerEditor *sequencer_editor,
				     gchar *device);
void ags_sequencer_editor_remove_source(AgsSequencerEditor *sequencer_editor,
					gchar *device);

void ags_sequencer_editor_add_sequencer(AgsSequencerEditor *sequencer_editor,
					GObject *sequencer);
void ags_sequencer_editor_remove_sequencer(AgsSequencerEditor *sequencer_editor,
					   GObject *sequencer);

void ags_sequencer_editor_load_alsa_card(AgsSequencerEditor *sequencer_editor);
void ags_sequencer_editor_load_oss_card(AgsSequencerEditor *sequencer_editor);
void ags_sequencer_editor_load_core_midi_card(AgsSequencerEditor *sequencer_editor);
void ags_sequencer_editor_load_jack_card(AgsSequencerEditor *sequencer_editor);

AgsSequencerEditor* ags_sequencer_editor_new();

G_END_DECLS

#endif /*__AGS_SEQUENCER_EDITOR_H__*/
