#pragma once
/*
 *  $Id: distance-transform.h 28873 2025-11-18 14:59:29Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_DISTANCE_TRANSFORM_H__
#define __GWY_DISTANCE_TRANSFORM_H__

#include <libgwyddion/field.h>
#include <libgwyddion/nield.h>

G_BEGIN_DECLS

typedef enum {
    GWY_DISTANCE_TRANSFORM_CITYBLOCK   = 0,
    GWY_DISTANCE_TRANSFORM_CONN4       = 0,
    GWY_DISTANCE_TRANSFORM_CHESS       = 1,
    GWY_DISTANCE_TRANSFORM_CONN8       = 1,
    GWY_DISTANCE_TRANSFORM_OCTAGONAL48 = 2,
    GWY_DISTANCE_TRANSFORM_OCTAGONAL84 = 3,
    GWY_DISTANCE_TRANSFORM_OCTAGONAL   = 4,
    GWY_DISTANCE_TRANSFORM_EUCLIDEAN   = 5,
} GwyDistanceTransformType;

const GwyEnum* gwy_distance_transform_type_get_enum(void)                           G_GNUC_CONST;
void           gwy_nield_distance_transform        (GwyNield *nield,
                                                    GwyField *distances,
                                                    GwyDistanceTransformType dtype,
                                                    gboolean from_border);
void           gwy_nield_shrink                    (GwyNield *nield,
                                                    gdouble amount,
                                                    GwyDistanceTransformType dtype,
                                                    gboolean from_border);
void           gwy_nield_grow                      (GwyNield *nield,
                                                    gdouble amount,
                                                    GwyDistanceTransformType dtype,
                                                    gboolean prevent_merging);
void           gwy_nield_thin                      (GwyNield *nield);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */

