#!/bin/sh


cd `dirname $0`
if ! [ "$1" = "nocolor" ]
then
. ./colors.sh
fi

percent(){
    printf "$(( $1 * 100 / $2  ))"
}

EMFC="../../src/lib/emf2svg_rec_*"
PMFC="../../src/lib/pmf2svg_print.c"
count_emf_SUPPORTED=`cat $EMFC | grep -c FLAG_SUPPORTED`
count_emf_IGNORED=`cat $EMFC | grep -c FLAG_IGNORED`
count_emf_UNUSED=`cat $EMFC | grep -c FLAG_UNUSED`
count_emf_PARTIAL=`cat $EMFC | grep -c FLAG_PARTIAL`
total_emf=$(( $count_emf_SUPPORTED + $count_emf_IGNORED + $count_emf_UNUSED + $count_emf_PARTIAL  ))

printf "EMF/EMF+ record type coverage\n"
printf "%s\n\n" "-----------------------------"
printf "EMF RECORDS:\n\n"

printf "|   Status  | Count | Percent |\n"
printf "|:---------:|:-----:|:-------:|\n"
printf "| ${BGre}Supported ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_SUPPORTED" "`percent $count_emf_SUPPORTED $total_emf`"
printf "| ${BYel}Partial   ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_PARTIAL"   "`percent $count_emf_PARTIAL   $total_emf`"
printf "| ${BBlu}Unused    ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_UNUSED"    "`percent $count_emf_UNUSED    $total_emf`"
printf "| ${BRed}Ignored   ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_IGNORED"   "`percent $count_emf_IGNORED   $total_emf`"
printf "| Total     |  %3d  |         |\n" $total_emf


printf "\n"

count_emf_SUPPORTED=`grep -c FLAG_SUPPORTED $PMFC`
count_emf_IGNORED=`grep -c FLAG_IGNORED     $PMFC`
count_emf_UNUSED=`grep -c FLAG_UNUSED       $PMFC`
count_emf_PARTIAL=`grep -c FLAG_PARTIAL     $PMFC`
total_emf=$(( $count_emf_SUPPORTED + $count_emf_IGNORED + $count_emf_UNUSED + $count_emf_PARTIAL  ))
printf "EMF+ RECORDS:\n\n"

printf "|   Status  | Count | Percent |\n"
printf "|:---------:|:-----:|:-------:|\n"
printf "| ${BGre}Supported ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_SUPPORTED" "`percent $count_emf_SUPPORTED $total_emf`"
printf "| ${BYel}Partial   ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_PARTIAL"   "`percent $count_emf_PARTIAL   $total_emf`"
printf "| ${BBlu}Unused    ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_UNUSED"    "`percent $count_emf_UNUSED    $total_emf`"
printf "| ${BRed}Ignored   ${RCol}|  %3d  | [${BCya}%4d%%${RCol}] |\n"  "$count_emf_IGNORED"   "`percent $count_emf_IGNORED   $total_emf`"
printf "| Total     |  %3d  |         |\n" $total_emf

