//                                               -*- C++ -*-
/**
 *  @brief Results of a data analysis
 *
 *  Copyright 2015-2025 EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#include "persalys/DataAnalysisResult.hxx"

#include <openturns/PersistentObjectFactory.hxx>

using namespace OT;

namespace PERSALYS
{

CLASSNAMEINIT(DataAnalysisResult)

static Factory<DataAnalysisResult> Factory_DataAnalysisResult;

/* Default constructor */
DataAnalysisResult::DataAnalysisResult()
  : EvaluationResult()
{

}


/* Constructor with parameters */
DataAnalysisResult::DataAnalysisResult(const DesignOfExperiment& design)
  : EvaluationResult(design)
{

}


DataAnalysisResult* DataAnalysisResult::clone() const
{
  return new DataAnalysisResult(*this);
}


DataAnalysisResult::PointCollection DataAnalysisResult::getMin() const
{
  return min_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getMax() const
{
  return max_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getMean() const
{
  return mean_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getCoefficientOfVariation() const
{
  return coefficientOfVariation_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getMedian() const
{
  return median_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getStandardDeviation() const
{
  return standardDeviation_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getVariance() const
{
  return variance_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getSkewness() const
{
  return skewness_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getKurtosis() const
{
  return kurtosis_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getFirstQuartile() const
{
  return firstQuartile_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getThirdQuartile() const
{
  return thirdQuartile_;
}


Interval DataAnalysisResult::getMeanConfidenceInterval() const
{
  return meanConfidenceInterval_;
}


Interval DataAnalysisResult::getStdConfidenceInterval() const
{
  return stdConfidenceInterval_;
}


DataAnalysisResult::PointCollection DataAnalysisResult::getOutliers() const
{
  return outliers_;
}

Point DataAnalysisResult::getEffectiveSize() const
{
  return effectiveSize_;
}

DesignOfExperiment DataAnalysisResult::getMultivariateDoE() const
{
  return multiVariateDoE_;
}


DataSample::SampleCollection DataAnalysisResult::getPDF() const
{
  return pdf_;
}


DataSample::SampleCollection DataAnalysisResult::getCDF() const
{
  return cdf_;
}


DataSample::SampleCollection DataAnalysisResult::getSurvivalFunction() const
{
  return survFct_;
}


/* String converter */
String DataAnalysisResult::__repr__() const
{
  OSS oss;
  oss << "class=" << GetClassName()
      << " name=" << getName()
      << " min=" << getMin()
      << " max=" << getMax()
      << " mean=" << getMean()
      << " median=" << getMedian()
      << " standardDeviation=" << getStandardDeviation()
      << " coefficientOfVariation=" << getCoefficientOfVariation()
      << " variance=" << getVariance()
      << " skewness=" << getSkewness()
      << " kurtosis=" << getKurtosis()
      << " firstQuartile=" << getFirstQuartile()
      << " thirdQuartile=" << getThirdQuartile()
      << " meanConfidenceInterval=" << getMeanConfidenceInterval()
      << " stdConfidenceInterval=" << getStdConfidenceInterval();
    if (effectiveSize_.getDimension())
      oss << " effectiveSize=" << getEffectiveSize().__str__();
  return oss;
}


/* Method save() stores the object through the StorageManager */
void DataAnalysisResult::save(Advocate & adv) const
{
  EvaluationResult::save(adv);
  adv.saveAttribute("min_", min_);
  adv.saveAttribute("max_", max_);
  adv.saveAttribute("mean_", mean_);
  adv.saveAttribute("median_", median_);
  adv.saveAttribute("standardDeviation_", standardDeviation_);
  adv.saveAttribute("coefficientOfVariation_", coefficientOfVariation_);
  adv.saveAttribute("variance_", variance_);
  adv.saveAttribute("skewness_", skewness_);
  adv.saveAttribute("kurtosis_", kurtosis_);
  adv.saveAttribute("firstQuartile_", firstQuartile_);
  adv.saveAttribute("thirdQuartile_", thirdQuartile_);
  adv.saveAttribute("meanConfidenceInterval_", meanConfidenceInterval_);
  adv.saveAttribute("stdConfidenceInterval_", stdConfidenceInterval_);
  adv.saveAttribute("outliers_", outliers_);
  adv.saveAttribute("pdf_", pdf_);
  adv.saveAttribute("cdf_", cdf_);
  adv.saveAttribute("survFct__", survFct_);
  adv.saveAttribute("effectiveSize_", effectiveSize_);
  adv.saveAttribute("multiVariateDoE_", multiVariateDoE_);
}


/* Method load() reloads the object from the StorageManager */
void DataAnalysisResult::load(Advocate & adv)
{
  EvaluationResult::load(adv);
  adv.loadAttribute("min_", min_);
  adv.loadAttribute("max_", max_);
  adv.loadAttribute("mean_", mean_);
  adv.loadAttribute("median_", median_);
  adv.loadAttribute("standardDeviation_", standardDeviation_);
  adv.loadAttribute("coefficientOfVariation_", coefficientOfVariation_);
  adv.loadAttribute("variance_", variance_);
  adv.loadAttribute("skewness_", skewness_);
  adv.loadAttribute("kurtosis_", kurtosis_);
  adv.loadAttribute("firstQuartile_", firstQuartile_);
  adv.loadAttribute("thirdQuartile_", thirdQuartile_);
  adv.loadAttribute("meanConfidenceInterval_", meanConfidenceInterval_);
  adv.loadAttribute("stdConfidenceInterval_", stdConfidenceInterval_);
  adv.loadAttribute("outliers_", outliers_);
  adv.loadAttribute("pdf_", pdf_);
  adv.loadAttribute("cdf_", cdf_);
  if (adv.hasAttribute("survFct_"))
    adv.loadAttribute("survFct_", survFct_);
  if (adv.hasAttribute("effectiveSize_"))
    adv.loadAttribute("effectiveSize_", effectiveSize_);
  if (adv.hasAttribute("multiVariateDoE_"))
    adv.loadAttribute("multiVariateDoE_", multiVariateDoE_);
  else
    multiVariateDoE_ = designOfExperiment_;
}
}
