
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>

// module includes
#include <XmlMDocStd.hxx>
#include <XmlMDocStd_XLinkDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlMDocStd(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XmlMDocStd"));
py::object klass;

//Python trampoline classes

// classes

    // Class XmlMDocStd from ./opencascade/XmlMDocStd.hxx
    klass = m.attr("XmlMDocStd");

    // default constructor
    register_default_constructor<XmlMDocStd , shared_ptr<XmlMDocStd>>(m,"XmlMDocStd");

    // nested enums

    static_cast<py::class_<XmlMDocStd , shared_ptr<XmlMDocStd>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&XmlMDocStd::AddDrivers),
                    R"#(Adds the attribute drivers to <aDriverTable>.)#"  , py::arg("aDriverTable"),  py::arg("theMessageDriver")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XmlMDocStd_XLinkDriver from ./opencascade/XmlMDocStd_XLinkDriver.hxx
    klass = m.attr("XmlMDocStd_XLinkDriver");


    // nested enums

    static_cast<py::class_<XmlMDocStd_XLinkDriver ,opencascade::handle<XmlMDocStd_XLinkDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDocStd_XLinkDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDocStd_XLinkDriver::*)() const>(&XmlMDocStd_XLinkDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDocStd_XLinkDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDocStd_XLinkDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDocStd_XLinkDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDocStd_XLinkDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDocStd_XLinkDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDocStd_XLinkDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDocStd_XLinkDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDocStd_XLinkDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDocStd_XLinkDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDocStd_XLinkDriver::*)() const>(&XmlMDocStd_XLinkDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/XmlMDocStd.hxx
// ./opencascade/XmlMDocStd_XLinkDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
