% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.marginal.R
\name{recurrentMarginal}
\alias{recurrentMarginal}
\alias{tie.breaker}
\alias{recmarg}
\alias{recurrentMarginalAIPCW}
\alias{recurrentMarginalPhreg}
\title{Fast recurrent marginal mean when death is possible}
\usage{
recurrentMarginal(formula, data, cause = 1, ..., death.code = 2)
}
\arguments{
\item{formula}{with Event object}

\item{data}{data frame for computation}

\item{cause}{of interest (1 default)}

\item{...}{Additional arguments to lower level funtions}

\item{death.code}{codes for death (terminating event, 2 default)}
}
\description{
Fast Marginal means of recurrent events using the Lin and Ghosh (2000) 
standard errors.  
Fitting two models for death and recurent events these are
combined to prducte the estimator 
\deqn{ \int_0^t  S(u|x=0) dR(u|x=0) } the mean number of recurrent events, here
\deqn{ S(u|x=0) }  is the probability of survival for the baseline group, and 
\deqn{ dR(u|x=0) }  is the hazard rate of an event among survivors for the baseline. 
Here \deqn{ S(u|x=0) }  is estimated by \deqn{ exp(-\Lambda_d(u|x=0) }  with 
 \deqn{\Lambda_d(u|x=0) } being the cumulative baseline for death.
}
\details{
Assumes no ties in the sense that jump times needs to be unique, this is particularly so for the stratified version.
}
\examples{
library(mets)
data(hfactioncpx12)
hf <- hfactioncpx12
hf$x <- as.numeric(hf$treatment) 

##  to fit non-parametric models with just a baseline 
xr <- phreg(Surv(entry,time,status==1)~cluster(id),data=hf)
dr <- phreg(Surv(entry,time,status==2)~cluster(id),data=hf)
par(mfrow=c(1,3))
plot(dr,se=TRUE)
title(main="death")
plot(xr,se=TRUE)
### robust standard errors 
rxr <-  robust.phreg(xr,fixbeta=1)
plot(rxr,se=TRUE,robust=TRUE,add=TRUE,col=4)

## marginal mean of expected number of recurrent events 
## out <- recurrentMarginalPhreg(xr,dr)
## summary(out,times=1:5) 

## marginal mean using formula  
outN <- recurrentMarginal(Event(entry,time,status)~cluster(id),hf,cause=1,death.code=2)
plot(outN,se=TRUE,col=2,add=TRUE)
summary(outN,times=1:5) 

########################################################################
###   with strata     ##################################################
########################################################################
out <- recurrentMarginal(Event(entry,time,status)~strata(treatment)+cluster(id),
                         data=hf,cause=1,death.code=2)
plot(out,se=TRUE,ylab="marginal mean",col=1:2)

summary(out,times=1:5) 

}
\references{
Cook, R. J. and Lawless, J. F. (1997) Marginal analysis of recurrent events and a terminating event. Statist. Med., 16, 911–924.
Ghosh and Lin (2002) Nonparametric Analysis of Recurrent events and death, Biometrics, 554--562.
}
\author{
Thomas Scheike
}
