% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_futility_bounds.R
\name{getFutilityBounds}
\alias{getFutilityBounds}
\title{Get Futility Bounds}
\usage{
getFutilityBounds(
  sourceValue,
  ...,
  sourceScale = c("zValue", "pValue", "conditionalPower", "condPowerAtObserved",
    "predictivePower", "reverseCondPower", "effectEstimate"),
  targetScale = c("zValue", "pValue", "conditionalPower", "condPowerAtObserved",
    "predictivePower", "reverseCondPower", "effectEstimate"),
  design = NULL,
  theta = NA_real_,
  information = NA_real_,
  naAllowed = FALSE
)
}
\arguments{
\item{sourceValue}{A numeric vector representing the
futility bounds in the source scale.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{sourceScale}{Character. The scale of the input futility bounds.
Must be one of \code{"zValue"}, \code{"pValue"},
\code{"conditionalPower"}, "condPowerAtObserved", \code{"predictivePower"},
\code{"reverseCondPower"}, or \code{"effectEstimate"}.}

\item{targetScale}{Character. The scale to which the futility bounds should
be converted. Must be one of \code{"zValue"}, \code{"pValue"},
\code{"conditionalPower"}, "condPowerAtObserved", \code{"predictivePower"},
\code{"reverseCondPower"}, or \code{"effectEstimate"}.}

\item{design}{The trial design. Required if either the \code{sourceScale} or
\code{targetScale} is \code{"reverseCondPower"} or if the conversion
involves conditional or predictive power in a group sequential or Fisher design.
Must be a one-sided two-stage group sequential design or Fisher's combination test design.}

\item{theta}{Numeric. The assumed effect size under the alternative hypothesis.}

\item{information}{Numeric vector of length 2. The information levels at the two stages.}

\item{naAllowed}{Logical. Indicates if \code{NA} \code{sourceValue} are permitted. Default is \code{FALSE}.}
}
\value{
A numeric vector representing the futility bounds in the target scale, or
\code{NULL} if the conversion is not implemented or yields no result.
}
\description{
This function converts futility bounds between different scales such as
z-value, p-value, conditional power, predictive power, reverse conditional
power, and effect estimate.
}
\details{
If the \code{sourceScale} and \code{targetScale} are the same, the function
returns the input \code{sourceValue} without modification.
Otherwise, the function is designed to convert between the specified scales.
}
\examples{
\dontrun{
# Example with identical source and target scales
getFutilityBounds(
    sourceValue = c(0, 0.5),
    sourceScale = "zValue",
    targetScale = "zValue"
)

# Example with different scales
getFutilityBounds(
    design = getDesignGroupSequential(kMax = 2, typeOfDesign = "noEarlyEfficacy", alpha = 0.05),
    information = c(10, 10),
    sourceValue = 0.5,
    sourceScale = "condPowerAtObserved",
    targetScale = "pValue"
)
}

}
\seealso{
\code{\link[=getDesignGroupSequential]{getDesignGroupSequential()}},
\code{\link[=getDesignInverseNormal]{getDesignInverseNormal()}},
\code{\link[=getDesignFisher]{getDesignFisher()}} for direct
specification of futility bounds on different scales using the
argument \code{futilityBoundsScale}.
}
