### New features

* [#14655](https://github.com/rubocop/rubocop/issues/14655): Add `AllowRBSInlineAnnotation` option to `Layout/LineLength`. ([@koic][])
* [#14569](https://github.com/rubocop/rubocop/issues/14569): Add `IncludedMacroPatterns` configuration option to `Style/MethodCallWithArgsParentheses` for pattern-based macro method enforcement. ([@mmenanno][])
* [#14670](https://github.com/rubocop/rubocop/pull/14670): Add new cop `Style/ModuleMemberExistenceCheck`. ([@lovro-bikic][])
* [#14644](https://github.com/rubocop/rubocop/pull/14644): Support `TargetRubyVersion 4.0` (experimental). ([@koic][])

### Bug fixes

* [#14649](https://github.com/rubocop/rubocop/pull/14649): Fix an error for `Lint/LiteralAsCondition` when there are literals in multiple branches. ([@viralpraxis][])
* [#14678](https://github.com/rubocop/rubocop/pull/14678): Fix an error when running deprecated `rake rubocop:auto_correct` task. ([@koic][])
* [#14650](https://github.com/rubocop/rubocop/pull/14650): Fix wrong autocorrect for `Lint/RedundantSplatExpansion` when splatting a single literal. ([@earlopain][])
* [#14703](https://github.com/rubocop/rubocop/pull/14703): Fix false negatives for `Layout/RescueEnsureAlignment` when using self class definition. ([@koic][])
* [#14706](https://github.com/rubocop/rubocop/issues/14706): Fix false negatives for `Lint/NoReturnInBeginEndBlocks` when assigning instance variable, class variable, global variable, or constant. ([@koic][])
* [#14715](https://github.com/rubocop/rubocop/pull/14715): Fix false positives for `Layout/EmptyLineAfterGuardClause` when a guard clause follows a multiline heredoc in a parenthesized method call. ([@koic][])
* [#14667](https://github.com/rubocop/rubocop/issues/14667): Fix false positives for `Layout/EndAlignment` when a conditional assignment is used on the same line and the `end` with a safe navigation method call is aligned. ([@koic][])
* [#14688](https://github.com/rubocop/rubocop/pull/14688): Fix false positives for `Layout/EndAlignment` when a conditional assignment is used on the same line and the `end` with a numbered block or `it` block method call is aligned. ([@koic][])
* [#14699](https://github.com/rubocop/rubocop/pull/14699): Fix false positives for `Lint/RedundantSafeNavigation` when the receiver is used outside the singleton method definition scope. ([@koic][])
* [#14663](https://github.com/rubocop/rubocop/issues/14663): Fix false positives for `Style/EndlessMethod` when multiline or xstring heredoc is used in method body. ([@koic][])
* [#10173](https://github.com/rubocop/rubocop/issues/10173): Fix false positives for `Style/TrailingCommaInArguments` when `EnforcedStyleForMultiline` is set to `consistent_comma` and a multiline braced hash argument appears after another argument. ([@koic][])
* [#14680](https://github.com/rubocop/rubocop/pull/14680): Handle all `OptionParser` errors when running `rubocop` with input that causes an error. ([@dvandersluis][])
* [#14658](https://github.com/rubocop/rubocop/pull/14658): Fix incorrect behavior when `Layout/LineLength` is disabled. ([@koic][])
* [#14704](https://github.com/rubocop/rubocop/pull/14704): Fix incorrect Position character value in LSP. ([@tmtm][])
* [#14619](https://github.com/rubocop/rubocop/issues/14619): Store remote configuration caches in cache root. ([@Jack12816][])
* [#14476](https://github.com/rubocop/rubocop/issues/14476): Fix `Style/ClassAndModuleChildren` to skip compact style definitions inside another class or module when `EnforcedStyle: nested`. ([@rscq][])
* [#14281](https://github.com/rubocop/rubocop/issues/14281): Update `Layout/EndAlignment` with `EnforcedStyleAlignWith: variable` to handle conditionals inside `begin` nodes properly. ([@dvandersluis][])

### Changes

* [#14662](https://github.com/rubocop/rubocop/pull/14662): Add autocorrection for `Lint/UselessOr`. ([@r7kamura][])
* [#14668](https://github.com/rubocop/rubocop/pull/14668): Exclude `Severity` from configuration parameters. ([@r7kamura][])
* [#14684](https://github.com/rubocop/rubocop/issues/14684): Make `Style/CaseEquality` allow regexp case equality where the receiver is a regexp literal. ([@koic][])
* [#14645](https://github.com/rubocop/rubocop/pull/14645): Change `Lint/CircularArgumentReference` to detect offenses within long assignment chains. ([@viralpraxis][])
* [#14642](https://github.com/rubocop/rubocop/pull/14642): Make `Gemspec/RubyVersionGlobalsUsage` aware of `Ruby::VERSION`. ([@koic][])
* [#14695](https://github.com/rubocop/rubocop/issues/14695): Make `Layout/EmptyLineAfterMagicComment` aware of `# rbs_inline` magic comment. ([@koic][])
* [#10147](https://github.com/rubocop/rubocop/issues/10147): Make `Lint/ElseLayout` allow a single-line `else` body in `then` single-line conditional. ([@koic][])
* [#14661](https://github.com/rubocop/rubocop/pull/14661): Make `Lint/RedundantRequireStatement` aware of `pathname` when analyzing Ruby 4.0. ([@koic][])
* [#14698](https://github.com/rubocop/rubocop/pull/14698): Make `Lint/UnreachableCode` aware of singleton method redefinition. ([@koic][])
* [#14677](https://github.com/rubocop/rubocop/pull/14677): Make `Style/RedundantArgument` aware of `to_i`. ([@koic][])
* [#14660](https://github.com/rubocop/rubocop/pull/14660): Rename `IgnoreCopDirectives` to `AllowCopDirectives` in `Layout/LineLength`. ([@koic][])
* [#14492](https://github.com/rubocop/rubocop/issues/14492): Revert #14492, which added support for LSP positionEncoding 'utf-8' and 'utf-32' due to critical performance regression reports. ([@koic][])

[@koic]: https://github.com/koic
[@mmenanno]: https://github.com/mmenanno
[@lovro-bikic]: https://github.com/lovro-bikic
[@viralpraxis]: https://github.com/viralpraxis
[@earlopain]: https://github.com/earlopain
[@dvandersluis]: https://github.com/dvandersluis
[@tmtm]: https://github.com/tmtm
[@Jack12816]: https://github.com/Jack12816
[@rscq]: https://github.com/rscq
[@r7kamura]: https://github.com/r7kamura
