use crate::app::App;
use crate::ui::{self, COLOR_NEGATIVE, COLOR_POSITIVE, COLOR_WARNING, SELECTED_STYLE};
use ratatui::{
    prelude::*,
    widgets::{HighlightSpacing, List, ListItem},
};

impl App {
    pub fn render_home(&mut self, area: Rect, buf: &mut Buffer) {
        let block = ui::container();

        let required_threshold = self.config.rules.required_threshold;
        let trusted_rebuilders = self.config.trusted_rebuilders.len();

        let items = vec![
            ListItem::new(Line::from_iter([
                Span::raw("Required reproduction threshold: "),
                Span::styled(
                    required_threshold.to_string(),
                    match required_threshold {
                        0 => COLOR_NEGATIVE,
                        1 => COLOR_WARNING,
                        num if num <= trusted_rebuilders => COLOR_POSITIVE,
                        _ => COLOR_NEGATIVE,
                    },
                ),
                Span::raw("/"),
                Span::raw(format!("{trusted_rebuilders}")),
            ])),
            ListItem::new(format!(
                "Configure trusted rebuilders ({trusted_rebuilders} selected)"
            )),
            ListItem::new(format!(
                "Add/remove packages from 'blindly-trust' set ({} entries)",
                self.config.rules.blindly_trust.len()
            )),
            ListItem::new("Quit"),
        ];

        let list = List::new(items)
            .block(block)
            .highlight_style(SELECTED_STYLE)
            .highlight_symbol("> ")
            .highlight_spacing(HighlightSpacing::Always);

        StatefulWidget::render(&list, area, buf, self.scroll());
    }
}
