/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2026 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/
#include "SDL_config.h"

#include "SDL_test.h"

/* ---- 8x8 font definition ---- */

/*
; Summary: font8_8.asm
; 8x8 monochrome bitmap fonts for rendering
;
; Author:
;     Marcel Sondaar
;     International Business Machines (public domain VGA fonts)
;
; License:
;     Public Domain
;
*/

static unsigned char SDLTest_FontData[] = {

    /*
     * 0 0x00 '^@'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 1 0x01 '^A'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 2 0x02 '^B'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 3 0x03 '^C'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 4 0x04 '^D'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 5 0x05 '^E'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 6 0x06 '^F'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 7 0x07 '^G'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 8 0x08 '^H'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 9 0x09 '^I'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 10 0x0a '^J'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 11 0x0b '^K'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 12 0x0c '^L'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 13 0x0d '^M'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 14 0x0e '^N'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 15 0x0f '^O'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 16 0x10 '^P'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 17 0x11 '^Q'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 18 0x12 '^R'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 19 0x13 '^S'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 20 0x14 '^T'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 21 0x15 '^U'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 22 0x16 '^V'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 23 0x17 '^W'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 24 0x18 '^X'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 25 0x19 '^Y'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 26 0x1a '^Z'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 27 0x1b '^['
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 28 0x1c '^\'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 29 0x1d '^]'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 30 0x1e '^^'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 31 0x1f '^_'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 32 0x20 ' '
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 33 0x21 '!'
     */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 34 0x22 '"'
     */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 35 0x23 '#'
     */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x7f, /* 11111110 */
    0x36, /* 01101100 */
    0x7f, /* 11111110 */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x00, /* 00000000 */

    /*
     * 36 0x24 '$'
     */
    0x0c, /* 00110000 */
    0x3e, /* 01111100 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x1f, /* 11111000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 37 0x25 '%'
     */
    0x00, /* 00000000 */
    0x63, /* 11000110 */
    0x33, /* 11001100 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x66, /* 01100110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 38 0x26 '&'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x6e, /* 01110110 */
    0x3b, /* 11011100 */
    0x33, /* 11001100 */
    0x6e, /* 01110110 */
    0x00, /* 00000000 */

    /*
     * 39 0x27 '''
     */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x03, /* 11000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 40 0x28 '('
     */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x0c, /* 00110000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 41 0x29 ')'
     */
    0x06, /* 01100000 */
    0x0c, /* 00110000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */
    0x00, /* 00000000 */

    /*
     * 42 0x2a '*'
     */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0xff, /* 11111111 */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 43 0x2b '+'
     */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x3f, /* 11111100 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 44 0x2c ','
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */

    /*
     * 45 0x2d '-'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 46 0x2e '.'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 47 0x2f '/'
     */
    0x60, /* 00000110 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */
    0x03, /* 11000000 */
    0x01, /* 10000000 */
    0x00, /* 00000000 */

    /*
     * 48 0x30 '0'
     */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x73, /* 11001110 */
    0x7b, /* 11011110 */
    0x6f, /* 11110110 */
    0x67, /* 11100110 */
    0x3e, /* 01111100 */
    0x00, /* 00000000 */

    /*
     * 49 0x31 '1'
     */
    0x0c, /* 00110000 */
    0x0e, /* 01110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 50 0x32 '2'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x30, /* 00001100 */
    0x1c, /* 00111000 */
    0x06, /* 01100000 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 51 0x33 '3'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x30, /* 00001100 */
    0x1c, /* 00111000 */
    0x30, /* 00001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 52 0x34 '4'
     */
    0x38, /* 00011100 */
    0x3c, /* 00111100 */
    0x36, /* 01101100 */
    0x33, /* 11001100 */
    0x7f, /* 11111110 */
    0x30, /* 00001100 */
    0x78, /* 00011110 */
    0x00, /* 00000000 */

    /*
     * 53 0x35 '5'
     */
    0x3f, /* 11111100 */
    0x03, /* 11000000 */
    0x1f, /* 11111000 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 54 0x36 '6'
     */
    0x1c, /* 00111000 */
    0x06, /* 01100000 */
    0x03, /* 11000000 */
    0x1f, /* 11111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 55 0x37 '7'
     */
    0x3f, /* 11111100 */
    0x33, /* 11001100 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 56 0x38 '8'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 57 0x39 '9'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3e, /* 01111100 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x0e, /* 01110000 */
    0x00, /* 00000000 */

    /*
     * 58 0x3a ':'
     */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 59 0x3b ';'
     */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */

    /*
     * 60 0x3c '<'
     */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */
    0x03, /* 11000000 */
    0x06, /* 01100000 */
    0x0c, /* 00110000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 61 0x3d '='
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 62 0x3e '>'
     */
    0x06, /* 01100000 */
    0x0c, /* 00110000 */
    0x18, /* 00011000 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */
    0x00, /* 00000000 */

    /*
     * 63 0x3f '?'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 64 0x40 '@'
     */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x7b, /* 11011110 */
    0x7b, /* 11011110 */
    0x7b, /* 11011110 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 65 0x41 'A'
     */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */

    /*
     * 66 0x42 'B'
     */
    0x3f, /* 11111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 67 0x43 'C'
     */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x03, /* 11000000 */
    0x03, /* 11000000 */
    0x03, /* 11000000 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */

    /*
     * 68 0x44 'D'
     */
    0x1f, /* 11111000 */
    0x36, /* 01101100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x36, /* 01101100 */
    0x1f, /* 11111000 */
    0x00, /* 00000000 */

    /*
     * 69 0x45 'E'
     */
    0x7f, /* 11111110 */
    0x46, /* 01100010 */
    0x16, /* 01101000 */
    0x1e, /* 01111000 */
    0x16, /* 01101000 */
    0x46, /* 01100010 */
    0x7f, /* 11111110 */
    0x00, /* 00000000 */

    /*
     * 70 0x46 'F'
     */
    0x7f, /* 11111110 */
    0x46, /* 01100010 */
    0x16, /* 01101000 */
    0x1e, /* 01111000 */
    0x16, /* 01101000 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */
    0x00, /* 00000000 */

    /*
     * 71 0x47 'G'
     */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x03, /* 11000000 */
    0x03, /* 11000000 */
    0x73, /* 11001110 */
    0x66, /* 01100110 */
    0x7c, /* 00111110 */
    0x00, /* 00000000 */

    /*
     * 72 0x48 'H'
     */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */

    /*
     * 73 0x49 'I'
     */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 74 0x4a 'J'
     */
    0x78, /* 00011110 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 75 0x4b 'K'
     */
    0x67, /* 11100110 */
    0x66, /* 01100110 */
    0x36, /* 01101100 */
    0x1e, /* 01111000 */
    0x36, /* 01101100 */
    0x66, /* 01100110 */
    0x67, /* 11100110 */
    0x00, /* 00000000 */

    /*
     * 76 0x4c 'L'
     */
    0x0f, /* 11110000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x46, /* 01100010 */
    0x66, /* 01100110 */
    0x7f, /* 11111110 */
    0x00, /* 00000000 */

    /*
     * 77 0x4d 'M'
     */
    0x63, /* 11000110 */
    0x77, /* 11101110 */
    0x7f, /* 11111110 */
    0x7f, /* 11111110 */
    0x6b, /* 11010110 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 78 0x4e 'N'
     */
    0x63, /* 11000110 */
    0x67, /* 11100110 */
    0x6f, /* 11110110 */
    0x7b, /* 11011110 */
    0x73, /* 11001110 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 79 0x4f 'O'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x00, /* 00000000 */

    /*
     * 80 0x50 'P'
     */
    0x3f, /* 11111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */
    0x00, /* 00000000 */

    /*
     * 81 0x51 'Q'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3b, /* 11011100 */
    0x1e, /* 01111000 */
    0x38, /* 00011100 */
    0x00, /* 00000000 */

    /*
     * 82 0x52 'R'
     */
    0x3f, /* 11111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x36, /* 01101100 */
    0x66, /* 01100110 */
    0x67, /* 11100110 */
    0x00, /* 00000000 */

    /*
     * 83 0x53 'S'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x07, /* 11100000 */
    0x0e, /* 01110000 */
    0x38, /* 00011100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 84 0x54 'T'
     */
    0x3f, /* 11111100 */
    0x2d, /* 10110100 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 85 0x55 'U'
     */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 86 0x56 'V'
     */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 87 0x57 'W'
     */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x6b, /* 11010110 */
    0x7f, /* 11111110 */
    0x77, /* 11101110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 88 0x58 'X'
     */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 89 0x59 'Y'
     */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 90 0x5a 'Z'
     */
    0x7f, /* 11111110 */
    0x63, /* 11000110 */
    0x31, /* 10001100 */
    0x18, /* 00011000 */
    0x4c, /* 00110010 */
    0x66, /* 01100110 */
    0x7f, /* 11111110 */
    0x00, /* 00000000 */

    /*
     * 91 0x5b '['
     */
    0x1e, /* 01111000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 92 0x5c '\'
     */
    0x03, /* 11000000 */
    0x06, /* 01100000 */
    0x0c, /* 00110000 */
    0x18, /* 00011000 */
    0x30, /* 00001100 */
    0x60, /* 00000110 */
    0x40, /* 00000010 */
    0x00, /* 00000000 */

    /*
     * 93 0x5d ']'
     */
    0x1e, /* 01111000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 94 0x5e '^'
     */
    0x08, /* 00010000 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 95 0x5f '_'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xff, /* 11111111 */

    /*
     * 96 0x60 '`'
     */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 97 0x61 'a'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x6e, /* 01110110 */
    0x00, /* 00000000 */

    /*
     * 98 0x62 'b'
     */
    0x07, /* 11100000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x3e, /* 01111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3b, /* 11011100 */
    0x00, /* 00000000 */

    /*
     * 99 0x63 'c'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x03, /* 11000000 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 100 0x64 'd'
     */
    0x38, /* 00011100 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x6e, /* 01110110 */
    0x00, /* 00000000 */

    /*
     * 101 0x65 'e'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 102 0x66 'f'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */
    0x06, /* 01100000 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */
    0x00, /* 00000000 */

    /*
     * 103 0x67 'g'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x6e, /* 01110110 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3e, /* 01111100 */
    0x30, /* 00001100 */
    0x1f, /* 11111000 */

    /*
     * 104 0x68 'h'
     */
    0x07, /* 11100000 */
    0x06, /* 01100000 */
    0x36, /* 01101100 */
    0x6e, /* 01110110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x67, /* 11100110 */
    0x00, /* 00000000 */

    /*
     * 105 0x69 'i'
     */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x0e, /* 01110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 106 0x6a 'j'
     */
    0x30, /* 00001100 */
    0x00, /* 00000000 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */

    /*
     * 107 0x6b 'k'
     */
    0x07, /* 11100000 */
    0x06, /* 01100000 */
    0x66, /* 01100110 */
    0x36, /* 01101100 */
    0x1e, /* 01111000 */
    0x36, /* 01101100 */
    0x67, /* 11100110 */
    0x00, /* 00000000 */

    /*
     * 108 0x6c 'l'
     */
    0x0e, /* 01110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 109 0x6d 'm'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x7f, /* 11111110 */
    0x7f, /* 11111110 */
    0x6b, /* 11010110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 110 0x6e 'n'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x1f, /* 11111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */

    /*
     * 111 0x6f 'o'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 112 0x70 'p'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3b, /* 11011100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */

    /*
     * 113 0x71 'q'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x6e, /* 01110110 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3e, /* 01111100 */
    0x30, /* 00001100 */
    0x78, /* 00011110 */

    /*
     * 114 0x72 'r'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3b, /* 11011100 */
    0x6e, /* 01110110 */
    0x66, /* 01100110 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */
    0x00, /* 00000000 */

    /*
     * 115 0x73 's'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3e, /* 01111100 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x1f, /* 11111000 */
    0x00, /* 00000000 */

    /*
     * 116 0x74 't'
     */
    0x08, /* 00010000 */
    0x0c, /* 00110000 */
    0x3e, /* 01111100 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x2c, /* 00110100 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 117 0x75 'u'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x6e, /* 01110110 */
    0x00, /* 00000000 */

    /*
     * 118 0x76 'v'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */

    /*
     * 119 0x77 'w'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x63, /* 11000110 */
    0x6b, /* 11010110 */
    0x7f, /* 11111110 */
    0x7f, /* 11111110 */
    0x36, /* 01101100 */
    0x00, /* 00000000 */

    /*
     * 120 0x78 'x'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x63, /* 11000110 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 121 0x79 'y'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3e, /* 01111100 */
    0x30, /* 00001100 */
    0x1f, /* 11111000 */

    /*
     * 122 0x7a 'z'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x19, /* 10011000 */
    0x0c, /* 00110000 */
    0x26, /* 01100100 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 123 0x7b '{'
     */
    0x38, /* 00011100 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x07, /* 11100000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x38, /* 00011100 */
    0x00, /* 00000000 */

    /*
     * 124 0x7c '|'
     */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 125 0x7d '}'
     */
    0x07, /* 11100000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x38, /* 00011100 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x07, /* 11100000 */
    0x00, /* 00000000 */

    /*
     * 126 0x7e '~'
     */
    0x6e, /* 01110110 */
    0x3b, /* 11011100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 127 0x7f '^?'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 128 0x80 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 129 0x81 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 130 0x82 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 131 0x83 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 132 0x84 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 133 0x85 '
'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 134 0x86 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 135 0x87 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 136 0x88 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 137 0x89 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 138 0x8a ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 139 0x8b ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 140 0x8c ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 141 0x8d ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 142 0x8e ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 143 0x8f ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 144 0x90 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 145 0x91 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 146 0x92 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 147 0x93 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 148 0x94 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 149 0x95 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 150 0x96 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 151 0x97 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 152 0x98 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 153 0x99 ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 154 0x9a ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 155 0x9b ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 156 0x9c ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 157 0x9d ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 158 0x9e ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 159 0x9f ''
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 160 0xa0 ' '
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 161 0xa1 '¡'
     */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 162 0xa2 '¢'
     */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x7e, /* 01111110 */
    0x03, /* 11000000 */
    0x03, /* 11000000 */
    0x7e, /* 01111110 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */

    /*
     * 163 0xa3 '£'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x26, /* 01100100 */
    0x0f, /* 11110000 */
    0x06, /* 01100000 */
    0x67, /* 11100110 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 164 0xa4 '¤'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x63, /* 11000110 */
    0x3e, /* 01111100 */
    0x36, /* 01101100 */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 165 0xa5 '¥'
     */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x3f, /* 11111100 */
    0x0c, /* 00110000 */
    0x3f, /* 11111100 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */

    /*
     * 166 0xa6 '¦'
     */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 167 0xa7 '§'
     */
    0x7c, /* 00111110 */
    0xc6, /* 01100011 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */

    /*
     * 168 0xa8 '¨'
     */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 169 0xa9 '©'
     */
    0x3c, /* 00111100 */
    0x42, /* 01000010 */
    0x99, /* 10011001 */
    0x85, /* 10100001 */
    0x85, /* 10100001 */
    0x99, /* 10011001 */
    0x42, /* 01000010 */
    0x3c, /* 00111100 */

    /*
     * 170 0xaa 'ª'
     */
    0x3c, /* 00111100 */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x7c, /* 00111110 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 171 0xab '«'
     */
    0x00, /* 00000000 */
    0xcc, /* 00110011 */
    0x66, /* 01100110 */
    0x33, /* 11001100 */
    0x66, /* 01100110 */
    0xcc, /* 00110011 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 172 0xac '¬'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x30, /* 00001100 */
    0x30, /* 00001100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 173 0xad '­'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 174 0xae '®'
     */
    0x3c, /* 00111100 */
    0x42, /* 01000010 */
    0x9d, /* 10111001 */
    0xa5, /* 10100101 */
    0x9d, /* 10111001 */
    0xa5, /* 10100101 */
    0x42, /* 01000010 */
    0x3c, /* 00111100 */

    /*
     * 175 0xaf '¯'
     */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 176 0xb0 '°'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 177 0xb1 '±'
     */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x7e, /* 01111110 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 178 0xb2 '²'
     */
    0x1c, /* 00111000 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 179 0xb3 '³'
     */
    0x1c, /* 00111000 */
    0x30, /* 00001100 */
    0x18, /* 00011000 */
    0x30, /* 00001100 */
    0x1c, /* 00111000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 180 0xb4 '´'
     */
    0x18, /* 00011000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 181 0xb5 'µ'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x06, /* 01100000 */
    0x03, /* 11000000 */

    /*
     * 182 0xb6 '¶'
     */
    0xfe, /* 01111111 */
    0xdb, /* 11011011 */
    0xdb, /* 11011011 */
    0xde, /* 01111011 */
    0xd8, /* 00011011 */
    0xd8, /* 00011011 */
    0xd8, /* 00011011 */
    0x00, /* 00000000 */

    /*
     * 183 0xb7 '·'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 184 0xb8 '¸'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x30, /* 00001100 */
    0x1e, /* 01111000 */

    /*
     * 185 0xb9 '¹'
     */
    0x08, /* 00010000 */
    0x0c, /* 00110000 */
    0x08, /* 00010000 */
    0x1c, /* 00111000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 186 0xba 'º'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 187 0xbb '»'
     */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x66, /* 01100110 */
    0xcc, /* 00110011 */
    0x66, /* 01100110 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 188 0xbc '¼'
     */
    0xc3, /* 11000011 */
    0x63, /* 11000110 */
    0x33, /* 11001100 */
    0xbd, /* 10111101 */
    0xec, /* 00110111 */
    0xf6, /* 01101111 */
    0xf3, /* 11001111 */
    0x03, /* 11000000 */

    /*
     * 189 0xbd '½'
     */
    0xc3, /* 11000011 */
    0x63, /* 11000110 */
    0x33, /* 11001100 */
    0x7b, /* 11011110 */
    0xcc, /* 00110011 */
    0x66, /* 01100110 */
    0x33, /* 11001100 */
    0xf0, /* 00001111 */

    /*
     * 190 0xbe '¾'
     */
    0x03, /* 11000000 */
    0xc4, /* 00100011 */
    0x63, /* 11000110 */
    0xb4, /* 00101101 */
    0xdb, /* 11011011 */
    0xac, /* 00110101 */
    0xe6, /* 01100111 */
    0x80, /* 00000001 */

    /*
     * 191 0xbf '¿'
     */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x0c, /* 00110000 */
    0x06, /* 01100000 */
    0x03, /* 11000000 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 192 0xc0 'À'
     */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x7f, /* 11111110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 193 0xc1 'Á'
     */
    0x70, /* 00001110 */
    0x00, /* 00000000 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x7f, /* 11111110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 194 0xc2 'Â'
     */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x00, /* 00000000 */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x7f, /* 11111110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 195 0xc3 'Ã'
     */
    0x6e, /* 01110110 */
    0x3b, /* 11011100 */
    0x00, /* 00000000 */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x7f, /* 11111110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 196 0xc4 'Ä'
     */
    0x63, /* 11000110 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x63, /* 11000110 */
    0x7f, /* 11111110 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x00, /* 00000000 */

    /*
     * 197 0xc5 'Å'
     */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */

    /*
     * 198 0xc6 'Æ'
     */
    0x7c, /* 00111110 */
    0x36, /* 01101100 */
    0x33, /* 11001100 */
    0x7f, /* 11111110 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x73, /* 11001110 */
    0x00, /* 00000000 */

    /*
     * 199 0xc7 'Ç'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x03, /* 11000000 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x18, /* 00011000 */
    0x30, /* 00001100 */
    0x1e, /* 01111000 */

    /*
     * 200 0xc8 'È'
     */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x06, /* 01100000 */
    0x1e, /* 01111000 */
    0x06, /* 01100000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 201 0xc9 'É'
     */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x06, /* 01100000 */
    0x1e, /* 01111000 */
    0x06, /* 01100000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 202 0xca 'Ê'
     */
    0x0c, /* 00110000 */
    0x12, /* 01001000 */
    0x3f, /* 11111100 */
    0x06, /* 01100000 */
    0x1e, /* 01111000 */
    0x06, /* 01100000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 203 0xcb 'Ë'
     */
    0x36, /* 01101100 */
    0x00, /* 00000000 */
    0x3f, /* 11111100 */
    0x06, /* 01100000 */
    0x1e, /* 01111000 */
    0x06, /* 01100000 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 204 0xcc 'Ì'
     */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 205 0xcd 'Í'
     */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 206 0xce 'Î'
     */
    0x0c, /* 00110000 */
    0x12, /* 01001000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 207 0xcf 'Ï'
     */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 208 0xd0 'Ð'
     */
    0x3f, /* 11111100 */
    0x66, /* 01100110 */
    0x6f, /* 11110110 */
    0x6f, /* 11110110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */

    /*
     * 209 0xd1 'Ñ'
     */
    0x3f, /* 11111100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x37, /* 11101100 */
    0x3f, /* 11111100 */
    0x3b, /* 11011100 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */

    /*
     * 210 0xd2 'Ò'
     */
    0x0e, /* 01110000 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 211 0xd3 'Ó'
     */
    0x70, /* 00001110 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 212 0xd4 'Ô'
     */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 213 0xd5 'Õ'
     */
    0x6e, /* 01110110 */
    0x3b, /* 11011100 */
    0x00, /* 00000000 */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x63, /* 11000110 */
    0x3e, /* 01111100 */
    0x00, /* 00000000 */

    /*
     * 214 0xd6 'Ö'
     */
    0xc3, /* 11000011 */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 215 0xd7 '×'
     */
    0x00, /* 00000000 */
    0x36, /* 01101100 */
    0x1c, /* 00111000 */
    0x08, /* 00010000 */
    0x1c, /* 00111000 */
    0x36, /* 01101100 */
    0x00, /* 00000000 */
    0x00, /* 00000000 */

    /*
     * 216 0xd8 'Ø'
     */
    0x5c, /* 00111010 */
    0x36, /* 01101100 */
    0x73, /* 11001110 */
    0x7b, /* 11011110 */
    0x6f, /* 11110110 */
    0x36, /* 01101100 */
    0x1d, /* 10111000 */
    0x00, /* 00000000 */

    /*
     * 217 0xd9 'Ù'
     */
    0x0e, /* 01110000 */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */

    /*
     * 218 0xda 'Ú'
     */
    0x70, /* 00001110 */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */

    /*
     * 219 0xdb 'Û'
     */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */

    /*
     * 220 0xdc 'Ü'
     */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 221 0xdd 'Ý'
     */
    0x70, /* 00001110 */
    0x00, /* 00000000 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3c, /* 00111100 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 222 0xde 'Þ'
     */
    0x0f, /* 11110000 */
    0x06, /* 01100000 */
    0x3e, /* 01111100 */
    0x66, /* 01100110 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x06, /* 01100000 */
    0x0f, /* 11110000 */

    /*
     * 223 0xdf 'ß'
     */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x1f, /* 11111000 */
    0x33, /* 11001100 */
    0x1f, /* 11111000 */
    0x03, /* 11000000 */
    0x03, /* 11000000 */

    /*
     * 224 0xe0 'à'
     */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 225 0xe1 'á'
     */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 226 0xe2 'â'
     */
    0x7e, /* 01111110 */
    0xc3, /* 11000011 */
    0x3c, /* 00111100 */
    0x60, /* 00000110 */
    0x7c, /* 00111110 */
    0x66, /* 01100110 */
    0xfc, /* 00111111 */
    0x00, /* 00000000 */

    /*
     * 227 0xe3 'ã'
     */
    0x6e, /* 01110110 */
    0x3b, /* 11011100 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 228 0xe4 'ä'
     */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 229 0xe5 'å'
     */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 230 0xe6 'æ'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0xfe, /* 01111111 */
    0x30, /* 00001100 */
    0xfe, /* 01111111 */
    0x33, /* 11001100 */
    0xfe, /* 01111111 */
    0x00, /* 00000000 */

    /*
     * 231 0xe7 'ç'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x03, /* 11000000 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x30, /* 00001100 */
    0x1c, /* 00111000 */

    /*
     * 232 0xe8 'è'
     */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 233 0xe9 'é'
     */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 234 0xea 'ê'
     */
    0x7e, /* 01111110 */
    0xc3, /* 11000011 */
    0x3c, /* 00111100 */
    0x66, /* 01100110 */
    0x7e, /* 01111110 */
    0x06, /* 01100000 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */

    /*
     * 235 0xeb 'ë'
     */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x3f, /* 11111100 */
    0x03, /* 11000000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 236 0xec 'ì'
     */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x0e, /* 01110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 237 0xed 'í'
     */
    0x1c, /* 00111000 */
    0x00, /* 00000000 */
    0x0e, /* 01110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 238 0xee 'î'
     */
    0x3e, /* 01111100 */
    0x63, /* 11000110 */
    0x1c, /* 00111000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x3c, /* 00111100 */
    0x00, /* 00000000 */

    /*
     * 239 0xef 'ï'
     */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x0e, /* 01110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x0c, /* 00110000 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 240 0xf0 'ð'
     */
    0x1b, /* 11011000 */
    0x0e, /* 01110000 */
    0x1b, /* 11011000 */
    0x30, /* 00001100 */
    0x3e, /* 01111100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 241 0xf1 'ñ'
     */
    0x00, /* 00000000 */
    0x1f, /* 11111000 */
    0x00, /* 00000000 */
    0x1f, /* 11111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */

    /*
     * 242 0xf2 'ò'
     */
    0x00, /* 00000000 */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 243 0xf3 'ó'
     */
    0x00, /* 00000000 */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 244 0xf4 'ô'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 245 0xf5 'õ'
     */
    0x6e, /* 01110110 */
    0x3b, /* 11011100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 246 0xf6 'ö'
     */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x1e, /* 01111000 */
    0x00, /* 00000000 */

    /*
     * 247 0xf7 '÷'
     */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */
    0x18, /* 00011000 */
    0x18, /* 00011000 */
    0x00, /* 00000000 */

    /*
     * 248 0xf8 'ø'
     */
    0x00, /* 00000000 */
    0x60, /* 00000110 */
    0x3c, /* 00111100 */
    0x76, /* 01101110 */
    0x7e, /* 01111110 */
    0x6e, /* 01110110 */
    0x3c, /* 00111100 */
    0x06, /* 01100000 */

    /*
     * 249 0xf9 'ù'
     */
    0x00, /* 00000000 */
    0x07, /* 11100000 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 250 0xfa 'ú'
     */
    0x00, /* 00000000 */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 251 0xfb 'û'
     */
    0x1e, /* 01111000 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 252 0xfc 'ü'
     */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x7e, /* 01111110 */
    0x00, /* 00000000 */

    /*
     * 253 0xfd 'ý'
     */
    0x00, /* 00000000 */
    0x38, /* 00011100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3e, /* 01111100 */
    0x30, /* 00001100 */
    0x1f, /* 11111000 */

    /*
     * 254 0xfe 'þ'
     */
    0x00, /* 00000000 */
    0x00, /* 00000000 */
    0x06, /* 01100000 */
    0x3e, /* 01111100 */
    0x66, /* 01100110 */
    0x3e, /* 01111100 */
    0x06, /* 01100000 */
    0x00, /* 00000000 */

    /*
     * 255 0xff 'ÿ'
     */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x00, /* 00000000 */
    0x33, /* 11001100 */
    0x33, /* 11001100 */
    0x3e, /* 01111100 */
    0x30, /* 00001100 */
    0x1f, /* 11111000 */

};

/* ---- Character */

struct SDLTest_CharTextureCache
{
    SDL_Renderer *renderer;
    SDL_Texture *charTextureCache[256];
    struct SDLTest_CharTextureCache *next;
};

/*!
\brief List of per-renderer caches for 8x8 pixel font textures created at runtime.
*/
static struct SDLTest_CharTextureCache *SDLTest_CharTextureCacheList;

int SDLTest_DrawCharacter(SDL_Renderer *renderer, int x, int y, Uint32 c)
{
    const Uint32 charWidth = FONT_CHARACTER_SIZE;
    const Uint32 charHeight = FONT_CHARACTER_SIZE;
    const Uint32 charSize = FONT_CHARACTER_SIZE;
    SDL_Rect srect;
    SDL_Rect drect;
    int result;
    Uint32 ix, iy;
    const unsigned char *charpos;
    Uint32 *curpos;
    Uint8 *linepos;
    Uint32 pitch;
    SDL_Surface *character;
    Uint32 ci;
    Uint8 r, g, b, a;
    struct SDLTest_CharTextureCache *cache;

    /*
     * Setup source rectangle
     */
    srect.x = 0;
    srect.y = 0;
    srect.w = charWidth;
    srect.h = charHeight;

    /*
     * Setup destination rectangle
     */
    drect.x = x;
    drect.y = y;
    drect.w = charWidth;
    drect.h = charHeight;

    /* Character index in cache */
    ci = c;

    /* Search for this renderer's cache */
    for (cache = SDLTest_CharTextureCacheList; cache; cache = cache->next) {
        if (cache->renderer == renderer) {
            break;
        }
    }

    /* Allocate a new cache for this renderer if needed */
    if (!cache) {
        cache = (struct SDLTest_CharTextureCache *)SDL_calloc(1, sizeof(struct SDLTest_CharTextureCache));
        cache->renderer = renderer;
        cache->next = SDLTest_CharTextureCacheList;
        SDLTest_CharTextureCacheList = cache;
    }

    /*
     * Create new charWidth x charHeight bitmap surface if not already present.
     */
    if (cache->charTextureCache[ci] == NULL) {
        /*
         * Redraw character into surface
         */
        character = SDL_CreateRGBSurface(SDL_SWSURFACE,
            charWidth, charHeight, 32,
            0xFF000000, 0x00FF0000, 0x0000FF00, 0x000000FF);
        if (!character) {
            return -1;
        }

        charpos = SDLTest_FontData + ci * charSize;
        linepos = (Uint8 *)character->pixels;
        pitch = character->pitch;

        /*
         * Drawing loop
         */
        for (iy = 0; iy < charWidth; iy++) {
            curpos = (Uint32 *)linepos;
            for (ix = 0; ix < charWidth; ix++) {
                if ((*charpos) & (1 << ix)) {
                    *curpos = 0xffffffff;
                } else {
                    *curpos = 0;
                }
                ++curpos;
            }
            linepos += pitch;
            ++charpos;
        }

        /* Convert temp surface into texture */
        cache->charTextureCache[ci] = SDL_CreateTextureFromSurface(renderer, character);
        SDL_FreeSurface(character);

        /*
         * Check pointer
         */
        if (cache->charTextureCache[ci] == NULL) {
            return -1;
        }
    }

    /*
     * Set color
     */
    result = 0;
    result |= SDL_GetRenderDrawColor(renderer, &r, &g, &b, &a);
    result |= SDL_SetTextureColorMod(cache->charTextureCache[ci], r, g, b);
    result |= SDL_SetTextureAlphaMod(cache->charTextureCache[ci], a);

    /*
     * Draw texture onto destination
     */
    result |= SDL_RenderCopy(renderer, cache->charTextureCache[ci], &srect, &drect);

    return result;
}

/* Gets a unicode value from a UTF-8 encoded string
 * Outputs increment to advance the string */
#define UNKNOWN_UNICODE 0xFFFD
static Uint32 UTF8_getch(const char *src, size_t srclen, int *inc)
{
    const Uint8 *p = (const Uint8 *)src;
    size_t left = 0;
    size_t save_srclen = srclen;
    SDL_bool overlong = SDL_FALSE;
    SDL_bool underflow = SDL_FALSE;
    Uint32 ch = UNKNOWN_UNICODE;

    if (srclen == 0) {
        return UNKNOWN_UNICODE;
    }
    if (p[0] >= 0xFC) {
        if ((p[0] & 0xFE) == 0xFC) {
            if (p[0] == 0xFC && (p[1] & 0xFC) == 0x80) {
                overlong = SDL_TRUE;
            }
            ch = (Uint32)(p[0] & 0x01);
            left = 5;
        }
    } else if (p[0] >= 0xF8) {
        if ((p[0] & 0xFC) == 0xF8) {
            if (p[0] == 0xF8 && (p[1] & 0xF8) == 0x80) {
                overlong = SDL_TRUE;
            }
            ch = (Uint32)(p[0] & 0x03);
            left = 4;
        }
    } else if (p[0] >= 0xF0) {
        if ((p[0] & 0xF8) == 0xF0) {
            if (p[0] == 0xF0 && (p[1] & 0xF0) == 0x80) {
                overlong = SDL_TRUE;
            }
            ch = (Uint32)(p[0] & 0x07);
            left = 3;
        }
    } else if (p[0] >= 0xE0) {
        if ((p[0] & 0xF0) == 0xE0) {
            if (p[0] == 0xE0 && (p[1] & 0xE0) == 0x80) {
                overlong = SDL_TRUE;
            }
            ch = (Uint32)(p[0] & 0x0F);
            left = 2;
        }
    } else if (p[0] >= 0xC0) {
        if ((p[0] & 0xE0) == 0xC0) {
            if ((p[0] & 0xDE) == 0xC0) {
                overlong = SDL_TRUE;
            }
            ch = (Uint32)(p[0] & 0x1F);
            left = 1;
        }
    } else {
        if (!(p[0] & 0x80)) {
            ch = (Uint32)p[0];
        }
    }
    --srclen;
    while (left > 0 && srclen > 0) {
        ++p;
        if ((p[0] & 0xC0) != 0x80) {
            ch = UNKNOWN_UNICODE;
            break;
        }
        ch <<= 6;
        ch |= (p[0] & 0x3F);
        --srclen;
        --left;
    }
    if (left > 0) {
        underflow = SDL_TRUE;
    }

    if (overlong || underflow ||
        (ch >= 0xD800 && ch <= 0xDFFF) ||
        (ch == 0xFFFE || ch == 0xFFFF) || ch > 0x10FFFF) {
        ch = UNKNOWN_UNICODE;
    }

    *inc = (int)(save_srclen - srclen);

    return ch;
}

#define UTF8_IsTrailingByte(c) ((c) >= 0x80 && (c) <= 0xBF)

int SDLTest_DrawString(SDL_Renderer *renderer, int x, int y, const char *s)
{
    const Uint32 charWidth = FONT_CHARACTER_SIZE;
    int result = 0;
    int curx = x;
    int cury = y;
    size_t len = SDL_strlen(s);

    while (len > 0 && !result) {
        int advance = 0;
        Uint32 ch = UTF8_getch(s, len, &advance);
        if (ch < 256) {
            result |= SDLTest_DrawCharacter(renderer, curx, cury, ch);
        }
        curx += charWidth;
        s += advance;
        len -= advance;
    }

    return result;
}

SDLTest_TextWindow *SDLTest_TextWindowCreate(int x, int y, int w, int h)
{
    SDLTest_TextWindow *textwin = (SDLTest_TextWindow *)SDL_malloc(sizeof(*textwin));

    if (!textwin) {
        return NULL;
    }

    textwin->rect.x = x;
    textwin->rect.y = y;
    textwin->rect.w = w;
    textwin->rect.h = h;
    textwin->current = 0;
    textwin->numlines = (h / FONT_LINE_HEIGHT);
    textwin->lines = (char **)SDL_calloc(textwin->numlines, sizeof(*textwin->lines));
    if (!textwin->lines) {
        SDL_free(textwin);
        return NULL;
    }
    return textwin;
}

void SDLTest_TextWindowDisplay(SDLTest_TextWindow *textwin, SDL_Renderer *renderer)
{
    int i, y;

    for (y = textwin->rect.y, i = 0; i < textwin->numlines; ++i, y += FONT_LINE_HEIGHT) {
        if (textwin->lines[i]) {
            SDLTest_DrawString(renderer, textwin->rect.x, y, textwin->lines[i]);
        }
    }
}

void SDLTest_TextWindowAddText(SDLTest_TextWindow *textwin, const char *fmt, ...)
{
    char text[1024];
    va_list ap;

    va_start(ap, fmt);
    (void)SDL_vsnprintf(text, sizeof(text), fmt, ap);
    va_end(ap);

    SDLTest_TextWindowAddTextWithLength(textwin, text, SDL_strlen(text));
}

void SDLTest_TextWindowAddTextWithLength(SDLTest_TextWindow *textwin, const char *text, size_t len)
{
    size_t existing;
    SDL_bool newline = SDL_FALSE;
    char *line;

    if (len > 0 && text[len - 1] == '\n') {
        --len;
        newline = SDL_TRUE;
    }

    if (textwin->lines[textwin->current]) {
        existing = SDL_strlen(textwin->lines[textwin->current]);
    } else {
        existing = 0;
    }

    if (*text == '\b') {
        if (existing) {
            while (existing > 1 && UTF8_IsTrailingByte((Uint8)textwin->lines[textwin->current][existing - 1])) {
                --existing;
            }
            --existing;
            textwin->lines[textwin->current][existing] = '\0';
        } else if (textwin->current > 0) {
            SDL_free(textwin->lines[textwin->current]);
            textwin->lines[textwin->current] = NULL;
            --textwin->current;
        }
        return;
    }

    line = (char *)SDL_realloc(textwin->lines[textwin->current], existing + len + 1);
    if (line) {
        SDL_memcpy(&line[existing], text, len);
        line[existing + len] = '\0';
        textwin->lines[textwin->current] = line;
        if (newline) {
            if (textwin->current == textwin->numlines - 1) {
                SDL_free(textwin->lines[0]);
                SDL_memcpy(&textwin->lines[0], &textwin->lines[1], (textwin->numlines - 1) * sizeof(textwin->lines[1]));
                textwin->lines[textwin->current] = NULL;
            } else {
                ++textwin->current;
            }
        }
    }
}

void SDLTest_TextWindowClear(SDLTest_TextWindow *textwin)
{
    int i;

    for (i = 0; i < textwin->numlines; ++i) {
        if (textwin->lines[i]) {
            SDL_free(textwin->lines[i]);
            textwin->lines[i] = NULL;
        }
    }
    textwin->current = 0;
}

void SDLTest_TextWindowDestroy(SDLTest_TextWindow *textwin)
{
    if (textwin) {
        SDLTest_TextWindowClear(textwin);
        SDL_free(textwin->lines);
        SDL_free(textwin);
    }
}

void SDLTest_CleanupTextDrawing(void)
{
    unsigned int i;
    struct SDLTest_CharTextureCache *cache, *next;

    cache = SDLTest_CharTextureCacheList;
    while (cache) {
        for (i = 0; i < SDL_arraysize(cache->charTextureCache); ++i) {
            if (cache->charTextureCache[i]) {
                SDL_DestroyTexture(cache->charTextureCache[i]);
                cache->charTextureCache[i] = NULL;
            }
        }

        next = cache->next;
        SDL_free(cache);
        cache = next;
    }

    SDLTest_CharTextureCacheList = NULL;
}

/* vi: set ts=4 sw=4 expandtab: */
