/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import java.util.Vector;
import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.TokenConsumer;

class DeclarationParser
extends TokenConsumer {
    static final String[] NO_ARGS = new String[0];
    static final int UNKNOWN_ARITY = -2;
    static final int MAX_ARITY = 5;
    String name;
    int arity = -2;
    Vector args = new Vector();
    private SyntaxException exception;

    DeclarationParser(SyntaxException syntaxException) {
        this.exception = syntaxException;
    }

    void start() {
        this.name = null;
        this.args.setSize(0);
    }

    void push(Token token) throws SyntaxException {
        switch (token.id) {
            case 11: {
                if (this.name == null) {
                    this.name = token.name;
                    this.arity = 0;
                    break;
                }
                throw this.exception.set("repeated CALL in declaration", token.position);
            }
            case 10: {
                if (this.name == null) {
                    this.name = token.name;
                    this.arity = -2;
                    break;
                }
                if (this.arity >= 0) {
                    this.args.addElement(token.name);
                    ++this.arity;
                    if (this.arity <= 5) break;
                    throw this.exception.set("Arity too large " + this.arity, token.position);
                }
                throw this.exception.set("Invalid declaration", token.position);
            }
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw this.exception.set("invalid token in declaration", token.position);
            }
        }
    }

    String[] argNames() {
        if (this.arity > 0) {
            Object[] objectArray = new String[this.arity];
            this.args.copyInto(objectArray);
            return objectArray;
        }
        return NO_ARGS;
    }
}

