/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Point3i;

class Translation {
    char translationCode = '\u0000';
    int rotationOrder;
    int rotationShift12ths;
    Point3i vectorShift12ths = new Point3i();
    static final String[] latticeTranslationData = new String[]{"\u0000", "unknown", "", "P", "primitive", "", "I", "body-centered", " 1n", "R", "rhombohedral", " 1r 1r", "F", "face-centered", " 1ab 1bc 1ac", "A", "A-centered", " 1bc", "B", "B-centered", " 1ac", "C", "C-centered", " 1ab", "S", "rhombohedral(S)", " 1s 1s", "T", "rhombohedral(T)", " 1t 1t"};
    static final int nLatticeTypes = latticeTranslationData.length / 3 - 1;
    static final Translation[] hallTranslationTerms = new Translation[]{new Translation('a', 0, new Point3i(6, 0, 0)), new Translation('b', 0, new Point3i(0, 6, 0)), new Translation('c', 0, new Point3i(0, 0, 6)), new Translation('n', 0, new Point3i(6, 6, 6)), new Translation('u', 0, new Point3i(3, 0, 0)), new Translation('v', 0, new Point3i(0, 3, 0)), new Translation('w', 0, new Point3i(0, 0, 3)), new Translation('d', 0, new Point3i(3, 3, 3)), new Translation('1', 2, 6), new Translation('1', 3, 4), new Translation('2', 3, 8), new Translation('1', 4, 3), new Translation('3', 4, 9), new Translation('1', 6, 2), new Translation('2', 6, 4), new Translation('4', 6, 8), new Translation('5', 6, 10), new Translation('r', 0, new Point3i(4, 8, 8)), new Translation('s', 0, new Point3i(8, 8, 4)), new Translation('t', 0, new Point3i(8, 4, 8))};

    Translation() {
    }

    Translation(char c, int n) {
        for (int i = 0; i < hallTranslationTerms.length; ++i) {
            Translation translation = hallTranslationTerms[i];
            if (translation.translationCode != c || translation.rotationOrder != 0 && translation.rotationOrder != n) continue;
            this.translationCode = c;
            this.rotationShift12ths = translation.rotationShift12ths;
            this.vectorShift12ths = translation.vectorShift12ths;
            return;
        }
    }

    private Translation(char c, int n, Point3i point3i) {
        this.translationCode = c;
        this.rotationOrder = 0;
        this.rotationShift12ths = 0;
        this.vectorShift12ths = point3i;
    }

    private Translation(char c, int n, int n2) {
        this.translationCode = c;
        this.rotationOrder = n;
        this.rotationShift12ths = n2;
        this.vectorShift12ths = new Point3i();
    }

    static final String getHallLatticeEquivalent(int n) {
        char c = Translation.getLatticeCode(n);
        boolean bl = n > 0;
        return (bl ? "-" : "") + c + " 1";
    }

    static final int getLatticeIndex(char c) {
        int n = 1;
        int n2 = 3;
        while (n <= nLatticeTypes) {
            if (latticeTranslationData[n2].charAt(0) == c) {
                return n;
            }
            ++n;
            n2 += 3;
        }
        return 0;
    }

    static final char getLatticeCode(int n) {
        if (n < 0) {
            n = -n;
        }
        return n == 0 ? (char)'\u0000' : (n > nLatticeTypes ? Translation.getLatticeCode(Translation.getLatticeIndex((char)n)) : latticeTranslationData[n * 3].charAt(0));
    }

    static final String getLatticeDesignation(int n) {
        String string;
        boolean bl = n > 0;
        String string2 = string = bl ? "-" : "";
        if (n < 0) {
            n = -n;
        }
        if (n == 0 || n > nLatticeTypes) {
            return "";
        }
        return string + Translation.getLatticeCode(n) + ": " + (bl ? "centrosymmetric " : "") + latticeTranslationData[n * 3 + 1];
    }

    static final String getLatticeDesignation(char c, boolean bl) {
        int n = Translation.getLatticeIndex(c);
        if (!bl) {
            n = -n;
        }
        return Translation.getLatticeDesignation(n);
    }

    static final String getLatticeExtension(char c, boolean bl) {
        int n = 1;
        int n2 = 3;
        while (n <= nLatticeTypes) {
            if (latticeTranslationData[n2].charAt(0) == c) {
                return latticeTranslationData[n2 + 2] + (bl ? " -1" : "");
            }
            ++n;
            n2 += 3;
        }
        return "";
    }
}

