/* ui.c
 * Defines functions which produce the GUI for GRadio
 */

/* (c) 1998 by Keith Wesolowski (wesolows@cs.unr.edu) 

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <math.h>
#include <gtk/gtk.h>
#include "gradio.h"
#include "pixmaps.h"

/* Constant, unchanging parts of the display */
static GdkPixmap *leftmost_strip;
static GtkWidget *leftmost_strip_gtk;
static GdkPixmap *rightmost_strip;
static GtkWidget *rightmost_strip_gtk;
static GdkPixmap *top_left_strip;
static GtkWidget *top_left_strip_gtk;
static GdkPixmap *bottom_left_strip;
static GtkWidget *bottom_left_strip_gtk;
static GdkPixmap *top_right_strip;
static GtkWidget *top_right_strip_gtk;
static GdkPixmap *bottom_right_strip;
static GtkWidget *bottom_right_strip_gtk;
static GdkPixmap *vertical_strip;
static GtkWidget *vertical_strip_gtk[2];

/* The building blocks of the active display */
static GdkPixmap *small_v;
static GdkPixmap *small_t;
static GdkPixmap *small_m;
static GdkPixmap *small_k;
static GdkPixmap *small_d;
static GdkPixmap *small_f;
static GdkPixmap *small_s;
static GdkPixmap *small_digits[10];
static GdkPixmap *decimal_on;
static GdkPixmap *decimal_off;
static GdkPixmap *large_digits[10];
static GdkPixmap *small_blank;
static GdkPixmap *large_blank;
static GdkPixmap *power_on;
static GdkPixmap *power_off;

static GdkBitmap *small_mask;
static GdkBitmap *large_mask;
static GdkBitmap *decimal_mask;
static GdkBitmap *vertical_strip_mask;
static GdkBitmap *power_mask;

/* The containers for the active display blocks */
static GtkWidget *volume_ind_gtk;
static GtkWidget *volume_digits_gtk[3];
static GtkWidget *tuned_ind_gtk;
static GtkWidget *muted_ind_gtk;
static GtkWidget *if_ind_gtk;
static GtkWidget *empty_ind_gtk;
static GtkWidget *freq_digits_gtk[6];
static GtkWidget *dp_gtk;
static GtkWidget *band_ind_left_gtk;
static GtkWidget *band_ind_right_gtk;
static GtkWidget *memset_ind_gtk;
static GtkWidget *memset_digit_gtk;
static GtkWidget *power;

extern radio_status gr_stat;

GtkWidget *gradio_get_volume_box (GtkWidget *w)
{
    GtkWidget *main_box;
    GtkWidget *button_box;
    GtkWidget *label_box;
    GtkWidget *up_box;
    GtkWidget *down_box;
    GtkWidget *up_button;
    GtkWidget *down_button;

    main_box = gtk_vbox_new (FALSE, 0);
    button_box = gtk_hbox_new (FALSE, 0);
    label_box = xpm_label_box_d (w, gr_volume_xpm, "");
    up_box = xpm_label_box_d (w, gr_up_xpm, "");
    down_box = xpm_label_box_d (w, gr_down_xpm, ""); 

    up_button = gtk_button_new ();
    down_button = gtk_button_new ();
    
    /* Attach the callbacks to the two buttons */
    gtk_signal_connect (GTK_OBJECT (up_button), "pressed",
			GTK_SIGNAL_FUNC (gradio_vol_cb),
			(gpointer) "up");
    gtk_signal_connect (GTK_OBJECT (down_button), "pressed",
			GTK_SIGNAL_FUNC (gradio_vol_cb),
			(gpointer) "down");

    gtk_container_add (GTK_CONTAINER (up_button), up_box);
    gtk_container_add (GTK_CONTAINER (down_button), down_box); 

    gtk_box_pack_start (GTK_BOX (button_box), down_button, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (button_box), up_button, TRUE, FALSE, 0);

    gtk_box_pack_start (GTK_BOX (main_box), label_box, TRUE, FALSE, 4); 
    gtk_box_pack_start (GTK_BOX (main_box), button_box, TRUE, FALSE, 0);

    gtk_widget_show (up_box);
    gtk_widget_show (down_box); 
    gtk_widget_show (up_button);
    gtk_widget_show (down_button);
    gtk_widget_show (label_box);
    gtk_widget_show (button_box);
    
    return main_box;
}

GtkWidget *gradio_get_tuner_box (GtkWidget *w)
{
    GtkWidget *main_box;
    GtkWidget *button_box;
    GtkWidget *label_box;
    GtkWidget *up_box;
    GtkWidget *down_box;
    GtkWidget *up_button;
    GtkWidget *down_button;

    main_box = gtk_vbox_new (FALSE, 0);
    button_box = gtk_hbox_new (FALSE, 0);
    label_box = xpm_label_box_d (w, gr_tuner_xpm, "");
    up_box = xpm_label_box_d (w, gr_up_xpm, "");
    down_box = xpm_label_box_d (w, gr_down_xpm, "");

    up_button = gtk_button_new ();
    down_button = gtk_button_new ();

    gtk_widget_set_name (up_button, "tuner_up");
    gtk_widget_set_name (down_button, "tuner_down");
    
    /* Connect the callbacks for the two buttons */
    gtk_widget_set_events (up_button, GDK_BUTTON_PRESS_MASK);
    gtk_signal_connect (GTK_OBJECT(up_button), "button_press_event",
			GTK_SIGNAL_FUNC (gradio_tuner_cb), NULL);
    gtk_widget_set_events (down_button, GDK_BUTTON_PRESS_MASK);
    gtk_signal_connect (GTK_OBJECT(down_button), "button_press_event",
			GTK_SIGNAL_FUNC (gradio_tuner_cb), NULL);

    gtk_container_add (GTK_CONTAINER (up_button), up_box);
    gtk_container_add (GTK_CONTAINER (down_button), down_box);

    gtk_box_pack_start (GTK_BOX (button_box), down_button, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (button_box), up_button, TRUE, FALSE, 0);

    gtk_box_pack_start (GTK_BOX (main_box), label_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), button_box, TRUE, FALSE, 0);

    gtk_widget_show (up_box);
    gtk_widget_show (down_box);
    gtk_widget_show (up_button);
    gtk_widget_show (down_button);
    gtk_widget_show (label_box);
    gtk_widget_show (button_box);
    
    return main_box;
}

GtkWidget *gradio_get_memory_box (GtkWidget *w)
{
    GtkWidget *main_box;
    GtkWidget *top_box;
    GtkWidget *bottom_box;
    GtkWidget *button[8];
    GtkWidget *button_box[8];
    gint i;

    static char **mem_buttons[] = { gr_mem_1_xpm, gr_mem_2_xpm, gr_mem_3_xpm, 
				    gr_mem_4_xpm, gr_mem_5_xpm, gr_mem_6_xpm, 
				    gr_mem_7_xpm, gr_mem_8_xpm };

    main_box = gtk_vbox_new (FALSE, 0);
    top_box = gtk_hbox_new (FALSE, 0);
    bottom_box = gtk_hbox_new (FALSE, 0);

    /* Process the buttons one at a time: Get the pixmap box, get the button,
     * build the button, register the callback, and add the button to the box.
     */
    for (i=0; i<8; i++) {
	char name[6];
	sprintf (name, "mem_%d", i+1);
	button_box[i] = xpm_label_box_d (w, mem_buttons[i], "");
	gtk_widget_show (button_box[i]);
	button[i] = gtk_button_new ();
	gtk_widget_set_name (button[i], name);
	gtk_container_add (GTK_CONTAINER (button[i]), button_box[i]);

	gtk_widget_set_events (button[i], GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect (GTK_OBJECT(button[i]), "button_press_event",
			    GTK_SIGNAL_FUNC (gradio_memory_cb), NULL);

	gtk_widget_show (button[i]);
	if (i<4)
	    gtk_box_pack_start (GTK_BOX (top_box), button[i],
				TRUE, FALSE, 0);
	else
	    gtk_box_pack_start (GTK_BOX (bottom_box), button[i],
				TRUE, FALSE, 0);
    }
    
    gtk_widget_show (top_box);
    gtk_widget_show (bottom_box);
    
    gtk_box_pack_start (GTK_BOX (main_box), top_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), bottom_box, TRUE, FALSE, 0);

    return main_box;
}

GtkWidget *gradio_get_control_box (GtkWidget *w)
{
    GtkWidget *main_box;
    GtkWidget *power_button;
    GtkWidget *mute_button;
    GtkWidget *mute_box;

    main_box = gtk_vbox_new (FALSE, 0);

    mute_box = xpm_label_box_d (w, gr_mute_xpm, "");
    gtk_widget_show (mute_box);

    power_button = gtk_button_new ();
    mute_button = gtk_button_new ();

    gtk_container_add (GTK_CONTAINER (power_button), power);
    gtk_container_add (GTK_CONTAINER (mute_button), mute_box);
    
    gtk_signal_connect (GTK_OBJECT (power_button), "clicked",
			GTK_SIGNAL_FUNC (gradio_power_cb), NULL);
    gtk_signal_connect (GTK_OBJECT (mute_button), "clicked",
			GTK_SIGNAL_FUNC (gradio_mute_cb), NULL);
			
    gtk_widget_show (power_button);
    gtk_widget_show (mute_button);

    gtk_box_pack_start (GTK_BOX (main_box), power_button,
			FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), mute_button,
			FALSE, FALSE, 0);

    return main_box;
}

GtkWidget *gradio_get_display (GtkWidget *w)
{
    GtkWidget *main_event_box;
    GtkWidget *main_box;
    GtkWidget *left_box;
    GtkWidget *right_box;
    GtkWidget *left_top_box;
    GtkWidget *left_bottom_box;
    GtkWidget *right_top_box;
    GtkWidget *right_bottom_box;
    GtkWidget *menu;
    GtkWidget *menu_item;
    int i;

    main_box = gtk_hbox_new (FALSE, 0);
    left_box = gtk_vbox_new (FALSE, 0);
    right_box = gtk_vbox_new (FALSE, 0);
    left_top_box = gtk_hbox_new (FALSE, 0);
    left_bottom_box = gtk_hbox_new (FALSE, 0);
    right_top_box = gtk_hbox_new (FALSE, 0);
    right_bottom_box = gtk_hbox_new (FALSE, 0);
    gradio_pixmap_inits (w);
    gradio_set_display_from_status (); 

    gtk_box_pack_start (GTK_BOX (left_top_box), volume_ind_gtk, TRUE, FALSE, 
			0);
    for (i=0; i<3; i++)
	gtk_box_pack_start (GTK_BOX (left_top_box), volume_digits_gtk[i], TRUE,
			    FALSE, 0);
    gtk_widget_show (left_top_box);
    gtk_box_pack_start (GTK_BOX (left_bottom_box), tuned_ind_gtk, TRUE, FALSE, 
			0);
    gtk_box_pack_start (GTK_BOX (left_bottom_box), muted_ind_gtk, TRUE, FALSE, 
			0);
    gtk_box_pack_start (GTK_BOX (left_bottom_box), if_ind_gtk, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (left_bottom_box), empty_ind_gtk, TRUE, FALSE, 
			0);
    gtk_widget_show (left_bottom_box);
    gtk_box_pack_start (GTK_BOX (left_box), top_left_strip_gtk, TRUE, FALSE, 
			0);
    gtk_box_pack_start (GTK_BOX (left_box), left_top_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (left_box), left_bottom_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (left_box), bottom_left_strip_gtk, TRUE, FALSE,
			0);
    gtk_widget_show (left_box);
    gtk_box_pack_start (GTK_BOX (right_top_box), band_ind_left_gtk, TRUE, 
			FALSE, 0);
    gtk_box_pack_start (GTK_BOX (right_top_box), band_ind_right_gtk, TRUE, 
			FALSE, 0);
    gtk_widget_show (right_top_box);
    gtk_box_pack_start (GTK_BOX (right_bottom_box), memset_ind_gtk, TRUE, 
			FALSE, 0);
    gtk_box_pack_start (GTK_BOX (right_bottom_box), memset_digit_gtk, TRUE, 
			FALSE, 0);
    gtk_widget_show (right_bottom_box);
    gtk_box_pack_start (GTK_BOX (right_box), top_right_strip_gtk, TRUE, FALSE, 
			0);
    gtk_box_pack_start (GTK_BOX (right_box), right_top_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (right_box), right_bottom_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (right_box), bottom_right_strip_gtk, TRUE, 
			FALSE, 0);
    gtk_widget_show (right_box);
    gtk_box_pack_start (GTK_BOX (main_box), leftmost_strip_gtk, TRUE, FALSE, 
			0);
    gtk_box_pack_start (GTK_BOX (main_box), left_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), vertical_strip_gtk[0], TRUE, FALSE,
			0);
    for (i=0; i<4; i++)
	gtk_box_pack_start (GTK_BOX (main_box), freq_digits_gtk[i], TRUE, 
			    FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), dp_gtk, TRUE, FALSE, 0);
    for (i=4; i<6; i++)
	gtk_box_pack_start (GTK_BOX (main_box), freq_digits_gtk[i], TRUE, 
			    FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), vertical_strip_gtk[1], TRUE, FALSE,
			0);
    gtk_box_pack_start (GTK_BOX (main_box), right_box, TRUE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (main_box), rightmost_strip_gtk, TRUE, FALSE, 
			0);
    gtk_widget_show (main_box);
    main_event_box = gtk_event_box_new ();
    gtk_container_add (GTK_CONTAINER (main_event_box), main_box);

    menu = gtk_menu_new ();
    menu_item = gtk_menu_item_new_with_label ("Enter frequency...");
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
			GTK_SIGNAL_FUNC (gradio_setfreq_cb), NULL);
    gtk_widget_show (menu_item);
    /*    menu_item = gtk_menu_item_new_with_label ("Help");
	  gtk_menu_append (GTK_MENU (menu), menu_item);
	  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
	  GTK_SIGNAL_FUNC (gradio_help_cb), NULL);
	  gtk_widget_show (menu_item); */
    menu_item = gtk_menu_item_new_with_label ("About");
    gtk_menu_append (GTK_MENU (menu), menu_item);
    gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
			GTK_SIGNAL_FUNC (gradio_about_cb), NULL);
    gtk_widget_show (menu_item);

    gtk_widget_set_events (main_event_box, GDK_BUTTON_PRESS_MASK);
    gtk_signal_connect_object(GTK_OBJECT(main_event_box), "event",
			      GTK_SIGNAL_FUNC (gradio_button_press_cb), 
			      GTK_OBJECT(menu));
    
    return main_event_box;
}

/* This function is not mine...the GTK docs, perhaps? */
/* create a new hbox with an image and a label packed into it
 * and return the box.. */

GtkWidget *xpm_label_box_d (GtkWidget *parent, gchar **xpm_d, gchar *label_text)
{
    GtkWidget *box1;
    GtkWidget *label;
    GtkWidget *pixmapwid;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;
    
    /* create box for xpm and label */
    box1 = gtk_hbox_new (FALSE, 0);
    gtk_container_border_width (GTK_CONTAINER (box1), 0);
    
    /* get style of button.. I assume it's to get the background color.
     * if someone knows the real reason, please enlighten me. */
    style = gtk_widget_get_style(parent);
    
    /* now on to the xpm stuff.. load xpm */
    pixmap = gdk_pixmap_create_from_xpm_d (parent->window, &mask,
					   &style->bg[GTK_STATE_NORMAL],
					   xpm_d);
    pixmapwid = gtk_pixmap_new (pixmap, mask);
    
    /* create label for button */
    label = gtk_label_new (label_text);
    
    /* pack the pixmap and label into the box */
    gtk_box_pack_start (GTK_BOX (box1),
			pixmapwid, TRUE, FALSE, 0);
    
    gtk_widget_show(pixmapwid);
    
    return (box1);
}

void gradio_pixmap_inits (GtkWidget *w)
{
    GdkBitmap *mask;
    GtkStyle *style = gtk_widget_get_style (w);
    int i;
    vertical_strip = gdk_pixmap_create_from_xpm_d (w->window, 
						   &vertical_strip_mask, 
						   &style
						   ->bg[GTK_STATE_NORMAL],
						   (gchar**) vertical_strip_d);
    vertical_strip_gtk[0] = gtk_pixmap_new (vertical_strip, 
					    vertical_strip_mask);
    vertical_strip_gtk[1] = gtk_pixmap_new (vertical_strip, 
					    vertical_strip_mask);
    small_v = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_v_d);
    small_t = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_t_d);
    small_m = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_m_d);
    small_k = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_k_d);
    small_d = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_d_d);
    small_f = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_f_d);
    small_s = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar**) small_s_d);
    small_blank = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						&style->bg[GTK_STATE_NORMAL],
						(gchar**) small_blank_d);
    small_digits[0] = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_0_d);
    small_digits[1] = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_1_d);
    small_digits[2] = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_2_d);
    small_digits[3] = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_3_d);
    small_digits[4] = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_4_d);
    small_digits[5] = gdk_pixmap_create_from_xpm_d (w->window, &small_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_5_d);
    small_digits[6] = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_6_d);
    small_digits[7] = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_7_d);
    small_digits[8] = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_8_d);
    small_digits[9] = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) small_9_d);
    large_blank = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						&style->bg[GTK_STATE_NORMAL],
						(gchar**) large_blank_d);
    large_digits[0] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_0_d);
    large_digits[1] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_1_d);
    large_digits[2] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_2_d);
    large_digits[3] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_3_d);
    large_digits[4] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_4_d);
    large_digits[5] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_5_d);
    large_digits[6] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_6_d);
    large_digits[7] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_7_d);
    large_digits[8] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_8_d);
    large_digits[9] = gdk_pixmap_create_from_xpm_d (w->window, &large_mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) large_9_d);
    leftmost_strip = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						   &style
						   ->bg[GTK_STATE_NORMAL],
						   (gchar**) leftmost_strip_d);
    leftmost_strip_gtk = gtk_pixmap_new (leftmost_strip, mask);
    rightmost_strip = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						    &style
						    ->bg[GTK_STATE_NORMAL],
						    (gchar**) 
						    rightmost_strip_d);
    rightmost_strip_gtk = gtk_pixmap_new (rightmost_strip, mask);
    top_left_strip = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						   &style
						   ->bg[GTK_STATE_NORMAL],
						   (gchar**) top_left_strip_d);
    top_left_strip_gtk = gtk_pixmap_new (top_left_strip, mask);
    bottom_left_strip = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						      &style
						      ->bg[GTK_STATE_NORMAL],
						      (gchar**) 
						      bottom_left_strip_d);
    bottom_left_strip_gtk = gtk_pixmap_new (bottom_left_strip, mask);
    top_right_strip = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						    &style->
						    bg[GTK_STATE_NORMAL],
						    (gchar**) 
						    top_right_strip_d);
    top_right_strip_gtk = gtk_pixmap_new (top_right_strip, mask);
    bottom_right_strip = gdk_pixmap_create_from_xpm_d (w->window, &mask, 
						       &style
						       ->bg[GTK_STATE_NORMAL],
						       (gchar**) 
						       bottom_right_strip_d);
    bottom_right_strip_gtk = gtk_pixmap_new (bottom_right_strip, mask);
    decimal_on = gdk_pixmap_create_from_xpm_d (w->window, &decimal_mask, 
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar**) decimal_on_d);
    decimal_off = gdk_pixmap_create_from_xpm_d (w->window, &decimal_mask, 
						&style->bg[GTK_STATE_NORMAL],
						(gchar**) decimal_off_d);
    power_off = gdk_pixmap_create_from_xpm_d (w->window, &power_mask, 
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar**) gr_power_off_xpm);
    power_on = gdk_pixmap_create_from_xpm_d (w->window, &power_mask, 
					     &style->bg[GTK_STATE_NORMAL],
					     (gchar**) gr_power_on_xpm);
    power = gtk_pixmap_new (power_on, power_mask);
    
    volume_ind_gtk = gtk_pixmap_new (small_v, small_mask);
    for (i=0; i<3; i++)
	volume_digits_gtk[i] = gtk_pixmap_new (small_blank, small_mask);
    tuned_ind_gtk = gtk_pixmap_new (small_blank, small_mask);
    muted_ind_gtk = gtk_pixmap_new (small_blank, small_mask);
    if_ind_gtk = gtk_pixmap_new (small_blank, small_mask);
    empty_ind_gtk = gtk_pixmap_new (small_blank, small_mask);
    for (i=0; i<6; i++)
	freq_digits_gtk[i] = gtk_pixmap_new (large_blank, large_mask);
    dp_gtk = gtk_pixmap_new (decimal_off, decimal_mask);
    band_ind_left_gtk = gtk_pixmap_new (small_f, small_mask);
    band_ind_right_gtk = gtk_pixmap_new (small_m, small_mask);
    memset_ind_gtk = gtk_pixmap_new (small_blank, small_mask);
    memset_digit_gtk = gtk_pixmap_new (small_blank, small_mask);
    gtk_widget_show (leftmost_strip_gtk);
    gtk_widget_show (rightmost_strip_gtk);
    gtk_widget_show (top_left_strip_gtk);
    gtk_widget_show (top_right_strip_gtk);
    gtk_widget_show (bottom_left_strip_gtk);
    gtk_widget_show (bottom_right_strip_gtk);
    gtk_widget_show (vertical_strip_gtk[0]);
    gtk_widget_show (vertical_strip_gtk[1]);
    gtk_widget_show (power);
    gtk_widget_show (dp_gtk);
    gtk_widget_show (volume_ind_gtk);
    gtk_widget_show (tuned_ind_gtk);
    gtk_widget_show (if_ind_gtk);
    gtk_widget_show (muted_ind_gtk);
    gtk_widget_show (memset_ind_gtk);
    gtk_widget_show (memset_digit_gtk);
    gtk_widget_show (band_ind_left_gtk);
    gtk_widget_show (band_ind_right_gtk);
    gtk_widget_show (empty_ind_gtk);
    for (i=0; i<3; i++) {
	gtk_widget_show (volume_digits_gtk[i]);
	gtk_widget_show (freq_digits_gtk[i]);
    }
    for (i=3; i<6; i++)
	gtk_widget_show (freq_digits_gtk[i]);
	
}

void gradio_set_display_from_status (void)
{
    int i;

    if (gr_stat.power == FALSE) { /* Blank the whole display */
	gtk_pixmap_set (GTK_PIXMAP (volume_ind_gtk), small_blank, small_mask);
	for (i=0; i<3; i++) {
	    gtk_pixmap_set (GTK_PIXMAP (volume_digits_gtk[i]), small_blank, 
			    small_mask);
	    gtk_pixmap_set (GTK_PIXMAP (freq_digits_gtk[i]), large_blank, 
			    large_mask);
	}
	for (i=3; i<6; i++)
	    gtk_pixmap_set (GTK_PIXMAP (freq_digits_gtk[i]), large_blank, 
			    large_mask);
	gtk_pixmap_set (GTK_PIXMAP (power), power_off, power_mask);
	gtk_pixmap_set (GTK_PIXMAP (tuned_ind_gtk), small_blank, small_mask);
	gtk_pixmap_set (GTK_PIXMAP (muted_ind_gtk), small_blank, small_mask);
	gtk_pixmap_set (GTK_PIXMAP (if_ind_gtk), small_blank, small_mask);
	gtk_pixmap_set (GTK_PIXMAP (dp_gtk), decimal_off, decimal_mask);
	gtk_pixmap_set (GTK_PIXMAP (band_ind_left_gtk), small_blank, 
			small_mask);
	gtk_pixmap_set (GTK_PIXMAP (band_ind_right_gtk), small_blank, 
			small_mask);
	gtk_pixmap_set (GTK_PIXMAP (memset_ind_gtk), small_blank, small_mask);
	gtk_pixmap_set (GTK_PIXMAP (memset_digit_gtk), small_blank, 
			small_mask);
	return;
    }
    
    gtk_pixmap_set (GTK_PIXMAP (power), power_off, power_mask);
    if (gr_stat.muted == TRUE)
	gtk_pixmap_set (GTK_PIXMAP (muted_ind_gtk), small_m, small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (muted_ind_gtk), small_blank, small_mask);
    if (TRUE) /* We ALWAYS use the kernel interface now */
	gtk_pixmap_set (GTK_PIXMAP (if_ind_gtk), small_k, small_mask);
    else /* Unreached */
	gtk_pixmap_set (GTK_PIXMAP (if_ind_gtk), small_d, small_mask);
    if (gr_stat.tuned)
	gtk_pixmap_set (GTK_PIXMAP (tuned_ind_gtk), small_t, small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (tuned_ind_gtk), small_blank, small_mask);
    if (TRUE)
	gtk_pixmap_set (GTK_PIXMAP (volume_ind_gtk), small_v, small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (volume_ind_gtk), small_blank, small_mask);
    for (i=0; i<3; i++)
	gtk_pixmap_set (GTK_PIXMAP (volume_digits_gtk[i]), 
			/* Extract digit */
			small_digits[((int)
				      (gr_stat.vol * (100. / (float)GR_VOL_MAX)
						      / (float)(pow(10,2-i))
						      +((i==2)?.5:0)))%10],
				    small_mask);
    if (TRUE) /* Huh? */
	gtk_pixmap_set (GTK_PIXMAP (band_ind_left_gtk), small_f, small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (band_ind_left_gtk), small_blank, 
			small_mask);
    if (TRUE) /* ... */
	gtk_pixmap_set (GTK_PIXMAP (band_ind_right_gtk), small_m, small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (band_ind_right_gtk), small_blank, 
			small_mask);
    if (TRUE)
	gtk_pixmap_set (GTK_PIXMAP (memset_ind_gtk), small_blank, small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (memset_ind_gtk), small_blank, small_mask);
    if (gr_stat.memset != -1)
	gtk_pixmap_set (GTK_PIXMAP (memset_digit_gtk), 
			small_digits[gr_stat.memset], small_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (memset_digit_gtk), small_blank, 
			small_mask);
    gtk_pixmap_set (GTK_PIXMAP (freq_digits_gtk[1]), 
		    /* Extract digit */
		    (gr_stat.freq<100000) ? large_blank 
		    : large_digits[((gr_stat.freq)/(int)(pow (10, (5-0))))%10],
		    large_mask);
    for (i=2; i<6; i++)
	gtk_pixmap_set (GTK_PIXMAP (freq_digits_gtk[i]), 
			/* Extract digit */
			large_digits[((gr_stat.freq)/(int)(pow(10,(6-i))))%10],
 			large_mask);
    if (TRUE) /* ... */
	gtk_pixmap_set (GTK_PIXMAP (dp_gtk), decimal_on, decimal_mask);
    else
	gtk_pixmap_set (GTK_PIXMAP (dp_gtk), decimal_off, decimal_mask);
}
